/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.bundles;

import com.sun.identity.tools.bundles.SetupConstants;
import java.io.File;
import java.io.FileFilter;

public class GeneralFileFilter
implements FileFilter,
SetupConstants {
    protected String fileNamePattern;
    protected char wildCard;

    public GeneralFileFilter(String fileNamePattern) {
        this(fileNamePattern, '*');
    }

    public GeneralFileFilter(String fileNamePattern, char wildCard) {
        this.fileNamePattern = fileNamePattern;
        this.wildCard = wildCard;
    }

    public boolean accept(File path) {
        if (path.exists()) {
            if (path.isDirectory()) {
                return true;
            }
            String tempPattern = this.fileNamePattern.trim();
            String fileName = path.getName();
            int fileNameOffset = 0;
            boolean matched = true;
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < tempPattern.length(); ++i) {
                if (tempPattern.charAt(i) != this.wildCard) {
                    buffer.append(tempPattern.charAt(i));
                }
                if (i != tempPattern.length() - 1 && tempPattern.charAt(i) != this.wildCard || buffer.length() <= 0) continue;
                int matchedIndex = fileName.indexOf(buffer.toString(), fileNameOffset);
                if (matchedIndex >= fileNameOffset) {
                    if (i != tempPattern.length() - 1) {
                        fileNameOffset = matchedIndex + buffer.length();
                    } else if (tempPattern.charAt(i) != this.wildCard && fileName.substring(matchedIndex).length() != buffer.length()) {
                        matched = false;
                        break;
                    }
                } else {
                    matched = false;
                    break;
                }
                buffer = new StringBuffer();
            }
            return matched;
        }
        return false;
    }
}

