/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.bundles;

import com.sun.identity.tools.bundles.SetupConstants;
import com.sun.identity.tools.bundles.SetupUtils;
import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class SessionMain
implements SetupConstants {
    public static void main(String[] args) {
        block17: {
            String destPath = null;
            String currentOS = null;
            Properties configProp = new Properties();
            ResourceBundle bundle = ResourceBundle.getBundle(System.getProperty("file.setup", "com.sun.identity.tools.bundles.amsessiontoolssetup"));
            if (System.getProperty("help.print") != null && System.getProperty("help.print").equals("yes")) {
                SetupUtils.printUsage(bundle);
                System.exit(0);
            }
            currentOS = SetupUtils.determineOS();
            destPath = System.getProperty("path.dest");
            try {
                if (destPath != null && destPath.trim().length() > 0 && (destPath.indexOf("/") > -1 || destPath.indexOf("\\") > -1)) {
                    System.out.println(bundle.getString("message.error.inputformat"));
                    destPath = null;
                }
                while (destPath == null || destPath.trim().length() == 0) {
                    destPath = SetupUtils.getUserInput(bundle.getString(currentOS + ".question"));
                    if (destPath == null || destPath.trim().length() <= 0 || destPath.indexOf("/") <= -1 && destPath.indexOf("\\") <= -1) continue;
                    System.out.println(bundle.getString("message.error.inputformat"));
                    destPath = null;
                }
            }
            catch (IOException ex) {
                System.out.println(bundle.getString("message.error.input"));
                System.out.println(ex.getMessage());
                System.exit(1);
            }
            configProp.setProperty("UserInput", destPath);
            configProp.setProperty("CurrentPlatform", currentOS);
            SetupUtils.evaluateBundleValues(bundle, configProp);
            try {
                SetupUtils.copyAndFilterScripts(bundle, configProp);
            }
            catch (IOException ex) {
                System.out.println(bundle.getString("message.error.copy"));
                System.exit(1);
            }
            String extDir = null;
            try {
                extDir = bundle.getString("dir.ext");
            }
            catch (MissingResourceException ex) {
                extDir = "ext";
            }
            String jmqDir = null;
            try {
                jmqDir = bundle.getString("dir.jmq");
            }
            catch (MissingResourceException ex) {
                jmqDir = "jmq";
            }
            try {
                String jmqFileName = bundle.getString(currentOS + ".jmq");
                if (currentOS.equals("windows")) {
                    SetupUtils.unzip(extDir + FILE_SEPARATOR + jmqFileName, jmqDir, true);
                    System.out.println(bundle.getString("message.info.jmq.success") + " " + new File(".").getCanonicalPath() + FILE_SEPARATOR + jmqDir);
                    break block17;
                }
                Process proc = Runtime.getRuntime().exec("unzip -o -q " + extDir + FILE_SEPARATOR + jmqFileName + " -d " + jmqDir);
                try {
                    if (proc.waitFor() != 0) {
                        System.out.println(bundle.getString("message.info.jmq.fail") + " " + new File(".").getCanonicalPath() + FILE_SEPARATOR + jmqDir);
                        break block17;
                    }
                    System.out.println(bundle.getString("message.info.jmq.success") + " " + new File(".").getCanonicalPath() + FILE_SEPARATOR + jmqDir);
                }
                catch (InterruptedException ex) {
                    System.out.println(bundle.getString("message.info.jmq.fail") + " " + new File(".").getCanonicalPath() + FILE_SEPARATOR + jmqDir);
                }
            }
            catch (IOException ex) {
                System.out.println(bundle.getString("message.error.jmq"));
                System.out.println(bundle.getString("message.info.jmq.fail") + " " + jmqDir + ".");
            }
        }
    }
}

