/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.sun.identity.shared.debug.Debug;
import java.security.Principal;

public class UMSObject {
    public static final String UMS = "UMS";
    public static final String ENTITY = "ENTITY";
    public static final String UTIL = "UTIL";
    private static Debug debug = Debug.getInstance((String)"amSDK");
    private static I18n i18n = I18n.getInstance("amSDK");

    public static PersistentObject getObject(SSOToken token, Guid guid) throws UMSException {
        return UMSObject.getObject(token, guid, null);
    }

    public static PersistentObject getObject(SSOToken token, Guid guid, String[] attrNames) throws UMSException {
        Principal principal = null;
        try {
            SSOTokenManager.getInstance().validateToken(token);
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), (Throwable)((Object)se));
        }
        try {
            principal = token.getPrincipal();
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-badsesshdl"), (Throwable)((Object)se));
        }
        return UMSObject.getObject(principal, guid, attrNames);
    }

    public static void removeObject(SSOToken token, Guid guid) throws EntryNotFoundException, UMSException {
        try {
            SSOTokenManager.getInstance().validateToken(token);
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), (Throwable)((Object)se));
        }
        try {
            DataLayer.getInstance().deleteEntry(token.getPrincipal(), guid);
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-badsesshdl"), (Throwable)((Object)se));
        }
    }

    public static PersistentObject getObject(Principal principal, Guid guid) throws UMSException {
        return UMSObject.getObject(principal, guid, null);
    }

    public static PersistentObject getObject(Principal principal, Guid guid, String[] attrNames) throws UMSException {
        AttrSet attrSet = null;
        if (attrNames == null) {
            attrSet = DataLayer.getInstance().read(principal, guid);
        } else {
            int length = attrNames.length;
            String[] attrNames1 = new String[length + 1];
            System.arraycopy(attrNames, 0, attrNames1, 0, length);
            attrNames1[length] = "objectclass";
            attrSet = DataLayer.getInstance().read(principal, guid, attrNames1);
        }
        String id = guid.getDn();
        if (id == null) {
            String msg = i18n.getString("ums-badid");
            throw new IllegalArgumentException(msg);
        }
        Class javaClass = TemplateManager.getTemplateManager().getJavaClassForEntry(id, attrSet);
        PersistentObject po = null;
        try {
            po = (PersistentObject)javaClass.newInstance();
        }
        catch (Exception e) {
            Object[] args = new String[]{e.toString()};
            String msg = i18n.getString("ums-newinstancefailed", args);
            throw new UMSException(msg);
        }
        po.setAttrSet(attrSet);
        po.setGuid(guid);
        po.setPrincipal(principal);
        return po;
    }

    public static PersistentObject getObjectHandle(SSOToken token, Guid guid) throws UMSException {
        String dn = guid.getDn();
        if (token == null || dn == null) {
            String msg;
            if (token == null) {
                msg = i18n.getString("ums-null-token");
                debug.error("UMSObject.PersistentObject: token is null");
            } else {
                msg = i18n.getString("ums-badguid");
                debug.error("UMSObject.PersistentObject: dn is null");
            }
            throw new UMSException(msg);
        }
        Principal principal = null;
        try {
            SSOTokenManager.getInstance().validateToken(token);
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), (Throwable)((Object)se));
        }
        try {
            principal = token.getPrincipal();
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-badsesshdl"), (Throwable)((Object)se));
        }
        PersistentObject po = new PersistentObject();
        po.setGuid(guid);
        po.setPrincipal(principal);
        return po;
    }
}

