/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.agentconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.common.configuration.AgentConfiguration;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class RemoveAgentsFromGroup
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String agentGroupName = this.getStringOptionValue("agentgroupname");
        List agentNames = rc.getOption("agentnames");
        String[] params = new String[]{realm, agentGroupName, ""};
        String agentName = "";
        try {
            AMIdentity agentGroup = new AMIdentity(adminSSOToken, agentGroupName, IdType.AGENTGROUP, realm, null);
            if (!agentGroup.isExists()) {
                Object[] p = new Object[]{agentGroupName};
                throw new CLIException(MessageFormat.format(this.getResourceString("remove-agent-to-group-agent-invalid-group"), p), 127);
            }
            this.validateAgents(realm, adminSSOToken, agentGroup, agentNames);
            Iterator i = agentNames.iterator();
            while (i.hasNext()) {
                params[2] = agentName = (String)i.next();
                this.writeLog(0, Level.INFO, "ATTEMPT_REMOVE_AGENT_FROM_GROUP", params);
                AMIdentity amid = new AMIdentity(adminSSOToken, agentName, IdType.AGENTONLY, realm, null);
                AgentConfiguration.removeAgentGroup(amid, agentGroup);
                this.writeLog(0, Level.INFO, "SUCCEED_REMOVE_AGENT_FROM_GROUP", params);
            }
            if (agentNames.size() > 1) {
                outputWriter.printlnMessage(this.getResourceString("remove-agent-to-group-succeeded-pural"));
            } else {
                outputWriter.printlnMessage(this.getResourceString("remove-agent-to-group-succeeded"));
            }
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, agentGroupName, agentName, e.getMessage()};
            this.debugError("RemoveAgentsFromGroup.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_AGENT_FROM_GROUP", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, agentGroupName, agentName, e.getMessage()};
            this.debugError("RemoveAgentsFromGroup.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_AGENT_FROM_GROUP", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, agentGroupName, agentName, e.getMessage()};
            this.debugError("RemoveAgentsFromGroup.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_REMOVE_AGENT_FROM_GROUP", args);
            throw new CLIException(e, 127);
        }
    }

    private void validateAgents(String realm, SSOToken adminSSOToken, AMIdentity agentGroup, List agentNames) throws CLIException, IdRepoException, SSOException {
        for (String agentName : agentNames) {
            AMIdentity amid = new AMIdentity(adminSSOToken, agentName, IdType.AGENTONLY, realm, null);
            if (amid.isMember(agentGroup)) continue;
            Object[] p = new Object[]{agentName, agentGroup.getName()};
            throw new CLIException(MessageFormat.format(this.getResourceString("remove-agent-to-group-agent-not-member"), p), 127);
        }
    }
}

