/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.realm;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.realm.RMRealmOpViewBeanBase;
import com.sun.identity.console.realm.RMRealmViewBean;
import com.sun.identity.console.realm.model.RMRealmModel;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCSelectableList;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RMRealmAddViewBean
extends RMRealmOpViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/realm/RMRealmAdd.jsp";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private AMPropertySheetModel propertySheetModel;

    public RMRealmAddViewBean() {
        super("RMRealmAdd");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createPageTitleModel();
        this.createPropertyModel();
        this.registerChildren();
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.registerChild("tfName", CCTextField.class);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : super.createChild(name)));
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.populateRealmParentList();
        this.setDefaultValues();
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/twoBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.ok");
        this.ptModel.setValue("button2", (Object)"button.cancel");
    }

    private void createPropertyModel() {
        RMRealmModel model = (RMRealmModel)this.getModel();
        try {
            this.propertySheetModel = new AMPropertySheetModel(model.getCreateRealmPropertyXML());
            this.propertySheetModel.clear();
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    private void populateRealmParentList() {
        RMRealmModel model = (RMRealmModel)this.getModel();
        Set realms = new HashSet();
        try {
            realms = model.getRealmNames(model.getStartDN(), "*");
        }
        catch (AMConsoleException a) {
            // empty catch block
        }
        HashMap<String, String> display = new HashMap<String, String>(realms.size() * 2);
        for (String tmp : realms) {
            String path = this.getPath(tmp);
            display.put(tmp, path);
        }
        OptionList optionList = this.createOptionList(display);
        CCSelectableList parentList = (CCSelectableList)this.getChild("tfParent");
        parentList.setOptions(optionList);
        String value = (String)parentList.getValue();
        if (value == null || value.length() == 0) {
            Option opt = optionList.get(0);
            parentList.setValue((Object)opt.getValue());
        }
    }

    private void setDefaultValues() {
        RMRealmModel model = (RMRealmModel)this.getModel();
        Map defaultValues = model.getDefaultValues();
        AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
        ps.setAttributeValues(defaultValues, model);
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.backTrail();
        RMRealmViewBean vb = (RMRealmViewBean)this.getViewBean(RMRealmViewBean.class);
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        RMRealmModel model = (RMRealmModel)this.getModel();
        AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTE);
        String realmName = (String)this.getDisplayFieldValue("tfName");
        realmName = realmName.trim();
        String parent = (String)this.getDisplayFieldValue("tfParent");
        parent = parent != null ? parent.trim() : model.getStartDN();
        if (realmName.length() > 0) {
            try {
                Map values = ps.getAttributeValues(model.getDataMap(), false, model);
                model.createSubRealm(parent, realmName, values);
                this.backTrail();
                RMRealmViewBean vb = (RMRealmViewBean)this.getViewBean(RMRealmViewBean.class);
                this.passPgSessionMap((ViewBean)vb);
                vb.forwardTo(this.getRequestContext());
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.forwardTo();
            }
        } else {
            this.setInlineAlertMessage("error", "message.error", "realm.missing.realmName");
            this.forwardTo();
        }
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.addrealm";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

