/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Cache;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.identity.shared.debug.Debug;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class OrgReferral
implements Referral {
    protected static final Debug DEBUG = Debug.getInstance((String)"amPolicy");
    protected static final String CAN_NOT_GET_VALUES_FOR_REFERRAL = "can_not_get_values_for_referral";
    private Set _values;
    protected Map _configurationMap;
    protected String _orgName;
    protected Cache cachedPolicyEvaluators = new Cache(50);

    public void initialize(Map configurationMap) {
        this._configurationMap = configurationMap;
    }

    public void setValues(Set values) throws InvalidNameException {
        if (values.isEmpty() || values.size() > 1) {
            throw new InvalidNameException("amPolicy", "invalid_organization", null, "", 4);
        }
        this._values = values;
        Iterator items = values.iterator();
        this._orgName = (String)items.next();
    }

    public Set getValues() {
        return this._values;
    }

    public String getDisplayNameForValue(String value, Locale locale) throws NameNotFoundException {
        String displayName = null;
        try {
            displayName = PolicyUtils.getDisplayName(value);
        }
        catch (Exception e) {
            Object[] objs = new String[]{value};
            throw new NameNotFoundException("amPolicy", "role_name_not_present", objs, value, 5);
        }
        return displayName;
    }

    public abstract ValidValues getValidValues(SSOToken var1) throws SSOException, PolicyException;

    public abstract ValidValues getValidValues(SSOToken var1, String var2) throws SSOException, PolicyException;

    public Syntax getValueSyntax(SSOToken token) throws SSOException, PolicyException {
        Syntax syntax = Syntax.NONE;
        ValidValues values = this.getValidValues(token);
        Set validValues = values.getSearchResults();
        syntax = validValues == null || validValues.isEmpty() ? Syntax.NONE : Syntax.SINGLE_CHOICE;
        return syntax;
    }

    public abstract String getReferralTypeName();

    public PolicyDecision getPolicyDecision(SSOToken token, String resourceType, String resourceName, Set actionNames, Map envParameters) throws SSOException, PolicyException {
        PolicyEvaluator policyEvaluator = null;
        StringBuffer cacheNameBuffer = new StringBuffer();
        String cacheName = cacheNameBuffer.append(this._orgName).append(resourceType).toString();
        policyEvaluator = (PolicyEvaluator)this.cachedPolicyEvaluators.get(cacheName);
        if (policyEvaluator == null) {
            policyEvaluator = new PolicyEvaluator(this._orgName, resourceType);
            this.cachedPolicyEvaluators.put(cacheName, policyEvaluator);
        }
        return policyEvaluator.getPolicyDecision(token, resourceName, actionNames, envParameters);
    }

    public Set getResourceNames(SSOToken token, String serviceTypeName, String resourceName) throws PolicyException, SSOException {
        Set resourceNames = null;
        PolicyEvaluator policyEvaluator = null;
        StringBuffer cacheNameBuffer = new StringBuffer();
        String cacheName = cacheNameBuffer.append(this._orgName).append(serviceTypeName).toString();
        policyEvaluator = (PolicyEvaluator)this.cachedPolicyEvaluators.get(cacheName);
        if (policyEvaluator == null) {
            policyEvaluator = new PolicyEvaluator(this._orgName, serviceTypeName);
            this.cachedPolicyEvaluators.put(cacheName, policyEvaluator);
        }
        resourceNames = policyEvaluator.getResourceNames(token, resourceName, true);
        return resourceNames;
    }
}

