/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.provider;

import com.sun.identity.liberty.ws.common.Status;
import com.sun.identity.liberty.ws.disco.Description;
import com.sun.identity.liberty.ws.disco.Directive;
import com.sun.identity.liberty.ws.disco.DiscoveryClient;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.InsertEntry;
import com.sun.identity.liberty.ws.disco.Modify;
import com.sun.identity.liberty.ws.disco.ModifyResponse;
import com.sun.identity.liberty.ws.disco.QueryResponse;
import com.sun.identity.liberty.ws.disco.RemoveEntry;
import com.sun.identity.liberty.ws.disco.ResourceID;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.ServiceInstance;
import com.sun.identity.wss.provider.ProviderConfig;
import com.sun.identity.wss.provider.ProviderException;
import com.sun.identity.wss.provider.ProviderUtils;
import com.sun.identity.wss.provider.TrustAuthorityConfig;
import com.sun.identity.wss.security.SecurityMechanism;
import java.util.ArrayList;
import java.util.List;

public abstract class DiscoveryConfig
extends TrustAuthorityConfig {
    protected String authServiceEndpoint = null;

    public String getAuthServiceEndPoint() {
        return this.authServiceEndpoint;
    }

    public void setAuthServiceEndPoint(String authServiceEndpoint) {
        this.authServiceEndpoint = authServiceEndpoint;
    }

    public void registerProviderWithTA(ProviderConfig config, String serviceURI) throws ProviderException {
        this.registerProviderWithTA(config, serviceURI, false);
    }

    public void registerProviderWithTA(ProviderConfig config, String serviceURI, boolean unregister) throws ProviderException {
        try {
            Modify modifyReq;
            DiscoveryClient discoClient;
            ModifyResponse response;
            Status status;
            if (unregister) {
                this.unregisterProviderWithTA(serviceURI);
            }
            if ((status = (response = (discoClient = new DiscoveryClient(this.endpoint, null)).modify(modifyReq = this.getDiscoveryModify(config, serviceURI))).getStatus()) != null) {
                if (status.getCode().getLocalPart().equalsIgnoreCase("OK")) {
                    return;
                }
                throw new ProviderException(ProviderUtils.bundle.getString("registrationFailed"));
            }
            throw new ProviderException(ProviderUtils.bundle.getString("registrationFailed"));
        }
        catch (DiscoveryException de) {
            ProviderUtils.debug.error("DiscoveryConfig.registerProviderWithTA: is failed", (Throwable)de);
            throw new ProviderException(ProviderUtils.bundle.getString("registrationFailed"));
        }
    }

    public void unregisterProviderWithTA(String serviceURI) throws ProviderException {
        try {
            DiscoveryClient client = new DiscoveryClient(this.endpoint, null);
            client.setResourceID("urn:liberty:isf:implied-resource");
            ArrayList<String> types = new ArrayList<String>();
            types.add(serviceURI);
            QueryResponse result = client.getResourceOffering(types);
            List offerings = result.getResourceOffering();
            if (offerings == null || offerings.isEmpty()) {
                if (ProviderUtils.debug.messageEnabled()) {
                    ProviderUtils.debug.message("DiscoveryConfig.unregisterProviderWithTA:: There are no resource offerings");
                }
                return;
            }
            ResourceOffering offering = (ResourceOffering)offerings.get(0);
            String entryID = offering.getEntryID();
            RemoveEntry remove = new RemoveEntry(entryID);
            ArrayList<RemoveEntry> removes = new ArrayList<RemoveEntry>();
            removes.add(remove);
            Modify modify = new Modify();
            ResourceID resourceID = new ResourceID("urn:liberty:isf:implied-resource");
            modify.setResourceID(resourceID);
            modify.setRemoveEntry(removes);
            client.modify(modify);
        }
        catch (DiscoveryException de) {
            ProviderUtils.debug.error("DiscoveryConfig.unregisterProviderWithTA: is failed", (Throwable)de);
            throw new ProviderException(ProviderUtils.bundle.getString("unregisterFailed"));
        }
    }

    private Modify getDiscoveryModify(ProviderConfig config, String serviceURI) throws ProviderException {
        List securityMech = config.getSecurityMechanisms();
        ArrayList<String> libertyMech = new ArrayList<String>();
        for (String secMech : securityMech) {
            if (!this.isLibertySecurityMechanism(secMech)) continue;
            libertyMech.add(secMech);
        }
        if (libertyMech.isEmpty()) {
            throw new ProviderException(ProviderUtils.bundle.getString("noLibertyMechanisms"));
        }
        ArrayList directives = new ArrayList();
        for (String mech : libertyMech) {
            this.getDirectives(mech, directives);
        }
        ResourceID resourceID = new ResourceID("urn:liberty:isf:implied-resource");
        Description description = new Description(config.getSecurityMechanisms(), null, config.getWSPEndpoint());
        ArrayList<Description> descriptions = new ArrayList<Description>();
        descriptions.add(description);
        ServiceInstance serviceInstance = new ServiceInstance(serviceURI, config.getProviderName(), descriptions);
        ResourceOffering offering = new ResourceOffering(resourceID, serviceInstance);
        InsertEntry insertEntry = new InsertEntry(offering, null);
        if (!directives.isEmpty()) {
            insertEntry.setAny(directives);
        }
        ArrayList<InsertEntry> insertEntries = new ArrayList<InsertEntry>();
        insertEntries.add(insertEntry);
        return new Modify(resourceID, insertEntries, null);
    }

    private boolean isLibertySecurityMechanism(String mechanism) {
        if (mechanism == null) {
            return false;
        }
        return SecurityMechanism.getLibertySecurityMechanismURIs().contains(mechanism);
    }

    private void getDirectives(String mechanism, List directives) {
        if (mechanism == null) {
            return;
        }
        if ("urn:liberty:security:2005-02:null:SAML".equals(mechanism) || "urn:liberty:security:2005-02:TLS:SAML".equals(mechanism) || "urn:liberty:security:2005-02:ClientTLS:SAML".equals(mechanism)) {
            Directive dir1 = new Directive("AuthenticateRequester");
            directives.add(dir1);
        } else if ("urn:liberty:security:2005-02:null:Bearer".equals(mechanism) || "urn:liberty:security:2005-02:TLS:Bearer".equals(mechanism) || "urn:liberty:security:2005-02:ClientTLS:Bearer".equals(mechanism)) {
            Directive dir1 = new Directive("AuthenticateRequester");
            directives.add(dir1);
            Directive dir2 = new Directive("GenerateBearerToken");
            directives.add(dir2);
        }
    }
}

