/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.provider;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.provider.DiscoveryConfig;
import com.sun.identity.wss.provider.ProviderException;
import com.sun.identity.wss.provider.ProviderUtils;
import com.sun.identity.wss.provider.STSConfig;
import java.security.AccessController;
import java.util.List;

public abstract class TrustAuthorityConfig {
    protected String endpoint;
    protected String privateKeyAlias = null;
    protected String publicKeyAlias = null;
    protected String name;
    protected String type;
    protected List secMech = null;
    protected boolean isResponseSigned = false;
    protected boolean isResponseEncrypted = false;
    protected boolean isRequestSigned = true;
    protected boolean isRequestEncrypted = false;
    protected boolean isRequestHeaderEncrypted = false;
    protected List usercredentials = null;
    protected String encryptionAlgorithm = "DESede";
    protected int encryptionStrength = 0;
    protected String signingRefType = "DirectReference";
    private static Class discoveryConfigClass;
    private static Class stsConfigClass;
    private static Debug debug;
    protected static SSOToken customAdminToken;
    public static final String WSS_DISCOVERY_CONFIG_PLUGIN = "com.sun.identity.wss.discovery.config.plugin";
    public static final String WSS_STS_CONFIG_PLUGIN = "com.sun.identity.wss.sts.config.plugin";
    public static final String DISCOVERY_TRUST_AUTHORITY = "DiscoveryAgent";
    public static final String STS_TRUST_AUTHORITY = "STSAgent";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getKeyAlias() {
        return this.privateKeyAlias;
    }

    public void setKeyAlias(String alias) {
        this.privateKeyAlias = alias;
    }

    public String getPublicKeyAlias() {
        return this.publicKeyAlias;
    }

    public void setPublicKeyAlias(String alias) {
        this.publicKeyAlias = alias;
    }

    public void setSecurityMechs(List secMech) {
        this.secMech = secMech;
    }

    public List getSecurityMech() {
        return this.secMech;
    }

    public boolean isResponseSignEnabled() {
        return this.isResponseSigned;
    }

    public void setResponseSignEnabled(boolean enable) {
        this.isResponseSigned = enable;
    }

    public boolean isResponseEncryptEnabled() {
        return this.isResponseEncrypted;
    }

    public void setResponseEncryptEnabled(boolean enable) {
        this.isResponseEncrypted = enable;
    }

    public boolean isRequestSignEnabled() {
        return this.isRequestSigned;
    }

    public void setRequestSignEnabled(boolean enable) {
        this.isRequestSigned = enable;
    }

    public boolean isRequestEncryptEnabled() {
        return this.isRequestEncrypted;
    }

    public void setRequestEncryptEnabled(boolean enable) {
        this.isRequestEncrypted = enable;
    }

    public boolean isRequestHeaderEncryptEnabled() {
        return this.isRequestHeaderEncrypted;
    }

    public void setRequestHeaderEncryptEnabled(boolean enable) {
        this.isRequestHeaderEncrypted = enable;
    }

    public void setUsers(List usercredentials) {
        this.usercredentials = usercredentials;
    }

    public List getUsers() {
        return this.usercredentials;
    }

    public String getSigningRefType() {
        return this.signingRefType;
    }

    public void setSigningRefType(String refType) {
        this.signingRefType = refType;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String encAlg) {
        this.encryptionAlgorithm = encAlg;
    }

    public int getEncryptionStrength() {
        return this.encryptionStrength;
    }

    public void setEncryptionStrength(int keyStrength) {
        this.encryptionStrength = keyStrength;
    }

    protected abstract void init(String var1, String var2, SSOToken var3) throws ProviderException;

    protected abstract void store() throws ProviderException;

    protected abstract void delete() throws ProviderException;

    public static TrustAuthorityConfig getConfig(String name, String type) throws ProviderException {
        TrustAuthorityConfig config = null;
        if (DISCOVERY_TRUST_AUTHORITY.equals(type)) {
            config = TrustAuthorityConfig.getDiscoveryConfig();
            config.init(name, type, TrustAuthorityConfig.getAdminToken());
        } else if (STS_TRUST_AUTHORITY.equals(type)) {
            config = TrustAuthorityConfig.getSTSConfig();
            config.init(name, type, TrustAuthorityConfig.getAdminToken());
        } else {
            throw new ProviderException(ProviderUtils.bundle.getString("unsupportedConfigType"));
        }
        return config;
    }

    public static void saveConfig(TrustAuthorityConfig config) throws ProviderException {
        config.store();
    }

    public static void deleteConfig(String name, String type) throws ProviderException {
        TrustAuthorityConfig config = TrustAuthorityConfig.getConfig(name, type);
        config.delete();
    }

    private static DiscoveryConfig getDiscoveryConfig() throws ProviderException {
        if (discoveryConfigClass == null) {
            String adapterName = SystemConfigurationUtil.getProperty((String)WSS_DISCOVERY_CONFIG_PLUGIN, (String)"com.sun.identity.wss.provider.plugins.DiscoveryAgent");
            try {
                discoveryConfigClass = Class.forName(adapterName);
            }
            catch (Exception ex) {
                debug.error("TrustAuthorityConfig.getDiscoveryConfig:  Failed in creating the discovery config class.");
                throw new ProviderException(ex.getMessage());
            }
        }
        try {
            return (DiscoveryConfig)discoveryConfigClass.newInstance();
        }
        catch (Exception ex) {
            debug.error("TrustAuthorityConfig.getDiscoveryConfig: Failed in initialization", (Throwable)ex);
            throw new ProviderException(ex.getMessage());
        }
    }

    private static STSConfig getSTSConfig() throws ProviderException {
        if (stsConfigClass == null) {
            String adapterName = SystemConfigurationUtil.getProperty((String)WSS_STS_CONFIG_PLUGIN, (String)"com.sun.identity.wss.provider.plugins.STSAgent");
            try {
                stsConfigClass = Class.forName(adapterName);
            }
            catch (Exception ex) {
                debug.error("TrustAuthorityConfig.getSTSConfig:  Failed in creating the STS config class.");
                throw new ProviderException(ex.getMessage());
            }
        }
        try {
            return (STSConfig)stsConfigClass.newInstance();
        }
        catch (Exception ex) {
            debug.error("TrustAuthorityConfig.getSTSConfig: Failed in initialization", (Throwable)ex);
            throw new ProviderException(ex.getMessage());
        }
    }

    private static SSOToken getAdminToken() throws ProviderException {
        if (customAdminToken != null) {
            return customAdminToken;
        }
        SSOToken adminToken = null;
        try {
            adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            if (adminToken != null && !SSOTokenManager.getInstance().isValidToken(adminToken)) {
                if (ProviderUtils.debug.messageEnabled()) {
                    ProviderUtils.debug.message("TrustAuthorityConfig.getAdminToken:AdminTokenAction returned  expired or invalid token, trying again...");
                }
                adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            }
        }
        catch (SSOException se) {
            ProviderUtils.debug.message("TrustAuthorityConfig.getAdminToken: Trying second time..");
            adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        }
        return adminToken;
    }

    public void setAdminToken(SSOToken adminToken) {
        customAdminToken = adminToken;
    }

    static {
        debug = ProviderUtils.debug;
        customAdminToken = null;
    }
}

