/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.IOutput;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Debugger {
    private Debugger() {
    }

    public static void message(CommandManager mgr, String msg) {
        Debugger.dumpToOutput(mgr, msg, null);
        mgr.getDebugger().message(msg, null);
    }

    public static void message(CommandManager mgr, String msg, Throwable t) {
        Debugger.dumpToOutput(mgr, msg, t);
        mgr.getDebugger().message(msg, t);
    }

    public static void warning(CommandManager mgr, String msg) {
        Debugger.dumpToOutput(mgr, msg, null);
        mgr.getDebugger().warning(msg, null);
    }

    public static void warning(CommandManager mgr, String msg, Throwable t) {
        Debugger.dumpToOutput(mgr, msg, t);
        mgr.getDebugger().warning(msg, t);
    }

    public static void error(CommandManager mgr, String msg) {
        Debugger.dumpToOutput(mgr, msg, null);
        mgr.getDebugger().error(msg, null);
    }

    public static void error(CommandManager mgr, String msg, Throwable t) {
        Debugger.dumpToOutput(mgr, msg, t);
        mgr.getDebugger().error(msg, t);
    }

    public static String getStackTrace(Throwable e) {
        StringBuffer buf = new StringBuffer();
        if (e != null) {
            StringWriter stBuf = new StringWriter(300);
            PrintWriter stackStream = new PrintWriter(stBuf);
            e.printStackTrace(stackStream);
            stackStream.flush();
            buf.append(stBuf.toString());
        }
        return buf.toString();
    }

    private static void dumpToOutput(CommandManager mgr, String msg, Throwable t) {
        if (mgr.isDebugOn()) {
            IOutput writer = mgr.getOutputWriter();
            writer.printlnMessage(msg);
            if (t != null) {
                writer.printlnMessage(Debugger.getStackTrace(t));
            }
        }
    }
}

