/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.idrepo.IdentityCommand;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.text.MessageFormat;
import java.util.Set;
import java.util.logging.Level;

public class IsMember
extends IdentityCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        SSOToken adminSSOToken = this.getAdminSSOToken();
        IOutput outputWriter = this.getOutputWriter();
        String realm = this.getStringOptionValue("realm");
        String idName = this.getStringOptionValue("idname");
        String type = this.getStringOptionValue("idtype");
        IdType idType = this.convert2IdType(type);
        String memberIdName = this.getStringOptionValue("memberidname");
        String memberType = this.getStringOptionValue("memberidtype");
        IdType memberIdType = this.convert2IdType(memberType);
        String[] params = new String[]{realm, type, idName, memberIdName, memberType};
        try {
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            Set memberOfs = memberIdType.canBeMemberOf();
            if (!memberOfs.contains(idType)) {
                String[] args = new String[]{type, memberType};
                throw new CLIException(MessageFormat.format(this.getResourceString("idrepo-cannot-be-member"), args), 127);
            }
            this.writeLog(0, Level.INFO, "ATTEMPT_IDREPO_IS_MEMBER", params);
            AMIdentity amid = new AMIdentity(adminSSOToken, idName, idType, realm, null);
            AMIdentity memberAmid = new AMIdentity(adminSSOToken, memberIdName, memberIdType, realm, null);
            String[] args = new String[]{memberIdName, idName};
            if (memberAmid.isMember(amid)) {
                String msg = this.getResourceString("idrepo-ismembers-positive-result");
                outputWriter.printlnMessage(MessageFormat.format(msg, args));
            } else {
                String msg = this.getResourceString("idrepo-ismembers-negative-result");
                outputWriter.printlnMessage(MessageFormat.format(msg, args));
            }
            outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("idrepo-get-ismember-succeed"), params));
            this.writeLog(0, Level.INFO, "SUCCEED_IDREPO_IS_MEMBER", params);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, type, idName, memberIdName, memberType, e.getMessage()};
            this.debugError("IsMember.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_IS_MEMBER", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, type, idName, memberIdName, memberType, e.getMessage()};
            this.debugError("IsMember.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_IDREPO_IS_MEMBER", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
    }
}

