/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.delegation.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.delegation.DelegationEvaluator;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.sm.DNMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DelegationConfigNode {
    private String viewbeanName;
    private Map permissions = new HashMap();
    private Set actionhandlers;
    private Set tables;
    private Set staticTexts;

    DelegationConfigNode(String viewbeanName) {
        this.viewbeanName = viewbeanName;
    }

    void setPermissions(String name, Set perm) {
        this.permissions.put(name, perm);
    }

    void setActionHandlers(Set set) {
        this.actionhandlers = set;
    }

    void setStaticTexts(Set set) {
        this.staticTexts = set;
    }

    void setTables(Set set) {
        this.tables = set;
    }

    boolean hasPermission(String realmName, String serviceName, String action, AMModel model) throws DelegationException {
        return this.hasPermission(realmName, serviceName, action, model.getUserSSOToken());
    }

    boolean hasPermission(String realmName, String serviceName, String action, SSOToken ssoToken) throws DelegationException {
        if (realmName == null) {
            try {
                realmName = DNMapper.orgNameToRealmName(ssoToken.getProperty("Organization"));
            }
            catch (SSOException e) {
                throw new DelegationException((Throwable)((Object)e));
            }
        }
        DelegationEvaluator delegationEvaluator = new DelegationEvaluator();
        DelegationPermission delegationPermission = this.getDelegationPermission(realmName, action);
        boolean allowed = false;
        if (serviceName != null) {
            allowed = this.isAllowed(delegationEvaluator, delegationPermission, ssoToken, serviceName);
        } else {
            Set actions = (Set)this.permissions.get("MODIFY");
            Iterator i = actions.iterator();
            while (i.hasNext() && !allowed) {
                allowed = this.isAllowed(delegationEvaluator, delegationPermission, ssoToken, (String)i.next());
            }
        }
        return allowed;
    }

    private DelegationPermission getDelegationPermission(String realmName, String privilege) throws DelegationException {
        DelegationPermission delegationPermission = new DelegationPermission();
        delegationPermission.setOrganizationName(realmName);
        delegationPermission.setVersion("*");
        HashSet<String> actions = new HashSet<String>(2);
        actions.add(privilege);
        delegationPermission.setActions(actions);
        return delegationPermission;
    }

    boolean configureButtonsAndTables(String realmName, String serviceName, AMModel model, AMViewBeanBase viewbean) throws DelegationException {
        boolean allowed = this.hasPermission(realmName, serviceName, "MODIFY", model);
        if (!allowed) {
            this.blankStaticTexts(viewbean);
            this.disableTables(viewbean);
            this.disableActionhandlers(viewbean);
        }
        return allowed;
    }

    private void blankStaticTexts(AMViewBeanBase viewbean) {
        if (this.staticTexts != null) {
            Iterator i = this.staticTexts.iterator();
            while (i.hasNext()) {
                try {
                    viewbean.addBlankTextField((String)i.next());
                }
                catch (IllegalArgumentException e) {
                    AMModelBase.debug.warning("DelegationConfigNode.blanksStaticTexts" + e.getMessage());
                }
            }
        }
    }

    private void disableTables(AMViewBeanBase viewbean) {
        if (this.tables != null) {
            Iterator i = this.tables.iterator();
            while (i.hasNext()) {
                try {
                    viewbean.hideTableSelectionIcons((String)i.next());
                }
                catch (IllegalArgumentException e) {
                    AMModelBase.debug.warning("DelegationConfigNode.disableTables" + e.getMessage());
                }
            }
        }
    }

    private void disableActionhandlers(AMViewBeanBase viewBean) {
        if (this.actionhandlers != null) {
            Iterator i = this.actionhandlers.iterator();
            while (i.hasNext()) {
                try {
                    viewBean.disableButton((String)i.next(), true);
                }
                catch (IllegalArgumentException e) {
                    AMModelBase.debug.warning("DelegationConfigNode.configureButtons" + e.getMessage());
                }
            }
        }
    }

    boolean isAllowed(DelegationEvaluator delegationEvaluator, DelegationPermission delegationPermission, SSOToken ssoToken, String serviceName) {
        boolean isAllowed = false;
        try {
            delegationPermission.setServiceName(serviceName);
            isAllowed = delegationEvaluator.isAllowed(ssoToken, delegationPermission, Collections.EMPTY_MAP);
        }
        catch (SSOException e) {
            AMModelBase.debug.error("DelegationConfigNode.isAllowed", (Throwable)((Object)e));
        }
        catch (DelegationException e) {
            AMModelBase.debug.error("DelegationConfigNode.isAllowed", (Throwable)e);
        }
        return isAllowed;
    }
}

