/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.util;

import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.policy.util.AuthServiceConfigInfo;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GatewayServletUtils
implements ServiceListener {
    private static Debug debug = Debug.getInstance((String)"amGateway");
    private static String moduleName = null;
    private static ServiceConfigManager sConfigMgr = null;
    private static String CERT_PORT_ATTR = null;
    private static HashMap AuthConfigMap = new HashMap();

    public GatewayServletUtils(ServiceConfigManager scm, String module) {
        sConfigMgr = scm;
        CERT_PORT_ATTR = "iplanet-am-auth-" + module.toLowerCase() + "-port-number";
        moduleName = module;
    }

    public void schemaChanged(String serviceName, String version) {
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
    }

    public void organizationConfigChanged() {
        this.organizationConfigChanged(null, null, null, null, null, 0);
    }

    public void organizationConfigChanged(String orgName) {
        this.organizationConfigChanged(null, null, orgName, null, null, 0);
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
        String certModulePortNumber = null;
        String certModuleLevel = null;
        if (orgName == null) {
            orgName = SMSEntry.getRootSuffix();
        }
        try {
            Set attrs;
            ServiceConfig config = sConfigMgr.getOrganizationConfig(orgName, null);
            Map configAttrs = config.getAttributes();
            if (debug.messageEnabled()) {
                debug.message("GatewayServlet:configAttrs :  " + configAttrs.toString());
            }
            if ((attrs = (Set)configAttrs.get(CERT_PORT_ATTR)) == null) {
                return;
            }
            Iterator values = attrs.iterator();
            if (values.hasNext()) {
                certModulePortNumber = (String)values.next();
            }
            if ((attrs = (Set)configAttrs.get(AMAuthConfigUtils.getAuthLevelAttribute(configAttrs, moduleName))) == null) {
                return;
            }
            values = attrs.iterator();
            if (values.hasNext()) {
                certModuleLevel = (String)values.next();
            }
            AuthServiceConfigInfo info = new AuthServiceConfigInfo(orgName, moduleName, certModulePortNumber, certModuleLevel);
            AuthConfigMap.put(orgName, info);
        }
        catch (Exception e) {
            debug.error("GatewayServletUtils : Unable to get Cert Module Level and/or Port Number", (Throwable)e);
        }
    }

    public String getPortNumber(String orgName) {
        AuthServiceConfigInfo info = this.getAuthConfigInfo(orgName);
        return info.getPortNumber();
    }

    public String getAuthLevel(String orgName) {
        AuthServiceConfigInfo info = this.getAuthConfigInfo(orgName);
        return info.getAuthLevel();
    }

    public AuthServiceConfigInfo getAuthConfigInfo(String orgName) {
        AuthServiceConfigInfo info = (AuthServiceConfigInfo)AuthConfigMap.get(orgName);
        if (info == null) {
            this.organizationConfigChanged(orgName);
            info = (AuthServiceConfigInfo)AuthConfigMap.get(orgName);
        }
        return info;
    }
}

