/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.spi;

import com.iplanet.services.util.Crypt;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.spi.AMPostAuthProcessInterface;
import com.sun.identity.authentication.spi.AuthenticationException;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import java.security.AccessController;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WSSReplayPasswd
implements AMPostAuthProcessInterface {
    private static final String PASSWORD_TOKEN = "IDToken2";
    private static boolean useHashedPassword = Boolean.valueOf(SystemConfigurationUtil.getProperty((String)"com.sun.identity.wss.security.useHashedPassword", (String)"true"));
    private static Debug debug = Debug.getInstance((String)"WebServicesSecurity");

    public void onLoginSuccess(Map requestParamsMap, HttpServletRequest request, HttpServletResponse response, SSOToken ssoToken) throws AuthenticationException {
        block8: {
            try {
                if (!useHashedPassword) {
                    String userpasswd = request.getParameter(PASSWORD_TOKEN);
                    if (userpasswd != null) {
                        ssoToken.setProperty("EncryptedUserPassword", Crypt.encrypt((String)userpasswd));
                    }
                } else {
                    AMIdentity amId;
                    Set tmp;
                    String userName = ssoToken.getPrincipal().getName();
                    if (debug.messageEnabled()) {
                        debug.message("WSSReplayPassword:Authenticated user. " + userName);
                    }
                    if ((tmp = (amId = new AMIdentity(WSSReplayPasswd.getAdminToken(), userName)).getAttribute("userPassword")) != null && !tmp.isEmpty()) {
                        String userPassword = (String)tmp.iterator().next();
                        ssoToken.setProperty("HashedUserPassword", userPassword);
                    }
                }
            }
            catch (SSOException sse) {
                debug.warning("WSSReplayPasswd.onLoginSuccess: sso exception", (Throwable)sse);
            }
            catch (IdRepoException ire) {
                if (!debug.warningEnabled()) break block8;
                debug.warning("WSSReplayPassword.onLoginSuccess: ", (Throwable)ire);
            }
        }
    }

    public void onLoginFailure(Map requestParamsMap, HttpServletRequest req, HttpServletResponse res) throws AuthenticationException {
    }

    public void onLogout(HttpServletRequest req, HttpServletResponse res, SSOToken ssoToken) throws AuthenticationException {
    }

    private static SSOToken getAdminToken() {
        return (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    }
}

