/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm.model;

import com.iplanet.am.sdk.AMAssignableDynamicGroup;
import com.iplanet.am.sdk.AMDynamicGroup;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRole;
import com.iplanet.am.sdk.AMGroup;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.sun.identity.common.admin.AdminInterfaceUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.dm.model.DMModelBase;
import com.sun.identity.console.dm.model.SearchModel;
import com.sun.identity.console.property.PropertyXMLBuilder;
import com.sun.identity.console.property.PropertyXMLBuilderBase;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class SearchModelImpl
extends DMModelBase
implements SearchModel {
    private int searchType = 0;
    private Map resultsMap = null;
    private Map attrValues = null;
    private ServiceSchemaManager userSvcMgr = null;
    private String locationDN = null;
    private String searchLocationDN = null;
    protected String errorMessage = null;
    protected int errorCode = 0;
    private String STRING_FILTER = "filter";
    private String NAME_VALUE = "groupName";
    private String SCOPE_VALUE = "searchScope";
    private static final String START_SECTION = "<section name=\"general\" defaultValue=\"\" >";
    private static final String SEARCH_SCOPE = "<property><label name=\"searchScopeLabel\" defaultValue=\"search.scope.label\" labelFor=\"searchScope\" /> <cc name=\"searchScope\" tagclass=\"com.sun.web.ui.taglib.html.CCRadioButtonTag\" > <attribute name=\"layout\" value=\"vertical\" /> <option label=\"search.scope.current\" value=\"1\" /> <option label=\"search.scope.sub\" value=\"2\" /> </cc></property>";
    private static final String GROUP_NAME = "<property><label name=\"groupNameLabel\" defaultValue=\"label.name\" labelFor=\"groupName\" /> <cc name=\"groupName\" tagclass=\"com.sun.web.ui.taglib.html.CCTextFieldTag\" /> </property>";

    public SearchModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    private Map getSearchAttributeValues(Map avMap) {
        HashMap<String, Set> avPairs = new HashMap<String, Set>(avMap.size() * 2);
        for (Map.Entry mapEntry : avMap.entrySet()) {
            String key = (String)mapEntry.getKey();
            Set values = (Set)mapEntry.getValue();
            if (values == null || values.isEmpty()) continue;
            if (values.size() == 1) {
                String val = (String)values.iterator().next();
                if (val.length() <= 0 || val.equals("false")) continue;
                avPairs.put(key, values);
                continue;
            }
            avPairs.put(key, values);
        }
        return avPairs;
    }

    private AMGroupContainer getDefaultGroupContainer(String dn) {
        AMGroupContainer defaultGC = null;
        Set containers = Collections.EMPTY_SET;
        AMStoreConnection sc = this.getAMStoreConnection();
        String groupContainerDN = AdminInterfaceUtils.getNamingAttribute(4, debug) + "=" + AdminInterfaceUtils.defaultGroupContainerName() + "," + dn;
        try {
            Iterator iter;
            switch (this.getObjectType(dn)) {
                case 2: {
                    AMOrganization org = sc.getOrganization(dn);
                    defaultGC = sc.getGroupContainer(groupContainerDN);
                    if (defaultGC != null && defaultGC.isExists()) break;
                    containers = org.getGroupContainers(1);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit orgUnit = sc.getOrganizationalUnit(dn);
                    defaultGC = sc.getGroupContainer(groupContainerDN);
                    if (defaultGC != null && defaultGC.isExists()) break;
                    containers = orgUnit.getGroupContainers(1);
                    break;
                }
                default: {
                    debug.warning("Unsupported object type for group containers");
                }
            }
            if (!containers.isEmpty() && (iter = containers.iterator()).hasNext()) {
                defaultGC = sc.getGroupContainer((String)iter.next());
            }
        }
        catch (AMException ame) {
            debug.warning("UMGroupSearchModel.getDefaultGroupContainer", (Throwable)ame);
        }
        catch (SSOException ssoe) {
            debug.warning("UMGroupSearchModel.getDefaultGroupContainer", (Throwable)((Object)ssoe));
        }
        return defaultGC;
    }

    private AMSearchResults searchGroups(AMGroup parent, String name, Map avMap, AMSearchControl searchControl) throws AMException, SSOException {
        AMSearchResults results = parent.searchGroups(name, avMap, searchControl);
        if (results != null) {
            Set groupDNs = results.getSearchResults();
            groupDNs.remove(parent.getDN());
        }
        return results;
    }

    public Set searchGroups(String location, Map avMap) {
        if (location == null) {
            location = this.getStartDSDN();
        }
        DN dn = new DN(location);
        this.locationDN = dn.getParent().toString();
        int scopeValue = 1;
        Set tmp = (Set)avMap.remove(this.SCOPE_VALUE);
        if (tmp != null && !tmp.isEmpty()) {
            try {
                String scope = (String)tmp.iterator().next();
                scopeValue = Integer.parseInt(scope);
            }
            catch (NumberFormatException nfe) {
                debug.warning("using default value of one for scope level");
            }
        }
        Map avPairs = this.getSearchAttributeValues(avMap);
        String groupName = "*";
        Set name = (Set)avPairs.remove(this.NAME_VALUE);
        if (name != null && !name.isEmpty()) {
            groupName = (String)name.iterator().next();
        }
        AMStoreConnection sc = this.getAMStoreConnection();
        AMSearchResults searchResults = null;
        AMSearchControl searchControl = new AMSearchControl();
        searchControl.setSearchScope(scopeValue);
        this.setSearchControlAttributes(searchControl, AdminInterfaceUtils.getNamingAttribute(9, debug));
        AMGroupContainer gc = null;
        try {
            switch (this.getObjectType(this.locationDN)) {
                case 2: {
                    AMOrganization org = sc.getOrganization(this.locationDN);
                    if (scopeValue == 1) {
                        gc = this.getDefaultGroupContainer(this.locationDN);
                    }
                    if (gc != null) {
                        searchResults = gc.searchGroups(groupName, avPairs, searchControl);
                        break;
                    }
                    searchResults = org.searchGroups(groupName, avPairs, searchControl);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit orgUnit = sc.getOrganizationalUnit(this.locationDN);
                    if (scopeValue == 1) {
                        gc = this.getDefaultGroupContainer(this.locationDN);
                    }
                    if (gc != null) {
                        searchResults = gc.searchGroups(groupName, avPairs, searchControl);
                        break;
                    }
                    searchResults = orgUnit.searchGroups(groupName, avPairs, searchControl);
                    break;
                }
                case 4: {
                    gc = sc.getGroupContainer(this.locationDN);
                    if (scopeValue == 1) {
                        searchResults = gc.searchGroups(groupName, avPairs, searchControl);
                        break;
                    }
                    AMOrganization o = sc.getOrganization(gc.getOrganizationDN());
                    searchResults = o.searchGroups(groupName, avPairs, searchControl);
                    break;
                }
                case 9: 
                case 10: {
                    AMStaticGroup sgroup = sc.getStaticGroup(this.locationDN);
                    searchResults = this.searchGroups(sgroup, groupName, avPairs, searchControl);
                    break;
                }
                case 11: {
                    AMDynamicGroup dgroup = sc.getDynamicGroup(this.locationDN);
                    searchResults = this.searchGroups(dgroup, groupName, avPairs, searchControl);
                    break;
                }
                case 12: {
                    AMAssignableDynamicGroup agroup = sc.getAssignableDynamicGroup(this.locationDN);
                    searchResults = this.searchGroups(agroup, groupName, avPairs, searchControl);
                    break;
                }
                default: {
                    debug.warning("SearchModel.searchGroups() invalid location " + this.locationDN);
                    break;
                }
            }
        }
        catch (AMException ame) {
            debug.warning("SearchModel.searchGroups()", (Throwable)ame);
            this.errorMessage = this.getErrorString(ame);
        }
        catch (SSOException ssoe) {
            debug.warning("SearchModel.searchGroups()", (Throwable)((Object)ssoe));
            this.errorMessage = this.getErrorString((Throwable)((Object)ssoe));
        }
        Set groupDNs = Collections.EMPTY_SET;
        if (searchResults != null) {
            groupDNs = searchResults.getSearchResults();
            this.purgeResults(groupDNs, location);
            this.resultsMap = searchResults.getResultAttributes();
            this.errorMessage = this.getSearchResultWarningMessage(searchResults);
        }
        return groupDNs;
    }

    private void purgeResults(Set entries, String loc) {
        try {
            AMGroup ag = this.getAMGroup(loc);
            Set tmp = ag.getUserAndGroupDNs();
            entries.removeAll(tmp);
            entries.remove(loc);
        }
        catch (AMException a) {
            debug.warning("SearchModel.purgeResults", (Throwable)a);
        }
        catch (SSOException s) {
            debug.warning("SearchModel.purgeResults", (Throwable)((Object)s));
        }
    }

    public String getError() {
        return this.errorMessage;
    }

    public Map getDataMap() {
        Set attributeNames = this.getFilterAttributeNames();
        HashMap<String, Set> data = new HashMap<String, Set>(attributeNames.size() * 2);
        Iterator it = attributeNames.iterator();
        while (it.hasNext()) {
            data.put((String)it.next(), Collections.EMPTY_SET);
        }
        data.put("logicalOp", Collections.EMPTY_SET);
        return data;
    }

    public Map getGroupDataMap() {
        HashMap<String, Set> data = new HashMap<String, Set>();
        try {
            ServiceSchema groupSchema = this.getSubSchema("iPlanetAMEntrySpecificService", SchemaType.GLOBAL, "Group");
            Set attributeNames = groupSchema.getAttributeSchemaNames();
            for (String tmp : attributeNames) {
                if (tmp.equals("uniquemember")) continue;
                data.put(tmp, Collections.EMPTY_SET);
            }
        }
        catch (SMSException sms) {
            debug.warning("SearchModel.getGroupDataMap", (Throwable)sms);
        }
        catch (SSOException sso) {
            debug.warning("SearchModel.getGroupDataMap", (Throwable)((Object)sso));
        }
        data.put(this.SCOPE_VALUE, Collections.EMPTY_SET);
        data.put(this.NAME_VALUE, Collections.EMPTY_SET);
        return data;
    }

    public String getGroupSearchXML() {
        String attributes = this.getPropertyXML("iPlanetAMEntrySpecificService", "Group", SchemaType.GLOBAL, false);
        StringBuffer buff = new StringBuffer(2000);
        buff.append(PropertyXMLBuilderBase.getXMLDefinitionHeader()).append("<propertysheet>\n").append(START_SECTION).append(SEARCH_SCOPE).append(GROUP_NAME).append(this.removeSectionTags(attributes)).append("</section>\n").append("</propertysheet>\n");
        return buff.toString();
    }

    protected String getPropertyXML(String serviceName, String subSchemaName, SchemaType type, boolean readonly) {
        String xml = "";
        try {
            ServiceSchema sub = this.getSubSchema(serviceName, type, subSchemaName);
            if (sub != null) {
                Set attributes = sub.getAttributeSchemas();
                if (subSchemaName.equals("Group")) {
                    Iterator it = attributes.iterator();
                    while (it.hasNext()) {
                        AttributeSchema as = (AttributeSchema)it.next();
                        if (!as.getName().equalsIgnoreCase("uniquemember")) continue;
                        it.remove();
                        break;
                    }
                }
                PropertyXMLBuilder xmlBuilder = new PropertyXMLBuilder(sub, (AMModel)this, attributes);
                if (readonly) {
                    xmlBuilder.setAllAttributeReadOnly(true);
                }
                xml = xmlBuilder.getXML(false);
            }
        }
        catch (SSOException e) {
            debug.error("SearchModel.getPropertyXML", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("SearchModel.getPropertyXML", (Throwable)e);
        }
        catch (AMConsoleException e) {
            debug.error("SearchModel.getPropertyXML", (Throwable)e);
        }
        return xml;
    }

    public String getSearchXML() {
        StringBuffer buff = new StringBuffer(2000);
        buff.append(PropertyXMLBuilderBase.getXMLDefinitionHeader()).append("<propertysheet>\n").append(START_SECTION).append(this.getFilterAttributesXML()).append("</section>\n").append("</propertysheet>\n");
        return buff.toString();
    }

    public void addMembers(String parent, Set members, String parentType) throws AMConsoleException {
        if (parentType != null && parentType.equals("Group")) {
            this.addGroups(parent, members);
        } else {
            this.addUsers(parent, members);
        }
    }

    private void addGroups(String parentDN, Set entries) throws AMConsoleException {
        AMGroup group = this.getAMGroup(parentDN);
        if (group != null) {
            try {
                group.addNestedGroups(entries);
            }
            catch (AMException ame) {
                throw new AMConsoleException(this.getErrorString(ame));
            }
            catch (SSOException ssoe) {
                throw new AMConsoleException(this.getErrorString((Throwable)((Object)ssoe)));
            }
        }
    }

    private void addUsers(String containerDN, Set userDNs) throws AMConsoleException {
        if (containerDN == null || containerDN.length() == 0 || userDNs == null || userDNs.isEmpty()) {
            // empty if block
        }
        AMStoreConnection sc = this.getAMStoreConnection();
        try {
            int containerType = this.getObjectType(containerDN);
            switch (containerType) {
                case 9: 
                case 10: {
                    AMStaticGroup sGroup = sc.getStaticGroup(containerDN);
                    sGroup.addUsers(userDNs);
                    break;
                }
                case 12: {
                    AMAssignableDynamicGroup aGroup = sc.getAssignableDynamicGroup(containerDN);
                    aGroup.addUsers(userDNs);
                    break;
                }
                case 6: 
                case 7: {
                    AMRole role = sc.getRole(containerDN);
                    role.addUsers(userDNs);
                    break;
                }
                default: {
                    debug.warning("SearchModel:addUsers invalid container " + containerDN);
                    break;
                }
            }
        }
        catch (AMException ame) {
            debug.warning("SearchModel.addUsers", (Throwable)ame);
            throw new AMConsoleException(this.getErrorString(ame));
        }
        catch (SSOException ssoe) {
            debug.error("SearchModel.addUsers Error in SSO Token", (Throwable)((Object)ssoe));
            throw new AMConsoleException(this.getErrorString((Throwable)((Object)ssoe)));
        }
    }

    public Set searchUsers(String logicalOp, Map avPairs, String location) {
        this.locationDN = location;
        this.searchLocationDN = location;
        return this.searchUsers(logicalOp, "2", avPairs);
    }

    public Set searchUsers(String logicalOp, String scope, Map avPairs) {
        int scopeValue;
        Set userDNs;
        block6: {
            userDNs = Collections.EMPTY_SET;
            scopeValue = 1;
            try {
                scopeValue = Integer.parseInt(scope);
            }
            catch (NumberFormatException nfe) {
                if (!debug.warningEnabled()) break block6;
                debug.warning("SearchModel.searchUsers using default value of one for scope level");
            }
        }
        AMSearchControl searchControl = new AMSearchControl();
        searchControl.setSearchScope(scopeValue);
        this.setSearchControlAttributes(searchControl, this.getValidUserAttributes(this.getSearchReturnValue()));
        this.setSearchControlLimits(searchControl);
        AMSearchResults searchResults = null;
        try {
            searchResults = this.searchType == 1 ? this.searchUsersForMembership(logicalOp, avPairs, searchControl) : this.searchUsers(logicalOp, avPairs, searchControl);
        }
        catch (AMException ame) {
            debug.warning("SearchModel.searchUsers", (Throwable)ame);
            this.errorMessage = this.getErrorString(ame);
        }
        catch (SSOException ssoe) {
            debug.warning("SearchModel.searchUsers", (Throwable)((Object)ssoe));
            this.errorMessage = this.getErrorString((Throwable)((Object)ssoe));
        }
        if (searchResults != null) {
            userDNs = searchResults.getSearchResults();
            this.resultsMap = searchResults.getResultAttributes();
            this.errorCode = searchResults.getErrorCode();
            this.errorMessage = this.getSearchResultWarningMessage(searchResults);
        }
        return userDNs;
    }

    public int getSize() {
        return this.getFilterAttributeNames().size();
    }

    public int getNumberOfAttributes() {
        return this.getFilterAttributeNames().size();
    }

    private ServiceSchemaManager getUserServiceSchemaManager() {
        if (this.userSvcMgr == null) {
            try {
                this.userSvcMgr = this.getServiceSchemaManager("iPlanetAMUserService");
            }
            catch (SSOException ssoe) {
                debug.warning("SearchModel.getUserServiceSchemaManager", (Throwable)((Object)ssoe));
            }
            catch (SMSException smse) {
                debug.error("SearchModel.getUserServiceSchemaManager", (Throwable)smse);
            }
        }
        return this.userSvcMgr;
    }

    public Map getResultsMap() {
        if (this.resultsMap == null) {
            this.resultsMap = new HashMap(0);
        }
        return this.resultsMap;
    }

    public void setSearchType(int type) {
        if (type == 0 || type == 1) {
            this.searchType = type;
        }
    }

    public int getSearchType() {
        return this.searchType;
    }

    public boolean isUserServiceDenied() {
        return false;
    }

    public String getNoServiceAccessMessage() {
        return this.getLocalizedString("userServiceDenied.message");
    }

    public String getNoAttributeAccessMessage() {
        return this.getLocalizedString("noSearchAttributes.message");
    }

    public String getNoMatchMsg() {
        return this.getLocalizedString("noMatchingEntries.message");
    }

    public boolean isTimeSizeLimit() {
        return this.errorCode == 1 || this.errorCode == 2;
    }

    public String getWarningTitle() {
        String tmp = null;
        tmp = this.errorCode == 1 ? this.getLocalizedString("sizeLimitExceeded.title") : (this.errorCode == 2 ? this.getLocalizedString("timeLimitExceeded.title") : this.getLocalizedString("warningMessage.title"));
        return tmp;
    }

    private AMSearchResults searchUsers(String logicalOp, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        AMSearchResults searchResults = null;
        AMPeopleContainer pc = null;
        int scope = searchControl.getSearchScope();
        AMStoreConnection sc = this.getAMStoreConnection();
        String filter = this.createFilter(logicalOp, avPairs);
        this.setSearchControlLimits(searchControl);
        switch (this.getObjectType(this.searchLocationDN)) {
            case 2: {
                if (scope == 1) {
                    pc = this.getDefaultPeopleContainer();
                }
                if (pc != null) {
                    searchResults = pc.searchUsers(searchControl, filter);
                    break;
                }
                AMOrganization org = sc.getOrganization(this.searchLocationDN);
                searchResults = org.searchUsers(searchControl, filter);
                break;
            }
            case 3: {
                if (scope == 1) {
                    pc = this.getDefaultPeopleContainer();
                }
                if (pc != null) {
                    searchResults = pc.searchUsers(searchControl, filter);
                    break;
                }
                AMOrganizationalUnit orgUnit = sc.getOrganizationalUnit(this.searchLocationDN);
                searchResults = orgUnit.searchUsers(searchControl, filter);
                break;
            }
            case 5: {
                pc = sc.getPeopleContainer(this.searchLocationDN);
                searchResults = pc.searchUsers(searchControl, filter);
                break;
            }
            case 6: 
            case 7: {
                AMRole role = sc.getRole(this.searchLocationDN);
                searchResults = role.searchUsers(searchControl, filter);
                break;
            }
            case 8: {
                AMFilteredRole filteredRole = sc.getFilteredRole(this.searchLocationDN);
                searchResults = filteredRole.searchUsers(searchControl, filter);
                break;
            }
            case 9: 
            case 10: {
                AMStaticGroup sgroup = sc.getStaticGroup(this.searchLocationDN);
                searchResults = sgroup.searchUsers(searchControl, filter);
                break;
            }
            case 12: {
                AMAssignableDynamicGroup agroup = sc.getAssignableDynamicGroup(this.searchLocationDN);
                searchResults = agroup.searchUsers(searchControl, filter);
                break;
            }
            case 11: {
                AMDynamicGroup dgroup = sc.getDynamicGroup(this.searchLocationDN);
                searchResults = dgroup.searchUsers(searchControl, filter);
                break;
            }
            default: {
                debug.warning("SearchModel.searchUsers invalid location " + this.searchLocationDN);
            }
        }
        return searchResults;
    }

    private AMSearchResults searchUsersForMembership(String logicalOp, Map avPairs, AMSearchControl searchControl) throws AMException, SSOException {
        String avFilter = this.createFilter(logicalOp, avPairs);
        AMStoreConnection sc = this.getAMStoreConnection();
        AMObject parent = null;
        String filter = null;
        switch (this.getObjectType(this.searchLocationDN)) {
            case 6: 
            case 7: {
                filter = "(&" + avFilter + "(!(nsroledn=" + this.searchLocationDN + ")))";
                AMRole role = sc.getRole(this.searchLocationDN);
                parent = this.getParentOrganization(role);
                break;
            }
            case 9: 
            case 10: {
                filter = "(&" + avFilter + "(!(iplanet-am-static-group-dn=" + this.searchLocationDN + ")))";
                AMStaticGroup sgroup = sc.getStaticGroup(this.searchLocationDN);
                parent = this.getParentOrganization(sgroup);
                break;
            }
            case 12: {
                filter = "(&" + avFilter + "(!(memberof=" + this.searchLocationDN + ")))";
                AMAssignableDynamicGroup agroup = sc.getAssignableDynamicGroup(this.searchLocationDN);
                parent = this.getParentOrganization(agroup);
                break;
            }
            default: {
                debug.warning("SearchModel.searchUsersForMembership invalid location " + this.searchLocationDN);
            }
        }
        AMSearchResults searchResults = null;
        if (parent != null) {
            searchResults = parent instanceof AMOrganization ? ((AMOrganization)parent).searchUsers(searchControl, filter) : ((AMOrganizationalUnit)parent).searchUsers(searchControl, filter);
        }
        return searchResults;
    }

    private String createFilter(String logicalOp, Map avPairs) {
        Iterator iter = avPairs.entrySet().iterator();
        StringBuffer avBuf = new StringBuffer(100);
        while (iter.hasNext()) {
            boolean multipleValues;
            Map.Entry mapEntry = iter.next();
            String key = (String)mapEntry.getKey();
            Set value = (Set)mapEntry.getValue();
            if (value == null || value.isEmpty()) {
                if (!key.equals("uid")) continue;
                avBuf.append("(" + key + "=*)");
                continue;
            }
            boolean bl = multipleValues = value.size() > 1;
            if (multipleValues) {
                avBuf.append("(|");
            }
            for (String val : value) {
                if (key.equalsIgnoreCase("inetuserstatus")) {
                    if (val.equalsIgnoreCase("Active")) {
                        avBuf.append("(|(").append("inetuserstatus").append("=active)(!(").append("inetuserstatus").append("=*)))");
                        continue;
                    }
                    avBuf.append("(").append("inetuserstatus").append("=").append(val).append(")");
                    continue;
                }
                if (val.length() > 0) {
                    avBuf.append("(").append(key).append("=").append(val).append(")");
                    continue;
                }
                if (!key.equals("uid")) continue;
                avBuf.append("(uid=*)");
            }
            if (!multipleValues) continue;
            avBuf.append(")");
        }
        StringBuffer avFilter = new StringBuffer(100);
        if (avBuf.length() != 0) {
            if (avPairs.size() > 1) {
                if (logicalOp != null && logicalOp.equalsIgnoreCase("AND")) {
                    avFilter.append("(&");
                } else {
                    avFilter.append("(|");
                }
                avFilter.append(avBuf + ")");
            } else {
                avFilter.append(avBuf);
            }
        }
        return avFilter.toString();
    }

    private AMObject getParentOrganization(AMObject obj) throws AMException, SSOException {
        String dn = obj.getOrganizationDN();
        int parentType = this.getObjectType(dn);
        if (parentType == 2) {
            return this.getAMStoreConnection().getOrganization(dn);
        }
        return this.getAMStoreConnection().getOrganizationalUnit(dn);
    }

    private AMPeopleContainer getDefaultPeopleContainer() {
        AMPeopleContainer defaultPC = null;
        Set containers = Collections.EMPTY_SET;
        AMStoreConnection sc = this.getAMStoreConnection();
        try {
            Iterator iter;
            String peopleContainerAttribute = AdminInterfaceUtils.getNamingAttribute(5, debug);
            switch (this.locationType) {
                case 2: {
                    AMOrganization org = sc.getOrganization(this.locationDN);
                    defaultPC = sc.getPeopleContainer(peopleContainerAttribute + "=" + AdminInterfaceUtils.defaultPeopleContainerName() + "," + org.getDN());
                    if (defaultPC != null && defaultPC.isExists()) break;
                    containers = org.getPeopleContainers(1);
                    break;
                }
                case 3: {
                    AMOrganizationalUnit orgUnit = sc.getOrganizationalUnit(this.locationDN);
                    defaultPC = sc.getPeopleContainer(peopleContainerAttribute + "=" + AdminInterfaceUtils.defaultPeopleContainerName() + "," + orgUnit.getDN());
                    if (defaultPC != null && defaultPC.isExists()) break;
                    containers = orgUnit.getPeopleContainers(1);
                    break;
                }
                default: {
                    debug.warning("Unsupported object type for people containers");
                }
            }
            if (!containers.isEmpty() && (iter = containers.iterator()).hasNext()) {
                defaultPC = sc.getPeopleContainer((String)iter.next());
            }
        }
        catch (AMException ame) {
            debug.warning("SearchModel.getDefaultPeopleContainer", (Throwable)ame);
        }
        catch (SSOException ssoe) {
            debug.warning("SearchModel.getDefaultPeopleContainer", (Throwable)((Object)ssoe));
        }
        return defaultPC;
    }

    public Set getAttrValue(String key) {
        return this.attrValues != null ? (Set)this.attrValues.get(key) : null;
    }

    public void setAttrValues(Map valueMap) {
        if (this.attrValues == null) {
            this.attrValues = new HashMap(valueMap);
        } else {
            this.attrValues.putAll(valueMap);
        }
    }
}

