/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.security;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.security.AppSSOTokenProvider;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class SystemAppTokenProvider
implements AppSSOTokenProvider {
    private static final String MODULE_APPLICATION = "Application";
    private String appUserName;
    private String appPassword;

    public SystemAppTokenProvider(String appUserName, String appPassword) {
        this.appUserName = appUserName;
        this.appPassword = appPassword;
    }

    public SSOToken getAppSSOToken() {
        SSOToken ssoToken = null;
        try {
            Callback[] callbacks;
            AuthContext authContext = new AuthContext("/");
            authContext.login(AuthContext.IndexType.MODULE_INSTANCE, MODULE_APPLICATION);
            if (authContext.hasMoreRequirements() && (callbacks = authContext.getRequirements()) != null) {
                this.addLoginCallbackMessage(callbacks, this.appUserName, this.appPassword);
                authContext.submitRequirements(callbacks);
            }
            if (authContext.getStatus() == AuthContext.Status.SUCCESS) {
                ssoToken = authContext.getSSOToken();
            }
        }
        catch (AuthLoginException ale) {
            AdminTokenAction.debug.error("SystemAppTokenProvider.getAppSSOToken()", (Throwable)ale);
        }
        catch (UnsupportedCallbackException usce) {
            AdminTokenAction.debug.error("SystemAppTokenProvider.getAppSSOToken()", (Throwable)usce);
        }
        catch (Exception e) {
            AdminTokenAction.debug.error("SystemAppTokenProvider.getAppSSOToken()", (Throwable)e);
        }
        return ssoToken;
    }

    private void addLoginCallbackMessage(Callback[] callbacks, String appUserName, String appPassword) throws UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)callbacks[i];
                nameCallback.setName(appUserName);
                continue;
            }
            if (!(callbacks[i] instanceof PasswordCallback)) continue;
            PasswordCallback pwdCallback = (PasswordCallback)callbacks[i];
            pwdCallback.setPassword(appPassword.toCharArray());
        }
    }
}

