/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.RequestAbstract;
import com.sun.identity.saml2.protocol.Status;
import com.sun.identity.saml2.soapbinding.RequestHandler;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.context.Attribute;
import com.sun.identity.xacml.context.ContextFactory;
import com.sun.identity.xacml.context.Decision;
import com.sun.identity.xacml.context.Request;
import com.sun.identity.xacml.context.Resource;
import com.sun.identity.xacml.context.Response;
import com.sun.identity.xacml.context.Result;
import com.sun.identity.xacml.context.StatusCode;
import com.sun.identity.xacml.context.StatusDetail;
import com.sun.identity.xacml.context.StatusMessage;
import com.sun.identity.xacml.plugins.FMActionMapper;
import com.sun.identity.xacml.plugins.FMEnvironmentMapper;
import com.sun.identity.xacml.plugins.FMResourceMapper;
import com.sun.identity.xacml.plugins.FMResultMapper;
import com.sun.identity.xacml.plugins.FMSubjectMapper;
import com.sun.identity.xacml.saml2.XACMLAuthzDecisionQuery;
import com.sun.identity.xacml.saml2.XACMLAuthzDecisionStatement;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;

public class XACMLAuthzDecisionQueryHandler
implements RequestHandler {
    public com.sun.identity.saml2.protocol.Response handleQuery(String pdpEntityId, String pepEntityId, RequestAbstract samlpRequest, SOAPMessage soapMessage) throws SAML2Exception {
        List attributes;
        boolean booleanDecision;
        Map environment;
        String actionName;
        String serviceName;
        String resourceName;
        SSOToken ssoToken;
        boolean returnContext;
        Request xacmlRequest;
        String statusCodeValue;
        boolean evaluationFailed;
        block31: {
            FMSubjectMapper subjectMapper = new FMSubjectMapper();
            subjectMapper.initialize(pdpEntityId, pepEntityId, null);
            FMResourceMapper resourceMapper = new FMResourceMapper();
            resourceMapper.initialize(pdpEntityId, pepEntityId, null);
            FMActionMapper actionMapper = new FMActionMapper();
            actionMapper.initialize(pdpEntityId, pepEntityId, null);
            FMEnvironmentMapper environmentMapper = new FMEnvironmentMapper();
            environmentMapper.initialize(pdpEntityId, pepEntityId, null);
            FMResultMapper resultMapper = new FMResultMapper();
            resultMapper.initialize(pdpEntityId, pepEntityId, null);
            evaluationFailed = false;
            statusCodeValue = null;
            if (XACMLSDKUtils.debug.messageEnabled()) {
                XACMLSDKUtils.debug.message("XACMLAuthzDecisionQueryHandler.handleQuery(), entering:pdpEntityId=" + pdpEntityId + ":pepEntityId=" + pepEntityId + ":samlpRequest=\n" + samlpRequest.toXMLString(true, true) + ":soapMessage=\n" + soapMessage);
            }
            xacmlRequest = ((XACMLAuthzDecisionQuery)samlpRequest).getRequest();
            returnContext = ((XACMLAuthzDecisionQuery)samlpRequest).getReturnContext();
            ssoToken = null;
            resourceName = null;
            serviceName = null;
            actionName = null;
            environment = null;
            booleanDecision = false;
            try {
                ssoToken = (SSOToken)subjectMapper.mapToNativeSubject(xacmlRequest.getSubjects());
                if (ssoToken == null) {
                    statusCodeValue = "urn:oasis:names:tc:xacml:1.0:status:missing-attribute";
                    evaluationFailed = true;
                } else if (XACMLSDKUtils.debug.messageEnabled()) {
                    XACMLSDKUtils.debug.message("XACMLAuthzDecisionQueryHandler.handleQuery(),created ssoToken");
                }
                if (ssoToken != null) {
                    String[] resourceService;
                    List resources = xacmlRequest.getResources();
                    Resource resource = null;
                    if (!resources.isEmpty()) {
                        resource = (Resource)resources.get(0);
                    }
                    if (resource != null && (resourceService = resourceMapper.mapToNativeResource(resource)) != null) {
                        if (resourceService.length > 0) {
                            resourceName = resourceService[0];
                        }
                        if (resourceService.length > 1) {
                            serviceName = resourceService[1];
                        }
                    }
                    if (resourceName == null) {
                        statusCodeValue = "urn:oasis:names:tc:xacml:1.0:status:missing-attribute";
                        evaluationFailed = true;
                    }
                    if (serviceName == null) {
                        throw new SAML2Exception(XACMLSDKUtils.xacmlResourceBundle.getString("missing_attribute"));
                    }
                }
                if (serviceName != null) {
                    if (serviceName != null) {
                        actionName = actionMapper.mapToNativeAction(xacmlRequest.getAction(), serviceName);
                    }
                    if (actionName == null) {
                        statusCodeValue = "urn:oasis:names:tc:xacml:1.0:status:missing-attribute";
                        evaluationFailed = true;
                    }
                }
            }
            catch (XACMLException xe) {
                statusCodeValue = "urn:oasis:names:tc:xacml:1.0:status:missing-attribute";
                evaluationFailed = true;
                if (!XACMLSDKUtils.debug.warningEnabled()) break block31;
                XACMLSDKUtils.debug.warning("XACMLAuthzDecisionQueryHandler.handleQuery(),caught exception", (Throwable)xe);
            }
        }
        if (!evaluationFailed) {
            try {
                PolicyEvaluator pe = new PolicyEvaluator(serviceName);
                booleanDecision = pe.isAllowed(ssoToken, resourceName, actionName, environment);
            }
            catch (SSOException ssoe) {
                if (XACMLSDKUtils.debug.warningEnabled()) {
                    XACMLSDKUtils.debug.warning("XACMLAuthzDecisionQueryHandler.handleQuery(),caught exception", (Throwable)ssoe);
                }
                evaluationFailed = true;
            }
            catch (PolicyException pe) {
                if (XACMLSDKUtils.debug.warningEnabled()) {
                    XACMLSDKUtils.debug.warning("XACMLAuthzDecisionQueryHandler.handleQuery(),caught exception", (Throwable)pe);
                }
                evaluationFailed = true;
            }
        }
        Decision decision = ContextFactory.getInstance().createDecision();
        com.sun.identity.xacml.context.Status status = ContextFactory.getInstance().createStatus();
        StatusCode code = ContextFactory.getInstance().createStatusCode();
        StatusMessage message = ContextFactory.getInstance().createStatusMessage();
        StatusDetail detail = ContextFactory.getInstance().createStatusDetail();
        detail.getElement().insertBefore(detail.getElement().cloneNode(true), null);
        if (evaluationFailed) {
            decision.setValue("Indeterminate");
            if (statusCodeValue == null) {
                statusCodeValue = "urn:oasis:names:tc:xacml:1.0:status:processing-error";
            }
            code.setValue(statusCodeValue);
            message.setValue("processing_error");
        } else if (booleanDecision) {
            decision.setValue("Permit");
            code.setValue("urn:oasis:names:tc:xacml:1.0:status:ok");
            message.setValue("ok");
        } else {
            decision.setValue("Deny");
            code.setValue("urn:oasis:names:tc:xacml:1.0:status:ok");
            message.setValue("ok");
        }
        Result result = ContextFactory.getInstance().createResult();
        String resourceId = resourceName;
        List resources = xacmlRequest.getResources();
        Resource resource = null;
        if (!resources.isEmpty() && (resource = (Resource)resources.get(0)) != null && (attributes = resource.getAttributes()) != null) {
            for (int count = 0; count < attributes.size(); ++count) {
                URI tmpURI;
                Attribute attr = (Attribute)attributes.get(count);
                if (attr == null || !(tmpURI = attr.getAttributeId()).toString().equals("ResourceId")) continue;
                Element element = (Element)attr.getAttributeValues().get(0);
                resourceId = XMLUtils.getElementValue((Element)element);
                break;
            }
        }
        result.setResourceId(resourceId);
        result.setDecision(decision);
        status.setStatusCode(code);
        status.setStatusMessage(message);
        status.setStatusDetail(detail);
        result.setStatus(status);
        Response response = ContextFactory.getInstance().createResponse();
        response.addResult(result);
        XACMLAuthzDecisionStatement statement = ContextFactory.getInstance().createXACMLAuthzDecisionStatement();
        statement.setResponse(response);
        if (returnContext) {
            statement.setRequest(xacmlRequest);
        }
        com.sun.identity.saml2.protocol.Response samlpResponse = this.createSamlpResponse(statement, status.getStatusCode().getValue());
        if (XACMLSDKUtils.debug.messageEnabled()) {
            XACMLSDKUtils.debug.message("XACMLAuthzDecisionQueryHandler.handleQuery(), returning:samlResponse=\n" + samlpResponse.toXMLString(true, true));
        }
        return samlpResponse;
    }

    private com.sun.identity.saml2.protocol.Response createSamlpResponse(XACMLAuthzDecisionStatement statement, String statusCodeValue) throws XACMLException, SAML2Exception {
        com.sun.identity.saml2.protocol.Response samlpResponse = ProtocolFactory.getInstance().createResponse();
        samlpResponse.setID("response-id:1");
        samlpResponse.setVersion("2.0");
        samlpResponse.setIssueInstant(new Date());
        com.sun.identity.saml2.protocol.StatusCode samlStatusCode = ProtocolFactory.getInstance().createStatusCode();
        samlStatusCode.setValue(statusCodeValue);
        Status samlStatus = ProtocolFactory.getInstance().createStatus();
        samlStatus.setStatusCode(samlStatusCode);
        samlpResponse.setStatus(samlStatus);
        Assertion assertion = AssertionFactory.getInstance().createAssertion();
        assertion.setVersion("2.0");
        assertion.setID("response-id:1");
        assertion.setIssueInstant(new Date());
        Issuer issuer = AssertionFactory.getInstance().createIssuer();
        issuer.setValue("issuer-1");
        assertion.setIssuer(issuer);
        ArrayList<String> statements = new ArrayList<String>();
        statements.add(statement.toXMLString(true, true));
        assertion.setStatements(statements);
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        assertions.add(assertion);
        samlpResponse.setAssertion(assertions);
        return samlpResponse;
    }
}

