/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.sun.identity.cli.CLICommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.Debugger;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.LogWriter;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.SubCommand;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;

public abstract class CLICommandBase
implements CLICommand {
    private SubCommand subCommand;
    private RequestContext requestContext;
    private ResourceBundle rb;

    public void handleRequest(RequestContext rc) throws CLIException {
        this.subCommand = rc.getSubCommand();
        this.requestContext = rc;
        this.rb = rc.getSubCommand().getResourceBundle();
        IOutput outputWriter = this.getOutputWriter();
        outputWriter.printlnMessage("");
        CommandManager mgr = this.getCommandManager();
        if (mgr.isVerbose()) {
            ResourceBundle mrc = mgr.getResourceBundle();
            String msg = mrc.getString("verbose-executeCmd");
            String[] arg = new String[]{this.getClass().getName()};
            outputWriter.printlnMessage(MessageFormat.format(msg, arg));
        }
    }

    protected String getStringOptionValue(String optionName, String defValue) {
        String value = this.getStringOptionValue(optionName);
        if (value == null || value.trim().length() == 0) {
            value = defValue;
        }
        return value;
    }

    protected String getStringOptionValue(String optionName) {
        List list = this.requestContext.getOption(optionName);
        return list != null && !list.isEmpty() ? (String)list.get(0) : null;
    }

    protected String getResourceString(String key) {
        return this.rb.getString(key);
    }

    protected boolean isOptionSet(String key) {
        return this.requestContext.getOption(key) != null;
    }

    protected IOutput getOutputWriter() {
        CommandManager mgr = this.requestContext.getCommandManager();
        return mgr.getOutputWriter();
    }

    protected CommandManager getCommandManager() {
        return this.requestContext.getCommandManager();
    }

    protected boolean isVerbose() {
        return this.requestContext.getCommandManager().isVerbose();
    }

    protected void writeLog(int type, Level level, String msgid, String[] msgdata) throws CLIException {
        CommandManager mgr = this.requestContext.getCommandManager();
        LogWriter.log(mgr, type, level, msgid, msgdata, null);
    }

    protected void debugError(String msg, Throwable e) {
        CommandManager mgr = this.requestContext.getCommandManager();
        Debugger.error(mgr, msg, e);
    }

    protected void debugMessage(String msg) {
        CommandManager mgr = this.requestContext.getCommandManager();
        Debugger.message(mgr, msg);
    }

    protected void debugWarning(String msg, Throwable e) {
        CommandManager mgr = this.requestContext.getCommandManager();
        Debugger.warning(mgr, msg, e);
    }

    protected String tokenize(Collection collection) {
        StringBuffer buff = new StringBuffer();
        if (collection != null && !collection.isEmpty()) {
            boolean first = true;
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                if (!first) {
                    buff.append(", ");
                } else {
                    first = false;
                }
                buff.append(i.next().toString());
            }
        }
        return buff.toString();
    }
}

