/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Cache;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.SharedSubject;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Subjects {
    private final int SUBJECTS_RESULT_CACHE_SIZE = 1000;
    private String name;
    private String description;
    private Map users = new HashMap();
    private Cache resultCache = new Cache(1000);
    private long resultTtl;
    private static String SUBJECTS_ELEMENT_BEGIN = "<Subjects name=\"";
    private static String SUBJECTS_DESCRIPTION = "\" description=\"";
    private static String SUBJECTS_ELEMENT_END = "</Subjects>";
    private static String SUBJECT_ELEMENT = "<Subject name=\"";
    private static String INCLUDE_TYPE = "includeType";
    private static String SUBJECT_TYPE = "\" type=\"";
    private static String SUBJECT_ELEMENT_END = "</Subject>";
    private static String ATTR_VALUE_BEGIN = "<AttributeValuePair><Attribute name=\"Values\"/>";
    private static String VALUE_BEGIN = "<Value>";
    private static String VALUE_END = "</Value>";
    private static String ATTR_VALUE_END = "</AttributeValuePair>";
    private static String SUBJECT_VALUES_ATTR_NAME = "Values";
    private static String INCLUSIVE_TYPE = "inclusive";
    private static String EXCLUSIVE_TYPE = "exclusive";
    private static String REALM_SUBJECT_ELEMENT = "<RealmSubject name=\"";
    private static String REALM_SUBJECT_ELEMENT_END = "\"></RealmSubject>";

    protected Subjects() {
        this((String)null, (String)null);
    }

    protected Subjects(PolicyManager pm, Node usersNode) throws InvalidFormatException, InvalidNameException, NameNotFoundException, PolicyException {
        if (!usersNode.getNodeName().equalsIgnoreCase("Subjects")) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid subjects xml blob given to construct subjects");
            }
            throw new InvalidFormatException("amPolicy", "invalid_xml_subjects_root_node", null, "", 5);
        }
        this.name = XMLUtils.getNodeAttributeValue((Node)usersNode, (String)"name");
        if (this.name == null) {
            this.name = "Subjects:" + ServiceTypeManager.generateRandomName();
        }
        if ((this.description = XMLUtils.getNodeAttributeValue((Node)usersNode, (String)"description")) == null) {
            this.description = "";
        }
        SubjectTypeManager stm = pm.getSubjectTypeManager();
        for (Node subjectNode : XMLUtils.getChildNodes((Node)usersNode, (String)"Subject")) {
            String subjectType = XMLUtils.getNodeAttributeValue((Node)subjectNode, (String)"type");
            if (subjectType == null) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("subject type is null");
                }
                throw new InvalidFormatException("amPolicy", "invalid_xml_subjects_root_node", null, "", 5);
            }
            Subject subject = stm.getSubject(subjectType);
            NodeList attrValuePairNodes = subjectNode.getChildNodes();
            int numAttrValuePairNodes = attrValuePairNodes.getLength();
            for (int j = 0; j < numAttrValuePairNodes; ++j) {
                Node attrValuePairNode = attrValuePairNodes.item(j);
                if (XMLUtils.getNamedChildNode((Node)attrValuePairNode, (String)"Attribute", (String)"name", (String)SUBJECT_VALUES_ATTR_NAME) == null) continue;
                subject.setValues(XMLUtils.getAttributeValuePair((Node)attrValuePairNode));
            }
            String subjectName = XMLUtils.getNodeAttributeValue((Node)subjectNode, (String)"name");
            String exclusive = XMLUtils.getNodeAttributeValue((Node)subjectNode, (String)INCLUDE_TYPE);
            this.addSubject(subjectName, subject, EXCLUSIVE_TYPE.equals(exclusive));
        }
        for (Node subjectNode : XMLUtils.getChildNodes((Node)usersNode, (String)"RealmSubject")) {
            String subjectName = XMLUtils.getNodeAttributeValue((Node)subjectNode, (String)"name");
            String exclusive = XMLUtils.getNodeAttributeValue((Node)subjectNode, (String)INCLUDE_TYPE);
            this.addSubject(subjectName, stm.getSharedSubject(subjectName), EXCLUSIVE_TYPE.equals(exclusive));
        }
    }

    public Subjects(String name, String description) {
        this.name = name == null ? "Subjects:" + ServiceTypeManager.generateRandomName() : name;
        this.description = description == null ? "" : description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name == null ? "Subjects:" + ServiceTypeManager.generateRandomName() : name;
    }

    public void setDescription(String description) {
        this.description = description == null ? "" : description;
    }

    public Set getSubjectNames() {
        return this.users.keySet();
    }

    public Subject getSubject(String subjectName) throws NameNotFoundException {
        QualifiedSubject answer = (QualifiedSubject)this.users.get(subjectName);
        if (answer == null) {
            Object[] objs = new String[]{subjectName};
            throw new NameNotFoundException("amPolicy", "name_not_present", objs, subjectName, 5);
        }
        return answer.getSubject();
    }

    Subject fetchSubject(String subjectName) {
        QualifiedSubject answer = (QualifiedSubject)this.users.get(subjectName);
        return answer != null ? answer.getSubject() : null;
    }

    public void addSubject(Subject subject) throws NameAlreadyExistsException {
        this.addSubject(null, subject, false);
    }

    public void addSubject(String subjectName, Subject subject) throws NameAlreadyExistsException {
        this.addSubject(subjectName, subject, false);
    }

    public void addSubject(String subjectName, Subject subject, boolean exclusive) throws NameAlreadyExistsException {
        if (subjectName == null) {
            subjectName = "Subject:" + ServiceTypeManager.generateRandomName();
        }
        if (this.users.containsKey(subjectName)) {
            Object[] objs = new String[]{subjectName};
            throw new NameAlreadyExistsException("amPolicy", "name_already_present", objs, subjectName, 5);
        }
        this.users.put(subjectName, new QualifiedSubject(subject, exclusive));
    }

    public void replaceSubject(String subjectName, Subject subject) throws NameNotFoundException {
        this.replaceSubject(subjectName, subject, false);
    }

    public void replaceSubject(String subjectName, Subject subject, boolean exclusive) throws NameNotFoundException {
        if (!this.users.containsKey(subjectName)) {
            Object[] objs = new String[]{subjectName};
            throw new NameNotFoundException("amPolicy", "name_not_present", objs, subjectName, 5);
        }
        this.users.put(subjectName, new QualifiedSubject(subject, exclusive));
    }

    public Subject removeSubject(String subjectName) {
        Subject subject = null;
        QualifiedSubject qualifiedSubject = (QualifiedSubject)this.users.remove(subjectName);
        if (qualifiedSubject != null) {
            subject = qualifiedSubject.getSubject();
        }
        return subject;
    }

    public Subject removeSubject(Subject subject) {
        QualifiedSubject qualifiedSubject;
        Subject s = null;
        String subjectName = this.getSubjectName(subject);
        if (subjectName != null && (qualifiedSubject = (QualifiedSubject)this.users.remove(subjectName)) != null) {
            s = qualifiedSubject.getSubject();
        }
        return s;
    }

    public boolean isSubjectExclusive(String subjectName) throws NameNotFoundException {
        if (!this.users.containsKey(subjectName)) {
            Object[] objs = new String[]{subjectName};
            throw new NameNotFoundException("amPolicy", "name_not_present", objs, subjectName, 5);
        }
        return ((QualifiedSubject)this.users.get(subjectName)).isExclusive();
    }

    public boolean isRealmSubject(String subjectName) throws NameNotFoundException {
        if (!this.users.containsKey(subjectName)) {
            Object[] objs = new String[]{subjectName};
            throw new NameNotFoundException("amPolicy", "name_not_present", objs, subjectName, 5);
        }
        return ((QualifiedSubject)this.users.get(subjectName)).isRealmSubject();
    }

    public String getSubjectName(Subject subject) {
        String answer = null;
        for (String subjectName : this.users.keySet()) {
            QualifiedSubject qs = (QualifiedSubject)this.users.get(subjectName);
            if (!qs.getSubject().equals(subject)) continue;
            answer = subjectName;
            break;
        }
        return answer;
    }

    public boolean equals(Object o) {
        if (o instanceof Subjects) {
            Subjects s = (Subjects)o;
            if (s.users.size() == this.users.size()) {
                Iterator subjects = this.users.entrySet().iterator();
                while (subjects.hasNext()) {
                    Object ss = subjects.next().getValue();
                    if (s.users.containsValue(ss)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        Subjects answer = null;
        try {
            answer = (Subjects)super.clone();
        }
        catch (CloneNotSupportedException se) {
            answer = new Subjects();
        }
        answer.name = this.name;
        answer.description = this.description;
        answer.users = new HashMap();
        for (String item : this.users.keySet()) {
            QualifiedSubject qualifiedSubject = (QualifiedSubject)this.users.get(item);
            answer.users.put(item, new QualifiedSubject((Subject)qualifiedSubject.getSubject().clone(), qualifiedSubject.isExclusive()));
        }
        return answer;
    }

    public boolean isMember(SSOToken token) throws SSOException, PolicyException {
        boolean member = false;
        long currentTime = System.currentTimeMillis();
        long[] cachedResult = null;
        cachedResult = (long[])this.resultCache.get(((Object)token.getTokenID()).toString());
        if (cachedResult == null) {
            cachedResult = new long[2];
        }
        if (currentTime - cachedResult[0] < this.resultTtl) {
            boolean bl = member = cachedResult[1] == 1L;
            if (PolicyManager.debug.messageEnabled()) {
                PolicyManager.debug.message("Subjects.isMember():getting subject evaluation results from resultCache of policy");
            }
        } else {
            Iterator items = this.users.entrySet().iterator();
            while (items.hasNext()) {
                QualifiedSubject qualifiedSubject = (QualifiedSubject)items.next().getValue();
                if (qualifiedSubject.subject.isMember(token)) {
                    if (qualifiedSubject.exclusive) continue;
                    member = true;
                    break;
                }
                if (!qualifiedSubject.exclusive) continue;
                member = true;
                break;
            }
            long memberLong = member ? 1L : 0L;
            cachedResult[0] = currentTime;
            cachedResult[1] = memberLong;
            this.resultCache.put(((Object)token.getTokenID()).toString(), cachedResult);
        }
        return member;
    }

    public String toString() {
        return this.toXML();
    }

    protected String toXML() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("\n").append(SUBJECTS_ELEMENT_BEGIN).append(XMLUtils.escapeSpecialCharacters((String)this.name)).append(SUBJECTS_DESCRIPTION).append(XMLUtils.escapeSpecialCharacters((String)this.description)).append("\">");
        for (String subjectName : this.users.keySet()) {
            QualifiedSubject qualifiedSubject = (QualifiedSubject)this.users.get(subjectName);
            boolean realmSubject = qualifiedSubject.isRealmSubject();
            if (realmSubject) {
                sb.append("\n").append(REALM_SUBJECT_ELEMENT).append(XMLUtils.escapeSpecialCharacters((String)subjectName)).append("\" ").append(INCLUDE_TYPE).append("=\"").append(qualifiedSubject.isExclusive() ? EXCLUSIVE_TYPE : INCLUSIVE_TYPE).append(REALM_SUBJECT_ELEMENT_END);
                continue;
            }
            Subject subject = qualifiedSubject.getSubject();
            sb.append("\n").append(SUBJECT_ELEMENT).append(XMLUtils.escapeSpecialCharacters((String)subjectName)).append(SUBJECT_TYPE).append(XMLUtils.escapeSpecialCharacters((String)SubjectTypeManager.subjectTypeName(subject))).append("\" ").append(INCLUDE_TYPE).append("=\"").append(qualifiedSubject.isExclusive() ? EXCLUSIVE_TYPE : INCLUSIVE_TYPE).append("\">");
            Set v = subject.getValues();
            if (v != null && !v.isEmpty()) {
                sb.append("\n").append(ATTR_VALUE_BEGIN);
                Iterator values = v.iterator();
                while (values.hasNext()) {
                    sb.append(VALUE_BEGIN).append(XMLUtils.escapeSpecialCharacters((String)((String)values.next()))).append(VALUE_END);
                }
                sb.append("\n").append(ATTR_VALUE_END);
            }
            sb.append("\n").append(SUBJECT_ELEMENT_END);
        }
        sb.append("\n").append(SUBJECTS_ELEMENT_END);
        return sb.toString();
    }

    void setResultTtl(long ttl) {
        this.resultTtl = ttl;
    }

    long getResultTtl() {
        return this.resultTtl;
    }

    long getResultTtl(SSOToken token) {
        long ttl = Long.MAX_VALUE;
        long[] cachedResult = (long[])this.resultCache.get(((Object)token.getTokenID()).toString());
        if (cachedResult != null) {
            ttl = cachedResult[0] + this.resultTtl;
        }
        return ttl;
    }

    void setPolicyConfig(Map policyConfig) throws PolicyException {
        this.resultCache = new Cache(1000);
        Iterator sIter = this.users.keySet().iterator();
        while (sIter.hasNext()) {
            QualifiedSubject qualifiedSubject = (QualifiedSubject)this.users.get(sIter.next());
            qualifiedSubject.getSubject().initialize(policyConfig);
        }
        this.setResultTtl(PolicyConfig.getSubjectsResultTtl(policyConfig));
    }

    int size() {
        return this.users.size();
    }

    boolean isSubjectResultCached(SSOToken token) throws SSOException {
        return this.resultCache.get(((Object)token.getTokenID()).toString()) != null;
    }

    void clearSubjectResultCache(String tokenIdString) throws PolicyException {
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("Subjects.clearSubjectResultCache(tokenIdString):  clearing cached subject evaluation result for  tokenId XXXXX");
        }
        this.resultCache.remove(tokenIdString);
    }

    private static class QualifiedSubject {
        Subject subject;
        boolean exclusive = false;

        QualifiedSubject(Subject subject, boolean exclusive) {
            this.subject = subject;
            this.exclusive = exclusive;
        }

        Subject getSubject() {
            return this.subject;
        }

        boolean isExclusive() {
            return this.exclusive;
        }

        boolean isRealmSubject() {
            return this.subject instanceof SharedSubject;
        }
    }
}

