/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.ums.AssignableDynamicGroup;
import com.iplanet.ums.DefaultClassResolver;
import com.iplanet.ums.DynamicGroup;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.LDAPUrl;
import java.net.MalformedURLException;

public class GroupResolver
extends DefaultClassResolver {
    private static Debug debug = Debug.getInstance((String)"amSDK");

    public Class resolve(String id, AttrSet set) {
        String[] vals;
        Attr attr;
        Class<AssignableDynamicGroup> c = super.resolve(id, set);
        if (c != null && c.equals(DynamicGroup.class) && (attr = set.getAttribute("memberurl")) != null && (vals = attr.getStringValues()) != null && vals.length > 0 && this.isAssignable(id, vals[0])) {
            c = AssignableDynamicGroup.class;
        }
        return c;
    }

    private boolean isAssignable(String id, String val) {
        block9: {
            try {
                int ind;
                LDAPUrl url = new LDAPUrl(val);
                String filter = url.getFilter().trim();
                if (debug.messageEnabled()) {
                    debug.message("AssignableDynamicGroup.GroupResolver.isAssignable: filter = <" + filter + ">");
                }
                if (filter.startsWith("(") && filter.endsWith(")")) {
                    filter = filter.substring(1, filter.length() - 1);
                    if (debug.messageEnabled()) {
                        debug.message("AssignableDynamicGroup.GroupResolver.isAssignable: adjusted to <" + filter + ">");
                    }
                }
                if ((ind = filter.indexOf(61)) > 0) {
                    String attrName = filter.substring(0, ind);
                    if (debug.messageEnabled()) {
                        debug.message("AssignableDynamicGroup.GroupResolver.isAssignable: attrName = <" + attrName + ">");
                    }
                    if (attrName.equalsIgnoreCase("memberof")) {
                        String attrVal = filter.substring(ind + 1).trim();
                        String dn = LDAPDN.normalize((String)this.guidToDN(attrVal));
                        if (debug.messageEnabled()) {
                            debug.message("AssignableDynamicGroup.GroupResolver.isAssignable: comparing <" + dn + "> to <" + id + ">");
                        }
                        return dn.equalsIgnoreCase(LDAPDN.normalize((String)this.guidToDN(id)));
                    }
                }
            }
            catch (MalformedURLException ex) {
                if (!debug.messageEnabled()) break block9;
                debug.message("AssignableDynamicGroup.isAssignable : Exception : " + ex.getMessage());
            }
        }
        return false;
    }

    private String guidToDN(String id) {
        return id;
    }
}

