/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.Button;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.policy.AuthToServiceHelper;
import com.sun.identity.console.policy.ConditionEditViewBean;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.web.ui.view.html.CCSelect;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AuthToServiceEditViewBean
extends ConditionEditViewBean {
    private static AuthToServiceHelper helper = AuthToServiceHelper.getInstance();
    public static final String DEFAULT_DISPLAY_URL = "/console/policy/AuthToServiceEdit.jsp";
    private static final String BTN_REALM = "btnRealm";
    private boolean bRealmSelect;
    private boolean bSearchForRealm;

    public AuthToServiceEditViewBean() {
        super("AuthToServiceEdit", DEFAULT_DISPLAY_URL);
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(BTN_REALM, Button.class);
    }

    protected View createChild(String name) {
        return name.equals(BTN_REALM) ? new Button((ContainerView)this, name, (Object)"") : super.createChild(name);
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        HashSet<String> realmNames;
        super.beginDisplay(event);
        String filter = (String)this.getDisplayFieldValue("tfSearch");
        if (filter == null || filter.trim().length() == 0) {
            this.setDisplayFieldValue("tfSearch", "*");
        }
        if ((realmNames = this.getRealmNames(filter)) != null) {
            realmNames.add("");
        }
        boolean nolongExistRealm = false;
        String realmValue = (String)this.propertySheetModel.getValue("Realm");
        if (!this.bSearchForRealm && !this.bRealmSelect) {
            if (realmValue == null) {
                realmValue = "";
            }
            if (realmNames == null) {
                realmNames = new HashSet<String>(2);
            }
            if (!realmNames.contains(realmValue)) {
                realmNames.add(realmValue);
                nolongExistRealm = true;
                if (!this.isInlineAlertMessageSet()) {
                    String msg = this.getModel().getLocalizedString("policy.condition.authlevel.no.longer.exist.realm");
                    String[] param = new String[]{realmValue};
                    this.setInlineAlertMessage("info", "message.information", MessageFormat.format(msg, param));
                }
            }
        }
        if (realmNames != null && !realmNames.isEmpty()) {
            String realm;
            CCSelect sl = (CCSelect)this.getChild("Realm");
            sl.setOptions(this.createOptionList(this.getLabelValueMap(realmNames)));
            String string = realm = this.bSearchForRealm ? (String)realmNames.iterator().next() : (String)sl.getValue();
            if (realm == null) {
                realm = realmValue;
                sl.setValue((Object)realm);
            }
            if (!nolongExistRealm) {
                this.setServiceNames(realm);
            } else {
                CCSelect slService = (CCSelect)this.getChild("AuthenticateToService");
                HashSet<Object> svcName = new HashSet<Object>(2);
                svcName.add(this.propertySheetModel.getValue("AuthenticateToService"));
                slService.setOptions(this.createOptionList(svcName));
            }
        } else {
            CCSelect slService = (CCSelect)this.getChild("AuthenticateToService");
            slService.setOptions(new OptionList());
        }
    }

    private Set getRealmNames(String filter) {
        Set realmNames;
        block3: {
            realmNames = null;
            try {
                realmNames = helper.getRealmNames(filter, (PolicyModel)this.getModel());
                if (realmNames.isEmpty() && !this.isInlineAlertMessageSet()) {
                    this.setInlineAlertMessage("info", "message.information", "policy.condition.authlevel.no.search.result.message");
                }
            }
            catch (AMConsoleException e) {
                if (this.isInlineAlertMessageSet()) break block3;
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
        return realmNames;
    }

    private void setServiceNames(String realm) {
        block2: {
            try {
                Set serviceNames = helper.getAssignedServiceNamesInRealm(realm, (PolicyModel)this.getModel());
                CCSelect slService = (CCSelect)this.getChild("AuthenticateToService");
                slService.setOptions(this.createOptionList(serviceNames));
            }
            catch (AMConsoleException e) {
                if (this.isInlineAlertMessageSet()) break block2;
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
    }

    protected String getConditionXML(String curRealm, String condType, boolean readonly) {
        String xml = readonly ? "com/sun/identity/console/propertyPMConditionAuthToService_Readonly.xml" : "com/sun/identity/console/propertyPMConditionAuthToService.xml";
        return AMAdminUtils.getStringFromInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(xml));
    }

    protected String getMissingValuesMessage() {
        return "policy.condition.missing.auth.service";
    }

    protected Map getConditionValues(PolicyModel model, String realmName, String conditionType) {
        Map map = Collections.EMPTY_MAP;
        try {
            map = helper.getConditionValues((PolicyModel)this.getModel(), this.propertySheetModel);
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        return map;
    }

    public void handleBtnSearchRequest(RequestInvocationEvent event) {
        this.submitCycle = true;
        this.bSearchForRealm = true;
        this.forwardTo();
    }

    public void handleBtnRealmRequest(RequestInvocationEvent event) {
        this.submitCycle = true;
        this.bRealmSelect = true;
        this.forwardTo();
    }

    protected void setPropertiesValues(Map values) {
        helper.setPropertiesValues(values, this.propertySheetModel);
    }
}

