/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.realm;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.realm.IDRepoViewBean;
import com.sun.identity.console.realm.model.IDRepoModel;
import com.sun.identity.console.realm.model.IDRepoModelImpl;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class IDRepoOpViewBeanBase
extends AMPrimaryMastHeadViewBean {
    protected static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    protected static final String IDREPO_NAME = "tfIdRepoName";
    protected static final String IDREPO_TYPE = "idRepoTypeName";
    protected static final String IDREPO_TYPE_NAME = "tfIdRepoTypeName";
    protected CCPageTitleModel ptModel;
    protected boolean submitCycle;
    public AMPropertySheetModel propertySheetModel;

    public IDRepoOpViewBeanBase(String name, String defaultDisplayURL) {
        super(name);
        this.setDefaultDisplayURL(defaultDisplayURL);
    }

    protected void initialize() {
        if (!this.initialized) {
            this.initialized = this.createPropertyModel();
            if (this.initialized) {
                super.initialize();
                this.createPageTitleModel();
                this.registerChildren();
            }
        }
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        return new IDRepoModelImpl(req, this.getPageSessionAttributes());
    }

    protected boolean createPropertyModel() {
        boolean created = false;
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        String type = (String)this.getPageSessionAttribute(IDREPO_TYPE);
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        if (type != null && type.trim().length() > 0) {
            IDRepoModel model = (IDRepoModel)this.getModel();
            try {
                this.propertySheetModel = new AMPropertySheetModel(model.getPropertyXMLString(realmName, ((Object)((Object)this)).getClass().getName(), type, this.isCreateViewBean()));
                this.propertySheetModel.clear();
                created = true;
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
        return created;
    }

    protected void registerChildren() {
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        super.registerChildren();
    }

    protected View createChild(String name) {
        Object view = null;
        view = this.ptModel != null && this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel != null && this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name, this.getModel()) : super.createChild(name)));
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        String idRepoName = (String)this.getPageSessionAttribute(IDREPO_NAME);
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        IDRepoModel model = (IDRepoModel)this.getModel();
        try {
            Map localizedMap = model.getIDRepoTypesMap();
            String idRepoType = (String)this.getPageSessionAttribute(IDREPO_TYPE);
            String i18nName = (String)localizedMap.get(idRepoType);
            if (!this.submitCycle) {
                this.setDefaultValues(idRepoType);
            }
            this.propertySheetModel.setValue(IDREPO_TYPE, idRepoType);
            this.propertySheetModel.setValue(IDREPO_TYPE_NAME, i18nName);
            this.propertySheetModel.setValue(IDREPO_NAME, idRepoName);
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    protected void forwardToIDRepoViewBean() {
        IDRepoViewBean vb = (IDRepoViewBean)this.getViewBean(IDRepoViewBean.class);
        this.backTrail();
        this.passPgSessionMap((ViewBean)vb);
        vb.forwardTo(this.getRequestContext());
    }

    public void handleButton3Request(RequestInvocationEvent event) {
        this.forwardToIDRepoViewBean();
    }

    protected abstract void createPageTitleModel();

    protected abstract void setDefaultValues(String var1);

    protected abstract boolean isCreateViewBean();
}

