/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.iplanet.dpro.session.SessionID;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.log.AMLogException;
import com.sun.identity.log.ILogRecord;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.spi.Debug;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class RemoteHandler
extends Handler {
    private static LogManager manager = LogManagerUtil.getLogManager();
    private int recCount = 0;
    private String bufferSize;
    private int recCountLimit;
    private Map reqSetMap = new HashMap();
    private TimeBufferingTask bufferTask;
    private boolean timeBufferingEnabled = false;
    private String logName;
    private URL logServURL;

    private void configure() {
        block7: {
            String status;
            this.bufferSize = manager.getProperty("iplanet-am-logging-buffer-size");
            if (this.bufferSize != null && this.bufferSize.length() > 0) {
                try {
                    this.recCountLimit = Integer.parseInt(this.bufferSize);
                }
                catch (NumberFormatException e) {
                    this.recCountLimit = 1;
                }
            } else {
                this.recCountLimit = 1;
            }
            if ((status = manager.getProperty("iplanet-am-logging-time-buffering-status")) != null && status.equalsIgnoreCase("ON")) {
                this.timeBufferingEnabled = true;
            }
            this.setLevel(Level.ALL);
            this.setFilter(null);
            String urlString = manager.getProperty("iplanet-am-naming-logging-url");
            try {
                this.logServURL = new URL(urlString);
            }
            catch (MalformedURLException mue) {
                if (!Debug.warningEnabled()) break block7;
                Debug.warning("RemoteHandler.getLogHostURL(): '" + urlString + "' is malformed. " + mue.getMessage());
            }
        }
    }

    public RemoteHandler(String dummyParam) {
        this.configure();
        if (this.timeBufferingEnabled) {
            this.startTimeBufferingThread();
        }
    }

    public synchronized void publish(LogRecord logRecord) {
        Map logInfoMap;
        String loggedBySid;
        this.logName = logRecord.getLoggerName();
        String xml = this.getFormatter().format(logRecord);
        if (xml == null || xml.length() <= 0) {
            if (Debug.warningEnabled()) {
                Debug.warning(this.logName + ":RemoteHandler.publish : formatted xml is null");
            }
            return;
        }
        Request request = new Request(xml);
        if (logRecord instanceof ILogRecord && (loggedBySid = (String)(logInfoMap = ((ILogRecord)((Object)logRecord)).getLogInfoMap()).get("LoggedBySid")) != null) {
            RequestSet reqSet = (RequestSet)this.reqSetMap.get(loggedBySid);
            if (reqSet == null) {
                reqSet = new RequestSet("Logging");
            }
            reqSet.addRequest(request);
            this.reqSetMap.put(loggedBySid, reqSet);
        }
        ++this.recCount;
        if (this.recCount >= this.recCountLimit) {
            if (Debug.messageEnabled()) {
                Debug.message(this.logName + ":RemoteHandler.publish(): got " + this.recCount + " records, flushing all");
            }
            this.flush();
        }
    }

    public void close() {
        this.flush();
        this.stopBufferTimer();
    }

    public synchronized void flush() {
        if (this.recCount <= 0) {
            if (Debug.messageEnabled()) {
                Debug.message("RemoteHandler.flush(): no records in buffer to send");
            }
            return;
        }
        Vector responses = new Vector();
        if (Debug.messageEnabled()) {
            Debug.message("RemoteHandler.flush(): sending buffered records");
        }
        String thisAMException = null;
        try {
            for (String currentLoggedBySID : this.reqSetMap.keySet()) {
                URL logHostURL = this.getLogHostURL(currentLoggedBySID);
                if (logHostURL == null) {
                    Debug.error("RemoteHandler.flush(): logHostURL is null");
                    this.recCount = 0;
                    this.reqSetMap = new HashMap();
                    return;
                }
                RequestSet reqSet = (RequestSet)this.reqSetMap.get(currentLoggedBySID);
                responses = PLLClient.send(logHostURL, reqSet);
                for (Response resp : responses) {
                    String respContent = resp.getContent();
                    if (respContent.equals("OK")) continue;
                    Debug.error("RemoteHandler.flush(): " + respContent + " on remote machine");
                    if (thisAMException != null) continue;
                    thisAMException = "RemoteHandler.flush(): " + respContent + " on remote machine";
                }
            }
        }
        catch (Exception e) {
            Debug.error("RemoteHandler.flush(): ", e);
        }
        this.recCount = 0;
        this.reqSetMap = new HashMap();
        if (thisAMException != null) {
            throw new AMLogException(thisAMException);
        }
    }

    private URL getLogHostURL(String loggedBySID) {
        SessionID sid = new SessionID(loggedBySID);
        String sessionProtocol = sid.getSessionServerProtocol();
        String sessionHost = sid.getSessionServer();
        String sessionPort = sid.getSessionServerPort();
        String sessionURI = sid.getSessionServerURI();
        if (!(LogManager.isLocal || sessionProtocol != null && sessionProtocol.length() > 0 && sessionHost != null && sessionHost.length() > 0)) {
            if (Debug.messageEnabled()) {
                Debug.message("RemoteHandler.getLogHostURL(): remote serv = " + this.logServURL);
            }
            return this.logServURL;
        }
        if (Debug.messageEnabled()) {
            Debug.message("RemoteHandler.getLogHostURL():  sessionProtocol: " + sessionProtocol + " sessionHost: " + sessionHost + " sessionPort: " + sessionPort + " sessionURI: " + sessionURI);
        }
        URL loggingURL = null;
        try {
            loggingURL = WebtopNaming.getServiceURL("Logging", sessionProtocol, sessionHost, sessionPort, sessionURI);
            if (Debug.messageEnabled()) {
                Debug.message("RemoteHandler.getLogHostURL(): WebtopNaming loggingservice URL: " + loggingURL);
            }
        }
        catch (URLNotFoundException unfe) {
            Debug.error("RemoteHandler.getLogHostURL(): URLNotFoundException: ", unfe);
            return null;
        }
        return loggingURL;
    }

    private void startTimeBufferingThread() {
        String period = manager.getProperty("iplanet-am-logging-buffer-time-in-seconds");
        long interval = period != null || period.length() != 0 ? Long.parseLong(period) : 3600L;
        interval *= 1000L;
        if (this.bufferTask == null) {
            block5: {
                this.bufferTask = new TimeBufferingTask(interval);
                try {
                    SystemTimer.getTimer().schedule((TaskRunnable)this.bufferTask, new Date((System.currentTimeMillis() + interval) / 1000L * 1000L));
                }
                catch (IllegalArgumentException e) {
                    Debug.error(this.logName + ":RemoteHandler:BuffTimeArg: " + e.getMessage());
                }
                catch (IllegalStateException e) {
                    if (!Debug.messageEnabled()) break block5;
                    Debug.message(this.logName + ":RemoteHandler:BuffTimeState: " + e.getMessage());
                }
            }
            if (Debug.messageEnabled()) {
                Debug.message("RemoteHandler: Time Buffering Thread Started");
            }
        }
    }

    private void stopBufferTimer() {
        if (this.bufferTask != null) {
            this.bufferTask.cancel();
            this.bufferTask = null;
            if (Debug.messageEnabled()) {
                Debug.message("RemoteHandler: Buffer Timer Stopped");
            }
        }
    }

    private class TimeBufferingTask
    extends GeneralTaskRunnable {
        private long runPeriod;

        public TimeBufferingTask(long runPeriod) {
            this.runPeriod = runPeriod;
        }

        public void run() {
            if (Debug.messageEnabled()) {
                Debug.message("RemoteHandler:TimeBufferingTask.run() called");
            }
            RemoteHandler.this.flush();
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean addElement(Object obj) {
            return false;
        }

        public boolean removeElement(Object obj) {
            return false;
        }

        public long getRunPeriod() {
            return this.runPeriod;
        }
    }
}

