/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.am.util.ThreadPool;
import com.iplanet.am.util.ThreadPoolException;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.shared.debug.Debug;

public class SMSThreadPool {
    private static ThreadPool thrdPool;
    private static ShutdownListener shutdownListener;
    private static int poolSize;
    private static Debug debug;
    private static final int DEFAULT_POOL_SIZE = 10;
    private static final int DEFAULT_TRESHOLD = 0;
    private static volatile boolean initialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized void initialize(boolean reinit) {
        if (reinit) {
            initialized = false;
        }
        if (initialized) {
            return;
        }
        int newPoolSize = 10;
        try {
            newPoolSize = SystemProperties.isServerMode() ? Integer.parseInt(SystemProperties.get("com.sun.identity.sm.notification.threadpool.size")) : 2;
        }
        catch (Exception e) {
            newPoolSize = 10;
        }
        if (newPoolSize == poolSize) {
            return;
        }
        poolSize = newPoolSize;
        if (debug.messageEnabled()) {
            debug.message("SMSThreadPool: poolSize=" + poolSize);
        }
        ShutdownManager shutdownMan = ShutdownManager.getInstance();
        if (thrdPool != null) {
            if (shutdownMan.acquireValidLock()) {
                try {
                    shutdownMan.removeShutdownListener(shutdownListener);
                    thrdPool.shutdown();
                    thrdPool = new ThreadPool("smIdmThreadPool", poolSize, 0, false, debug);
                    shutdownListener = new ShutdownListener(){

                        public void shutdown() {
                            thrdPool.shutdown();
                        }
                    };
                    shutdownMan.addShutdownListener(shutdownListener);
                }
                finally {
                    shutdownMan.releaseLockAndNotify();
                }
            }
        } else if (shutdownMan.acquireValidLock()) {
            try {
                thrdPool = new ThreadPool("smIdmThreadPool", poolSize, 0, false, debug);
                shutdownListener = new ShutdownListener(){

                    public void shutdown() {
                        thrdPool.shutdown();
                    }
                };
                shutdownMan.addShutdownListener(shutdownListener);
            }
            finally {
                shutdownMan.releaseLockAndNotify();
            }
        }
        initialized = true;
    }

    public static boolean scheduleTask(Runnable task) {
        boolean success = true;
        if (!initialized) {
            SMSThreadPool.initialize(false);
        }
        try {
            thrdPool.run(task);
        }
        catch (ThreadPoolException e) {
            debug.error("SMSThreadPool: unable to schedule task" + e);
            success = false;
        }
        return success;
    }

    static {
        debug = Debug.getInstance((String)"amSMS");
        initialized = false;
    }
}

