/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common.admin;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMObject;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.security.AdminPasswordAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Map;
import java.util.Set;

public class AdminInterfaceUtils
implements ServiceListener {
    private static boolean initialized;
    private static boolean addedListener;
    private static Debug debug;
    private static String defaultPC;
    private static String defaultGC;
    private static String defaultAC;
    private static String defaultPCCreateDuringOrgConfig;
    private static String defaultGCCreateDuringOrgConfig;
    private static String defaultORGADMIN;
    private static String defaultHELP_DESK_ADMIN;
    private static String defaultPOLICY_ADMIN;
    private static final String CONSOLE_SERVICE_NAME = "iplanetamadminconsoleservice";
    private static final String SERVICE_NAME = "dai";
    private static final String PC_ATTR_NAME = "iplanet-am-admin-console-default-pc";
    private static final String GC_ATTR_NAME = "iplanet-am-admin-console-default-gc";
    private static final String AC_ATTR_NAME = "iplanet-am-admin-console-default-ac";
    private static final String TEMPLATES = "templates";
    private static final String STRUCTURE_TEMPLATES = "StructureTemplates";
    private static final String ATTR_NAME = "name";
    private static final String PCCREATE_ATTR_NAME = "PeopleContainer";
    private static final String GCCREATE_ATTR_NAME = "GroupContainer";
    private static final String ORG_ADMIN_ATTR_NAME = "DPOrgAdminRole";
    private static final String HELP_DESK_ADMIN_ATTR_NAME = "DPOrgHelpDeskAdminRole";
    private static final String POLICY_ADMIN_ATTR_NAME = "DPOrgPolicyAdminRole";

    public static AMObject getAMObject(Debug debug, String dn, AMStoreConnection storeConn) throws AMException, SSOException {
        AMObject obj = null;
        int objectType = storeConn.getAMObjectType(dn);
        switch (objectType) {
            case 2: {
                obj = storeConn.getOrganization(dn);
                break;
            }
            case 3: {
                obj = storeConn.getOrganizationalUnit(dn);
                break;
            }
            case 9: 
            case 10: {
                obj = storeConn.getStaticGroup(dn);
                break;
            }
            case 11: {
                obj = storeConn.getDynamicGroup(dn);
                break;
            }
            case 12: {
                obj = storeConn.getAssignableDynamicGroup(dn);
                break;
            }
            case 6: {
                obj = storeConn.getRole(dn);
                break;
            }
            case 8: {
                obj = storeConn.getFilteredRole(dn);
                break;
            }
            case 1: {
                obj = storeConn.getUser(dn);
                break;
            }
            case 5: {
                obj = storeConn.getPeopleContainer(dn);
                break;
            }
            case 4: {
                obj = storeConn.getGroupContainer(dn);
                break;
            }
            default: {
                if (!debug.warningEnabled()) break;
                debug.warning("AdminInterfaceUtils.getAMObject: Cannot create AMObject for:" + dn);
            }
        }
        return obj;
    }

    public static boolean inOrganizationalUnit(Debug debug, AMStoreConnection storeConn, AMObject obj) {
        boolean inOrgUnit = false;
        String parentDN = obj.getParentDN();
        try {
            while (parentDN != null && !inOrgUnit) {
                if (storeConn.getAMObjectType(parentDN) == 3) {
                    inOrgUnit = true;
                    continue;
                }
                AMObject parent = AdminInterfaceUtils.getAMObject(debug, parentDN, storeConn);
                parentDN = parent != null ? parent.getParentDN() : null;
            }
        }
        catch (SSOException ssoe) {
            debug.warning("AdminInterfaceUtils.inOrganizationalUnit", (Throwable)((Object)ssoe));
        }
        catch (AMException ame) {
            debug.warning("AdminInterfaceUtils.inOrganizationalUnit", (Throwable)ame);
        }
        return inOrgUnit;
    }

    public static String getNamingAttribute(int object, Debug debug) {
        String namingAttribute = "";
        try {
            namingAttribute = AMStoreConnection.getNamingAttribute(object);
        }
        catch (AMException ame) {
            debug.warning("couldn't get naming attribute");
        }
        return namingAttribute;
    }

    public static String defaultPeopleContainerName() {
        AdminInterfaceUtils.initialize();
        return defaultPC;
    }

    public static String defaultGroupContainerName() {
        AdminInterfaceUtils.initialize();
        return defaultGC;
    }

    public static String defaultAgentContainerName() {
        AdminInterfaceUtils.initialize();
        return defaultAC;
    }

    public static String defaultPCCreateDuringOrgConfig() {
        AdminInterfaceUtils.initialize();
        return defaultPCCreateDuringOrgConfig;
    }

    public static String defaultGCCreateDuringOrgConfig() {
        AdminInterfaceUtils.initialize();
        return defaultGCCreateDuringOrgConfig;
    }

    public static String defaultOrgAdminRoleCreateDuringOrgConfig() {
        AdminInterfaceUtils.initialize();
        return defaultORGADMIN;
    }

    public static String defaultHelpDeskAdminRoleCreateDuringOrgConfig() {
        AdminInterfaceUtils.initialize();
        return defaultHELP_DESK_ADMIN;
    }

    public static String defaultPolicyAdminRoleCreateDuringOrgConfig() {
        AdminInterfaceUtils.initialize();
        return defaultPOLICY_ADMIN;
    }

    private static void initialize() {
        if (!initialized) {
            try {
                String adminDN = (String)AccessController.doPrivileged(new AdminDNAction());
                String adminPassword = (String)AccessController.doPrivileged(new AdminPasswordAction());
                SSOTokenManager mgr = SSOTokenManager.getInstance();
                ServiceConfigManager scm = new ServiceConfigManager(SERVICE_NAME, mgr.createSSOToken(new AuthPrincipal(adminDN), adminPassword));
                if (!addedListener) {
                    addedListener = true;
                    scm.addListener(new AdminInterfaceUtils());
                }
                ServiceConfig globalConfig = scm.getGlobalConfig(null);
                ServiceConfig templatesConfig = globalConfig.getSubConfig(TEMPLATES);
                ServiceConfig structTemplateSubConfig = templatesConfig.getSubConfig(STRUCTURE_TEMPLATES);
                ServiceConfig groupContConfig = structTemplateSubConfig.getSubConfig(GCCREATE_ATTR_NAME);
                ServiceConfig peopleContConfig = structTemplateSubConfig.getSubConfig(PCCREATE_ATTR_NAME);
                ServiceConfig orgAdminConfig = structTemplateSubConfig.getSubConfig(ORG_ADMIN_ATTR_NAME);
                ServiceConfig helpDeskAdminConfig = structTemplateSubConfig.getSubConfig(HELP_DESK_ADMIN_ATTR_NAME);
                ServiceConfig policyAdminConfig = structTemplateSubConfig.getSubConfig(POLICY_ADMIN_ATTR_NAME);
                defaultGCCreateDuringOrgConfig = AdminInterfaceUtils.getConfigAttributeValue(groupContConfig, defaultGCCreateDuringOrgConfig);
                defaultPCCreateDuringOrgConfig = AdminInterfaceUtils.getConfigAttributeValue(peopleContConfig, defaultPCCreateDuringOrgConfig);
                defaultORGADMIN = AdminInterfaceUtils.getConfigAttributeValue(orgAdminConfig, defaultORGADMIN);
                defaultHELP_DESK_ADMIN = AdminInterfaceUtils.getConfigAttributeValue(helpDeskAdminConfig, defaultHELP_DESK_ADMIN);
                defaultPOLICY_ADMIN = AdminInterfaceUtils.getConfigAttributeValue(policyAdminConfig, defaultPOLICY_ADMIN);
                ServiceSchemaManager sm = new ServiceSchemaManager(CONSOLE_SERVICE_NAME, mgr.createSSOToken(new AuthPrincipal(adminDN), adminPassword));
                if (!addedListener) {
                    addedListener = true;
                    sm.addListener(new AdminInterfaceUtils());
                }
                ServiceSchema schema = sm.getGlobalSchema();
                defaultAC = AdminInterfaceUtils.getAttributeValue(schema, AC_ATTR_NAME, defaultAC);
                defaultGC = AdminInterfaceUtils.getAttributeValue(schema, GC_ATTR_NAME, defaultGC);
                defaultPC = AdminInterfaceUtils.getAttributeValue(schema, PC_ATTR_NAME, defaultPC);
            }
            catch (Exception e) {
                debug.warning("AdminInterfaceUtils: Unable to get default People, Groups, Org Admin Role, Help Desk Admin Role, Policy Admin Role and Agents containers from SM", (Throwable)e);
            }
            if (debug.messageEnabled()) {
                debug.message("AdminInterfaceUtils: Defaults container: " + defaultPC + ", " + defaultGC + ", " + defaultAC + ", " + defaultPCCreateDuringOrgConfig + ", " + defaultGCCreateDuringOrgConfig + ", " + defaultORGADMIN + ", " + defaultHELP_DESK_ADMIN + ", " + defaultPOLICY_ADMIN);
            }
            initialized = true;
        }
    }

    private static String getAttributeValue(ServiceSchema ss, String an, String dv) throws SSOException, SMSException {
        Set values;
        String answer = dv;
        AttributeSchema as = ss.getAttributeSchema(an);
        if (as != null && (values = as.getDefaultValues()) != null && !values.isEmpty()) {
            answer = (String)values.iterator().next();
        }
        return answer;
    }

    private static String getConfigAttributeValue(ServiceConfig sc, String dv) throws SSOException, SMSException {
        String answer = dv;
        Map configMap = sc.getAttributes();
        if (configMap != null) {
            Set values = (Set)configMap.get(ATTR_NAME);
            if (values == null || values.isEmpty()) {
                return null;
            }
            answer = (String)values.iterator().next();
            int indx = answer.indexOf("=");
            if (indx >= 0) {
                answer = answer.substring(indx + 1);
                if (debug.messageEnabled()) {
                    debug.message("AdminInterfaceUtils: getConfigAttributeValue: " + answer);
                }
            }
        }
        return answer;
    }

    public void schemaChanged(String serviceName, String version) {
        if (serviceName.toLowerCase().equals(SERVICE_NAME)) {
            initialized = false;
        }
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
        if (serviceName.toLowerCase().equals(SERVICE_NAME)) {
            initialized = false;
        }
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
        if (serviceName.toLowerCase().equals(SERVICE_NAME)) {
            initialized = false;
        }
    }

    static {
        debug = Debug.getInstance((String)"amConsole");
        defaultPC = "People";
        defaultGC = "Groups";
        defaultAC = "Agents";
        defaultPCCreateDuringOrgConfig = "People";
        defaultGCCreateDuringOrgConfig = "Groups";
        defaultORGADMIN = "Organization Admin Role";
        defaultHELP_DESK_ADMIN = "Organization Help Desk Admin Role";
        defaultPOLICY_ADMIN = "Organization Policy Admin Role";
    }
}

