/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.policy.SubjectEditViewBean;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.IdentitySubjectModel;
import com.sun.identity.console.policy.model.IdentitySubjectModelImpl;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.web.ui.view.addremove.CCAddRemove;
import com.sun.web.ui.view.html.CCDropDownMenu;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class IdentitySubjectEditViewBean
extends SubjectEditViewBean {
    public static final String DEFAULT_DISPLAY_URL = "/console/policy/IdentitySubjectEdit.jsp";
    private static final String FILTER_TYPE = "tfType";
    private static final String ENTITY_TYPE = "searchEntityType";

    public IdentitySubjectEditViewBean() {
        super("IdentitySubjectEdit", DEFAULT_DISPLAY_URL);
    }

    protected String getPropertyXMLFileName(boolean readonly) {
        return readonly ? "com/sun/identity/console/propertyPMIdentitySubject_Readonly.xml" : "com/sun/identity/console/propertyPMIdentitySubject.xml";
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        IdentitySubjectModel model = (IdentitySubjectModel)this.getModel();
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        Set values = null;
        if (this.bFilter) {
            Set defaultValue = this.getValues();
            if (defaultValue != null) {
                values = this.getAMIdentity(model, defaultValue);
            }
        } else {
            values = this.getAMIdentity(model, this.getDefaultValues(model));
        }
        super.beginDisplay(event);
        if (this.canModify) {
            Map supportedEntityTypes = model.getSupportedEntityTypes(realmName);
            CCDropDownMenu menu = (CCDropDownMenu)this.getChild(FILTER_TYPE);
            OptionList entityTypes = this.createOptionList(supportedEntityTypes);
            entityTypes.add(0, "policy.subject.select.identity.type", "");
            menu.setOptions(entityTypes);
            menu.setValue((Object)"");
            CCAddRemove child = (CCAddRemove)this.getChild("valuesMultipleChoiceValue");
            child.restoreStateData();
            OptionList selected = this.addRemoveModel.getSelectedOptionList();
            child.resetStateData();
            this.addRemoveModel.setAvailableOptionList(this.createOptionList(this.getPossibleValues(model, realmName, values)));
            if (this.submitCycle) {
                this.addRemoveModel.setSelectedOptionList(selected);
            } else {
                this.addRemoveModel.setSelectedOptionList(this.createOptionList(values));
            }
        } else {
            this.propertySheetModel.setValue("valuesMultipleChoiceValue", AMAdminUtils.getString(this.getDefaultValues(), ",", false));
        }
    }

    private Set getPossibleValues(IdentitySubjectModel model, String realmName, Set values) {
        Set possibleValues = null;
        String searchEntityType = (String)this.getPageSessionAttribute(ENTITY_TYPE);
        if (searchEntityType != null && searchEntityType.length() > 0) {
            String pattern = (String)this.propertySheetModel.getValue("tfFilter");
            try {
                IdSearchResults results = model.getEntityNames(realmName, searchEntityType, pattern);
                int errorCode = results.getErrorCode();
                switch (errorCode) {
                    case 1: {
                        this.setInlineAlertMessage("warning", "message.warning", "message.sizelimit.exceeded");
                        break;
                    }
                    case 2: {
                        this.setInlineAlertMessage("warning", "message.warning", "message.timelimit.exceeded");
                    }
                }
                possibleValues = results.getSearchResults();
                Set hiddenUsers = model.getSpecialUsers(realmName);
                possibleValues.removeAll(hiddenUsers);
                if (possibleValues != null && !possibleValues.isEmpty()) {
                    if (this.submitCycle) {
                        CCAddRemove child = (CCAddRemove)this.getChild("valuesMultipleChoiceValue");
                        Set selected = IdentitySubjectEditViewBean.getValues(this.addRemoveModel.getSelectedOptionList());
                        if (selected != null && !selected.isEmpty()) {
                            Set amids = this.getAMIdentity(model, selected);
                            possibleValues.removeAll(amids);
                        }
                    } else if (values != null) {
                        possibleValues.removeAll(values);
                    }
                }
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
        return possibleValues != null ? possibleValues : Collections.EMPTY_SET;
    }

    protected Set getDefaultValues(IdentitySubjectModel model) {
        Set values = null;
        String subjectName = (String)this.getPageSessionAttribute("subjectName");
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            Subject subject = policy.getSubject(subjectName);
            values = subject.getValues();
        }
        catch (NameNotFoundException e) {
            debug.warning("IdentitySubjectEditViewBean.getDefaultValues", (Throwable)e);
        }
        catch (AMConsoleException e) {
            debug.warning("IdentitySubjectEditViewBean.getDefaultValues", (Throwable)e);
        }
        return values != null ? values : Collections.EMPTY_SET;
    }

    private Set getAMIdentity(IdentitySubjectModel model, Set ids) {
        HashSet<AMIdentity> values = Collections.EMPTY_SET;
        if (ids != null && !ids.isEmpty()) {
            values = new HashSet<AMIdentity>(ids.size() * 2);
            SSOToken token = model.getUserSSOToken();
            for (String id : ids) {
                try {
                    AMIdentity amid = IdUtils.getIdentity(token, id);
                    values.add(amid);
                }
                catch (IdRepoException e) {
                    debug.warning("IdentitySubjectEditViewBean.getAMIdentity", (Throwable)e);
                }
            }
        }
        return values;
    }

    protected Set getValues(String subjectType) throws ModelControlException {
        CCAddRemove child = (CCAddRemove)this.getChild("valuesMultipleChoiceValue");
        child.restoreStateData();
        Set values = IdentitySubjectEditViewBean.getValues(this.addRemoveModel.getSelectedOptionList());
        if (values == null || values.isEmpty()) {
            this.setInlineAlertMessage("error", "message.error", "policy.missing.subject.value");
            values = null;
        }
        return values;
    }

    protected void setAddRemoveModel() throws ModelControlException {
    }

    protected OptionList createOptionList(Set values) {
        OptionList optList = new OptionList();
        if (values != null && !values.isEmpty()) {
            for (AMIdentity identity : values) {
                optList.add(PolicyUtils.getDNDisplayString(identity.getName()), IdUtils.getUniversalId(identity));
            }
        }
        return optList;
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = this.getRequestContext().getRequest();
        return new IdentitySubjectModelImpl(req, this.getPageSessionAttributes());
    }

    public void handleBtnFilterRequest(RequestInvocationEvent event) {
        CCDropDownMenu menu = (CCDropDownMenu)this.getChild(FILTER_TYPE);
        this.setPageSessionAttribute(ENTITY_TYPE, (Serializable)((Object)((String)menu.getValue())));
        super.handleBtnFilterRequest(event);
    }

    public boolean beginChildDisplay(ChildDisplayEvent event) {
        return true;
    }

    protected Set getValidValues() {
        return Collections.EMPTY_SET;
    }
}

