/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.base.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.model.AMAuthUtils;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.base.model.AccessControlModel;
import com.sun.identity.delegation.DelegationEvaluator;
import com.sun.identity.delegation.DelegationException;
import com.sun.identity.delegation.DelegationPermission;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class AccessControlModelImpl
implements AccessControlModel {
    private SSOToken ssoToken = null;
    private Set serviceNames;

    public AccessControlModelImpl(SSOToken ssoToken) {
        this.ssoToken = ssoToken;
    }

    public AccessControlModelImpl(HttpServletRequest req) {
        try {
            this.ssoToken = AMAuthUtils.getSSOToken(req);
        }
        catch (SSOException e) {
            AMModelBase.debug.warning("AccessControlModelImpl.<init>", (Throwable)((Object)e));
        }
    }

    public boolean canView(Set permissions, String accessLevel, String realmName, boolean delegateUI) {
        boolean canView = false;
        if (this.ssoToken != null) {
            if (permissions.isEmpty()) {
                canView = true;
            } else {
                try {
                    DelegationEvaluator delegationEvaluator = new DelegationEvaluator();
                    DelegationPermission delegationPermission = new DelegationPermission();
                    delegationPermission.setVersion("*");
                    delegationPermission.setSubConfigName("default");
                    if (accessLevel != null && accessLevel.trim().length() > 0) {
                        delegationPermission.setConfigType(accessLevel);
                        delegationPermission.setOrganizationName("/");
                    } else {
                        delegationPermission.setOrganizationName(realmName);
                    }
                    if (delegateUI) {
                        HashSet<String> actions = new HashSet<String>();
                        actions.add("DELEGATE");
                        delegationPermission.setActions(actions);
                        canView = delegationEvaluator.isAllowed(this.ssoToken, delegationPermission, Collections.EMPTY_MAP);
                    }
                    if (!delegateUI || canView) {
                        Iterator i = permissions.iterator();
                        while (i.hasNext() && !canView) {
                            String serviceName = (String)i.next();
                            canView = this.hasPermission(delegationEvaluator, delegationPermission, serviceName, "READ");
                        }
                    }
                }
                catch (DelegationException e) {
                    AMModelBase.debug.error("AccessControlModelImpl.canView", (Throwable)e);
                }
                catch (SSOException e) {
                    AMModelBase.debug.error("AccessControlModelImpl.canView", (Throwable)((Object)e));
                }
            }
        }
        return canView;
    }

    private boolean hasPermission(DelegationEvaluator delegationEvaluator, DelegationPermission delegationPermission, String serviceName, String privilege) throws DelegationException, SSOException {
        boolean hasP = false;
        HashSet<String> actions = new HashSet<String>();
        actions.add(privilege);
        delegationPermission.setActions(actions);
        if (serviceName.equals("ANY_SERVICE")) {
            Set services = this.getServiceNames();
            Iterator i = services.iterator();
            while (i.hasNext() && !hasP) {
                String name = (String)i.next();
                delegationPermission.setServiceName(name);
                hasP = delegationEvaluator.isAllowed(this.ssoToken, delegationPermission, Collections.EMPTY_MAP);
            }
        } else {
            delegationPermission.setServiceName(serviceName);
            hasP = delegationEvaluator.isAllowed(this.ssoToken, delegationPermission, Collections.EMPTY_MAP);
        }
        return hasP;
    }

    private Set getServiceNames() {
        if (this.serviceNames == null) {
            SSOToken adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            try {
                ServiceManager sm = new ServiceManager(adminSSOToken);
                this.serviceNames = sm.getServiceNames();
            }
            catch (SSOException e) {
                AMModelBase.debug.error("AccessControlModelImpl.getServiceNames", (Throwable)((Object)e));
            }
            catch (SMSException e) {
                AMModelBase.debug.error("AccessControlModelImpl.getServiceNames", (Throwable)e);
            }
        }
        return this.serviceNames;
    }
}

