/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.ApplicationType;
import com.sun.identity.entitlement.EntitlementCombiner;
import com.sun.identity.entitlement.EntitlementConfiguration;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.ResourceSaveIndexes;
import com.sun.identity.entitlement.ResourceSearchIndexes;
import com.sun.identity.entitlement.ValidateResourceResult;
import com.sun.identity.entitlement.interfaces.ISaveIndex;
import com.sun.identity.entitlement.interfaces.ISearchIndex;
import com.sun.identity.entitlement.interfaces.ResourceName;
import com.sun.identity.policy.ResourceMatch;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Application
implements Cloneable {
    private String realm = "/";
    private String name;
    private ApplicationType applicationType;
    private Map<String, Boolean> actions;
    private Set<String> conditions;
    private Set<String> subjects;
    private Set<String> resources;
    private Class entitlementCombiner;
    private Class searchIndex;
    private Class saveIndex;
    private Class resourceComparator;
    private Set<String> attributeNames;
    private ResourceName resourceComparatorInstance;
    private ISaveIndex saveIndexInstance;
    private ISearchIndex searchIndexInstance;

    private Application() {
    }

    public Application(String realm, String name, ApplicationType applicationType) {
        this.realm = realm;
        this.name = name;
        this.applicationType = applicationType;
    }

    public Application clone() {
        Application clone = new Application();
        clone.name = this.name;
        clone.realm = this.realm;
        clone.applicationType = this.applicationType;
        if (this.actions != null) {
            clone.actions = new HashMap<String, Boolean>();
            clone.actions.putAll(this.actions);
        }
        if (this.conditions != null) {
            clone.conditions = new HashSet<String>();
            clone.conditions.addAll(this.conditions);
        }
        if (this.subjects != null) {
            clone.subjects = new HashSet<String>();
            clone.subjects.addAll(this.subjects);
        }
        if (this.resources != null) {
            clone.resources = new HashSet<String>();
            clone.resources.addAll(this.resources);
        }
        clone.entitlementCombiner = this.entitlementCombiner;
        clone.searchIndex = this.searchIndex;
        clone.searchIndexInstance = this.searchIndexInstance;
        clone.saveIndex = this.saveIndex;
        clone.saveIndexInstance = this.saveIndexInstance;
        clone.resourceComparator = this.resourceComparator;
        clone.resourceComparatorInstance = this.resourceComparatorInstance;
        if (this.attributeNames != null) {
            clone.attributeNames = new HashSet<String>();
            clone.attributeNames.addAll(this.attributeNames);
        }
        return clone;
    }

    public Map<String, Boolean> getActions() {
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        if (this.applicationType.getActions() != null) {
            results.putAll(this.applicationType.getActions());
        }
        if (this.actions != null) {
            results.putAll(this.actions);
        }
        return results;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public Set<String> getConditions() {
        return this.conditions;
    }

    public Set<String> getSubjects() {
        return this.subjects;
    }

    public Class getEntitlementCombinerClass() {
        return this.entitlementCombiner;
    }

    public EntitlementCombiner getEntitlementCombiner() {
        if (this.entitlementCombiner != null) {
            try {
                return (EntitlementCombiner)this.entitlementCombiner.newInstance();
            }
            catch (InstantiationException e) {
                PrivilegeManager.debug.error("Application.getEntitlementCombiner", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                PrivilegeManager.debug.error("Application.getEntitlementCombiner", (Throwable)e);
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setActions(Map<String, Boolean> actions) {
        this.actions = actions;
    }

    public void setConditions(Set<String> conditions) {
        this.conditions = conditions;
    }

    public void setSubjects(Set<String> subjects) {
        this.subjects = subjects;
    }

    public void setSaveIndex(Class saveIndex) throws InstantiationException, IllegalAccessException {
        this.saveIndex = saveIndex;
        this.saveIndexInstance = saveIndex != null ? (ISaveIndex)saveIndex.newInstance() : null;
    }

    public void setSearchIndex(Class searchIndex) throws InstantiationException, IllegalAccessException {
        this.searchIndex = searchIndex;
        this.searchIndexInstance = searchIndex != null ? (ISearchIndex)searchIndex.newInstance() : null;
    }

    public void setResources(Set<String> resources) {
        this.resources = new HashSet<String>();
        if (resources != null) {
            this.resources.addAll(resources);
        }
    }

    public void addResources(Set<String> resources) {
        if (this.resources == null) {
            this.resources = new HashSet<String>();
        }
        this.resources.addAll(resources);
    }

    public void removeResources(Set<String> resources) {
        if (this.resources != null) {
            this.resources.removeAll(resources);
        }
    }

    public void setEntitlementCombiner(Class entitlementCombiner) {
        this.entitlementCombiner = entitlementCombiner;
    }

    public void setResourceComparator(Class resourceComparator) throws InstantiationException, IllegalAccessException {
        this.resourceComparator = resourceComparator;
        this.resourceComparatorInstance = resourceComparator != null ? (ResourceName)resourceComparator.newInstance() : null;
    }

    public Set<String> getResources() {
        return this.resources;
    }

    public ResourceSearchIndexes getResourceSearchIndex(String resource) {
        return this.searchIndex == null ? this.applicationType.getResourceSearchIndex(resource) : this.searchIndexInstance.getIndexes(resource);
    }

    public ResourceSaveIndexes getResourceSaveIndex(String resource) {
        return this.saveIndex == null ? this.applicationType.getResourceSaveIndex(resource) : this.saveIndexInstance.getIndexes(resource);
    }

    public Class getSaveIndexClass() {
        return this.saveIndex;
    }

    public Class getSearchIndexClass() {
        return this.searchIndex;
    }

    public Class getResourceComparatorClass() {
        return this.resourceComparator;
    }

    public ResourceName getResourceComparator() {
        return this.resourceComparator == null ? this.applicationType.getResourceComparator() : this.resourceComparatorInstance;
    }

    public void addAction(Subject adminSubject, String name, boolean val) throws EntitlementException {
        EntitlementConfiguration ec = EntitlementConfiguration.getInstance(adminSubject, this.realm);
        ec.addApplicationAction(this.name, name, val);
    }

    public void setAttributeNames(Set<String> names) {
        this.attributeNames = new HashSet<String>();
        if (names != null) {
            this.attributeNames.addAll(names);
        }
    }

    public ISaveIndex getSaveIndex() {
        return this.saveIndexInstance;
    }

    public ISearchIndex getSearchIndex() {
        return this.searchIndexInstance;
    }

    public Set<String> getAttributeNames() {
        return this.attributeNames;
    }

    public ValidateResourceResult validateResourceName(String resource) {
        boolean match;
        block4: {
            ResourceName resComp = this.getResourceComparator();
            match = false;
            String res = null;
            try {
                res = resComp.canonicalize(resource);
                if (this.resources == null || this.resources.isEmpty()) break block4;
                for (String r : this.resources) {
                    ResourceMatch rm = resComp.compare(res, resComp.canonicalize(r), true);
                    if (!rm.equals(ResourceMatch.EXACT_MATCH) && !rm.equals(ResourceMatch.SUB_RESOURCE_MATCH) && !rm.equals(ResourceMatch.WILDCARD_MATCH)) continue;
                    match = true;
                    break;
                }
            }
            catch (EntitlementException ex) {
                Object[] args = new Object[]{resource};
                return new ValidateResourceResult(1, "resource.validation.invalid.resource", args);
            }
        }
        if (!match) {
            Object[] args = new Object[]{resource};
            return new ValidateResourceResult(2, "resource.validation.does.not.match.valid.resources", args);
        }
        return new ValidateResourceResult(0, "");
    }

    public Application refers(String realm, Set<String> res) {
        Application clone = this.clone();
        clone.realm = realm;
        clone.resources.clear();
        clone.resources.addAll(res);
        return clone;
    }
}

