/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.plugins;

import com.iplanet.dpro.session.SessionException;
import com.iplanet.dpro.session.service.SessionService;
import com.iplanet.dpro.session.share.SessionBundle;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.common.GeneralTaskRunnable;
import com.sun.identity.common.SystemTimer;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.ha.FAMPersisterManager;
import com.sun.identity.ha.FAMRecord;
import com.sun.identity.ha.FAMRecordPersister;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.plugins.JMQSAML2Repository;
import com.sun.identity.session.util.SessionUtils;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.jms.IllegalStateException;

public class DefaultJMQSAML2Repository
extends GeneralTaskRunnable
implements JMQSAML2Repository {
    public static final String READ = "READ";
    public static final String WRITE = "WRITE";
    public static final String DELETE = "DELETE";
    public static final String DELETEBYDATE = "DELETEBYDATE";
    String serverId;
    private static boolean isDatabaseUp = true;
    private static long gracePeriod = 300L;
    private static final String CLEANUP_GRACE_PERIOD = "com.sun.identity.session.repository.cleanupGracePeriod";
    private static final String BRIEF_DB_ERROR_MSG = "SAML2 failover service is not functional due to DB unavailability.";
    private static final String DB_ERROR_MSG = "SAML2 database is not available at this moment.Please check with the system administrator for appropriate actions";
    private static final String LOG_MSG_DB_BACK_ONLINE = "SESSION_DATABASE_BACK_ONLINE";
    private static final String LOG_MSG_DB_UNAVAILABLE = "SESSION_DATABASE_UNAVAILABLE";
    private static boolean lastLoggedDBStatusIsUp = true;
    private static long cleanUpPeriod = 300000L;
    private static long cleanUpValue = 0L;
    public static final String CLEANUP_RUN_PERIOD = "com.sun.identity.saml2.repository.cleanupRunPeriod";
    private static long healthCheckPeriod = 60000L;
    public static final String HEALTH_CHECK_RUN_PERIOD = "com.sun.identity.saml2.repository.healthCheckRunPeriod";
    private static long runPeriod = 60000L;
    static Debug debug = SAML2Utils.debug;
    private String SAML2 = "saml2";
    public FAMRecordPersister pSession = null;

    public DefaultJMQSAML2Repository() throws Exception {
        String thisSessionServerProtocol = SystemPropertiesManager.get((String)"com.iplanet.am.server.protocol");
        String thisSessionServer = SystemPropertiesManager.get((String)"com.iplanet.am.server.host");
        String thisSessionServerPortAsString = SystemPropertiesManager.get((String)"com.iplanet.am.server.port");
        String thisSessionURI = SystemPropertiesManager.get((String)"com.iplanet.am.services.deploymentDescriptor");
        if (thisSessionServerProtocol == null || thisSessionServerPortAsString == null || thisSessionServer == null) {
            throw new SessionException(SessionBundle.rbName, "propertyMustBeSet", null);
        }
        this.serverId = WebtopNaming.getServerID((String)thisSessionServerProtocol, (String)thisSessionServer, (String)thisSessionServerPortAsString, (String)thisSessionURI);
        this.initPersistSession();
        SystemTimer.getTimer().schedule((TaskRunnable)this, new Date(System.currentTimeMillis() / 1000L * 1000L));
    }

    private void initPersistSession() {
        block2: {
            try {
                FAMPersisterManager.getInstance();
                this.pSession = FAMPersisterManager.getFAMRecordPersister();
                isDatabaseUp = true;
            }
            catch (Exception e) {
                isDatabaseUp = false;
                debug.error(BRIEF_DB_ERROR_MSG);
                if (!debug.messageEnabled()) break block2;
                debug.message(DB_ERROR_MSG, (Throwable)e);
            }
        }
    }

    public Object retrieve(String samlKey) {
        if (!isDatabaseUp) {
            return null;
        }
        try {
            FAMRecord famRec = new FAMRecord(this.SAML2, READ, samlKey, 0L, null, 0, null, null);
            FAMRecord retRec = this.pSession.send(famRec);
            byte[] blob = retRec.getBlob();
            Object retObj = SessionUtils.decode((byte[])blob);
            return retObj;
        }
        catch (IllegalStateException e) {
            isDatabaseUp = false;
            this.logDBStatus();
            debug.error(BRIEF_DB_ERROR_MSG, (Throwable)e);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, (Throwable)e);
            }
            return null;
        }
        catch (Exception e) {
            debug.message("JMQSAML2Repository.retrieve(): failed retrieving SAML2 object", (Throwable)e);
            return null;
        }
    }

    public List retrieveWithSecondaryKey(String secKey) {
        if (!isDatabaseUp) {
            return null;
        }
        try {
            Vector blobs;
            FAMRecord famRec = new FAMRecord(this.SAML2, "READ_WITH_SEC_KEY", null, 0L, secKey, 0, null, null);
            FAMRecord retRec = this.pSession.send(famRec);
            HashMap map = retRec.getExtraStringAttributes();
            if (map != null && !map.isEmpty() && (blobs = (Vector)map.values().iterator().next()) != null && !blobs.isEmpty()) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (int i = 0; i < blobs.size(); ++i) {
                    byte[] blob = (byte[])blobs.get(i);
                    Object obj = SessionUtils.decode((byte[])blob);
                    list.add(obj);
                }
                return list;
            }
            return null;
        }
        catch (IllegalStateException e) {
            isDatabaseUp = false;
            this.logDBStatus();
            debug.error(BRIEF_DB_ERROR_MSG, (Throwable)e);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, (Throwable)e);
            }
            return null;
        }
        catch (Exception e) {
            debug.message("JMQSAML2Repository.retrieve(): failed retrieving SAML2 object", (Throwable)e);
            return null;
        }
    }

    public void delete(String samlKey) {
        if (!isDatabaseUp) {
            return;
        }
        try {
            FAMRecord famRec = new FAMRecord(this.SAML2, DELETE, samlKey, 0L, null, 0, null, null);
            FAMRecord fAMRecord = this.pSession.send(famRec);
        }
        catch (IllegalStateException e) {
            isDatabaseUp = false;
            this.logDBStatus();
            debug.error(BRIEF_DB_ERROR_MSG, (Throwable)e);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, (Throwable)e);
            }
        }
        catch (Exception e) {
            debug.error("JMQSAML2Repository.delete(): failed deleting SAML2 object", (Throwable)e);
        }
    }

    public void deleteExpired() {
        if (!isDatabaseUp) {
            return;
        }
        try {
            long date = System.currentTimeMillis() / 1000L;
            FAMRecord famRec = new FAMRecord(this.SAML2, DELETEBYDATE, null, date, null, 0, null, null);
            FAMRecord retRec = this.pSession.send(famRec);
        }
        catch (IllegalStateException e) {
            isDatabaseUp = false;
            this.logDBStatus();
            debug.error(BRIEF_DB_ERROR_MSG, (Throwable)e);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, (Throwable)e);
            }
        }
        catch (Exception e) {
            debug.error("JMQSAML2Repository.deleteExpired(): failed deleting Expired saml2 object", (Throwable)e);
        }
    }

    public void save(String samlKey, Object samlObj, long expirationTime, String secKey) {
        if (!isDatabaseUp) {
            return;
        }
        try {
            byte[] blob = SessionUtils.encode((Object)samlObj);
            FAMRecord famRec = new FAMRecord(this.SAML2, WRITE, samlKey, expirationTime, secKey, 0, null, blob);
            FAMRecord retRec = this.pSession.send(famRec);
        }
        catch (IllegalStateException e) {
            isDatabaseUp = false;
            this.logDBStatus();
            debug.error(BRIEF_DB_ERROR_MSG, (Throwable)e);
            if (debug.messageEnabled()) {
                debug.message(DB_ERROR_MSG, (Throwable)e);
            }
        }
        catch (Exception e) {
            debug.error("JMQSAML2Repository.save(): failed to save SAML2 object", (Throwable)e);
        }
    }

    private void logDBStatus() {
        SessionService ss = SessionService.getSessionService();
        if (!isDatabaseUp && lastLoggedDBStatusIsUp) {
            ss.logSystemMessage(LOG_MSG_DB_UNAVAILABLE, Level.WARNING);
            lastLoggedDBStatusIsUp = false;
        }
        if (isDatabaseUp && !lastLoggedDBStatusIsUp) {
            ss.logSystemMessage(LOG_MSG_DB_BACK_ONLINE, Level.INFO);
            lastLoggedDBStatusIsUp = true;
        }
    }

    public long getRunPeriod() {
        return runPeriod;
    }

    public boolean addElement(Object obj) {
        return false;
    }

    public boolean removeElement(Object obj) {
        return false;
    }

    public boolean isEmpty() {
        return true;
    }

    public void run() {
        String classMethod = "DefaultJMQSAML2Repository.run: ";
        try {
            if (debug.messageEnabled()) {
                debug.message(classMethod + "Cleaning expired SAML2 records");
            }
            if (SAML2Utils.isSAML2FailOverEnabled() && cleanUpValue <= 0L) {
                this.deleteExpired();
                cleanUpValue = cleanUpPeriod;
            }
            cleanUpValue -= runPeriod;
            if (SAML2Utils.isSAML2FailOverEnabled() && !isDatabaseUp) {
                this.initPersistSession();
                this.logDBStatus();
            }
        }
        catch (Exception e) {
            debug.error("JMQSAML2Repository.run(): Exception in thread", (Throwable)e);
        }
    }

    static {
        try {
            gracePeriod = Integer.parseInt(SystemPropertiesManager.get((String)CLEANUP_GRACE_PERIOD, (String)String.valueOf(gracePeriod)));
        }
        catch (Exception e) {
            debug.error("Invalid value for com.sun.identity.session.repository.cleanupGracePeriod, using default");
        }
        try {
            cleanUpPeriod = Integer.parseInt(SystemPropertiesManager.get((String)CLEANUP_RUN_PERIOD, (String)String.valueOf(cleanUpPeriod)));
        }
        catch (Exception e) {
            debug.error("Invalid value for com.sun.identity.saml2.repository.cleanupRunPeriod, using default");
        }
        try {
            healthCheckPeriod = Integer.parseInt(SystemPropertiesManager.get((String)HEALTH_CHECK_RUN_PERIOD, (String)String.valueOf(healthCheckPeriod)));
        }
        catch (Exception e) {
            debug.error("Invalid value for com.sun.identity.saml2.repository.healthCheckRunPeriod, using default");
        }
        runPeriod = cleanUpPeriod <= healthCheckPeriod ? cleanUpPeriod : healthCheckPeriod;
        cleanUpValue = cleanUpPeriod;
    }
}

