/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security.handler;

import com.iplanet.security.x509.CertUtils;
import com.iplanet.services.naming.URLNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.X509CertificateCallback;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.wss.logging.LogUtil;
import com.sun.identity.wss.provider.ProviderConfig;
import com.sun.identity.wss.security.AssertionToken;
import com.sun.identity.wss.security.BinarySecurityToken;
import com.sun.identity.wss.security.FAMSecurityToken;
import com.sun.identity.wss.security.KerberosConfiguration;
import com.sun.identity.wss.security.PasswordCredential;
import com.sun.identity.wss.security.SAML2Token;
import com.sun.identity.wss.security.SAML2TokenUtils;
import com.sun.identity.wss.security.SecurityException;
import com.sun.identity.wss.security.SecurityMechanism;
import com.sun.identity.wss.security.SecurityPrincipal;
import com.sun.identity.wss.security.SecurityToken;
import com.sun.identity.wss.security.UserNameToken;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.wss.security.handler.MessageAuthenticator;
import com.sun.identity.wss.security.handler.SecureSOAPMessage;
import com.sun.identity.wss.security.handler.WSSCache;
import com.sun.identity.wss.security.handler.WSSCacheRepository;
import com.sun.identity.wss.sts.FAMSTSException;
import com.sun.identity.wss.sts.TrustAuthorityClient;
import com.sun.xml.ws.security.jgss.XWSSProvider;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.w3c.dom.Element;
import sun.security.krb5.EncryptionKey;

public class DefaultAuthenticator
implements MessageAuthenticator {
    private ProviderConfig config = null;
    private static ResourceBundle bundle = WSSUtils.bundle;
    private static Debug debug = WSSUtils.debug;
    public static final String WSS_CACHE_PLUGIN = "com.sun.identity.wss.security.cache.plugin";
    private String kerberosPrincipal = null;
    private static Class cacheClass;

    public Object authenticate(javax.security.auth.Subject subject, SecurityMechanism securityMechanism, SecurityToken securityToken, ProviderConfig config, Object secureMessage, boolean isLiberty) throws SecurityException {
        debug.message("DefaultAuthenticator.authenticate: start");
        this.config = config;
        HashMap<String, String> secureAttrs = new HashMap<String, String>();
        String authChain = null;
        if (config != null) {
            authChain = config.getAuthenticationChain();
        }
        if (isLiberty) {
            return this.authenticateLibertyMessage(secureMessage, subject, secureAttrs);
        }
        if (securityMechanism == null) {
            throw new SecurityException(bundle.getString("nullInputParameter"));
        }
        String uri = securityMechanism.getURI();
        if ("urn:sun:wss:security:null:UserNameToken".equals(uri) || "urn:sun:wss:security:TLS:UserNameToken".equals(uri) || "urn:sun:wss:security:ClientTLS:UserNameToken".equals(uri) || "urn:sun:wss:security:null:UserNameToken-Plain".equals(uri) || "urn:sun:wss:security:TLS:UserNameToken-Plain".equals(uri) || "urn:sun:wss:security:ClientTLS:UserNameToken-Plain".equals(uri)) {
            if (debug.messageEnabled()) {
                debug.message("DefaultAuthenticator.authenticate:: username token authentication");
                debug.message("authenticate: authChain : " + authChain);
            }
            UserNameToken usertoken = (UserNameToken)securityToken;
            if (authChain == null || authChain.length() == 0 || authChain.equals("none")) {
                if (config != null && !this.validateUser(usertoken, subject)) {
                    if (debug.warningEnabled()) {
                        debug.warning("DefaultAuthenticator. authentication failed.");
                    }
                    throw new SecurityException(bundle.getString("authenticationFailed"));
                }
            } else if (!this.authenticateUser(usertoken, subject, authChain)) {
                throw new SecurityException(bundle.getString("authenticationFailed"));
            }
        } else if ("urn:sun:wss:security:null:X509Token".equals(uri) || "urn:sun:wss:security:TLS:X509Token".equals(uri) || "urn:sun:wss:security:ClientTLS:X509Token".equals(uri)) {
            SecureSOAPMessage securedMessage;
            X509Certificate cert;
            if (debug.messageEnabled()) {
                debug.message("DefaultAuthenticator.authenticate:: x509 token authentication");
                debug.message("authenticate: authChain : " + authChain);
            }
            if ((cert = (securedMessage = (SecureSOAPMessage)secureMessage).getMessageCertificate()) == null) {
                debug.error("DefaultAuthenticator.authenticate:: X509 auth could not find the message certificate.");
                throw new SecurityException(bundle.getString("authenticationFailed"));
            }
            XMLSignatureManager sigManager = WSSUtils.getXMLSignatureManager();
            String certAlias = sigManager.getKeyProvider().getCertificateAlias((Certificate)cert);
            if (debug.messageEnabled()) {
                debug.message("DefaultAuthenticator.authenticate: cert : " + cert);
                debug.message("DefaultAuthenticator.authenticate: certAlias : " + certAlias);
            }
            if (authChain != null && authChain.length() != 0 && !authChain.equals("none") && !this.authenticateCert(certAlias, authChain, cert, subject)) {
                throw new SecurityException(bundle.getString("authenticationFailed"));
            }
            String subjectDN = CertUtils.getSubjectName((X509Certificate)cert);
            subject = this.addPrincipal(subjectDN, subject);
            subject.getPublicCredentials().add(cert);
            WSSUtils.setRoles(subject, subjectDN);
        } else if ("urn:sun:wss:security:null:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:TLS:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:ClientTLS:SAMLToken-HK".equals(uri) || "urn:sun:wss:security:null:SAMLToken-SV".equals(uri) || "urn:sun:wss:security:TLS:SAMLToken-SV".equals(uri) || "urn:sun:wss:security:ClientTLS:SAMLToken-SV".equals(uri)) {
            if (debug.messageEnabled()) {
                debug.message("DefaultAuthenticator.authenticate:: saml token authentication");
            }
            AssertionToken assertionToken = (AssertionToken)securityToken;
            if (authChain != null && authChain.length() != 0 && !authChain.equals("none") ? !this.authenticateAssertion(assertionToken.toDocumentElement(), config, subject) : !this.validateAssertion(assertionToken.getAssertion(), subject, secureAttrs)) {
                throw new SecurityException(bundle.getString("authenticationFailed"));
            }
        } else if ("urn:sun:wss:security:null:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:TLS:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:ClientTLS:SAML2Token-HK".equals(uri) || "urn:sun:wss:security:null:SAML2Token-SV".equals(uri) || "urn:sun:wss:security:TLS:SAML2Token-SV".equals(uri) || "urn:sun:wss:security:ClientTLS:SAML2Token-SV".equals(uri)) {
            if (debug.messageEnabled()) {
                debug.message("DefaultAuthenticator.authenticate:: saml2 token authentication");
            }
            SAML2Token saml2Token = (SAML2Token)securityToken;
            if (authChain != null && authChain.length() != 0 && !authChain.equals("none") ? !this.authenticateAssertion(saml2Token.toDocumentElement(), config, subject) : !SAML2TokenUtils.validateAssertion(saml2Token.getAssertion(), subject, secureAttrs)) {
                throw new SecurityException(bundle.getString("authenticationFailed"));
            }
        } else if ("urn:sun:wss:security:null:KerberosToken".equals(uri) || "urn:sun:wss:security:TLS:KerberosToken".equals(uri) || "urn:sun:wss:security:ClientTLS:KerberosToken".equals(uri)) {
            if (debug.messageEnabled()) {
                debug.message("DefaultAuthenticator.authenticate:: kerberos token authentication");
            }
            BinarySecurityToken bst = (BinarySecurityToken)securityToken;
            this.validateKerberosToken(Base64.decode((String)bst.getTokenValue()), subject);
        } else {
            debug.error("DefaultAuthenticator.authenticate:: Invalid security mechanism");
            String[] data = new String[]{uri};
            LogUtil.error(Level.INFO, "AUTHENTICATION_FAILED", data, null);
            throw new SecurityException(bundle.getString("authenticationFailed"));
        }
        if (securityToken != null) {
            subject.getPublicCredentials().add(securityToken.toDocumentElement());
        }
        if (securityMechanism != null) {
            secureAttrs.put("AuthMethod", uri);
            subject.getPublicCredentials().add(secureAttrs);
        }
        return subject;
    }

    private boolean validateUser(UserNameToken usernameToken, javax.security.auth.Subject subject) throws SecurityException {
        String user = usernameToken.getUserName();
        String password = usernameToken.getPassword();
        if (user == null || password == null) {
            return false;
        }
        List users = this.config.getUsers();
        if (users == null || users.isEmpty()) {
            debug.error("DefaultAuthenticator.validateUser:: users are not  configured in the providers.");
            return false;
        }
        Iterator iter = users.iterator();
        String configuredUser = null;
        String configuredPassword = null;
        while (iter.hasNext()) {
            PasswordCredential cred = (PasswordCredential)iter.next();
            configuredUser = cred.getUserName();
            if (!configuredUser.equals(user)) continue;
            configuredPassword = cred.getPassword();
            break;
        }
        if (configuredUser == null || configuredPassword == null) {
            debug.error("DefaultAuthenticator.validateUser:: configured user  does not have the password.");
            return false;
        }
        String passwordType = usernameToken.getPasswordType();
        if (passwordType != null && passwordType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest")) {
            String nonce = usernameToken.getNonce();
            String created = usernameToken.getCreated();
            if (!this.validateUserTokenTime(created)) {
                return false;
            }
            String digest = UserNameToken.getPasswordDigest(configuredPassword, nonce, created);
            if (!digest.equals(password) || !configuredUser.equals(user)) {
                debug.error("DefaultAuthenticator.validateUser:: Password does not match");
                return false;
            }
            if (this.config.isUserTokenDetectReplayEnabled()) {
                this.cacheNonce(created, nonce);
            }
        } else if (!configuredPassword.equals(password) || !configuredUser.equals(user)) {
            debug.error("DefaultAuthenticator.validateUser:: Password does not match");
            return false;
        }
        subject = this.addPrincipal(user, subject);
        WSSUtils.setRoles(subject, user);
        return true;
    }

    private boolean authenticateUser(UserNameToken usernameToken, javax.security.auth.Subject subject, String authChain) throws SecurityException {
        String user = usernameToken.getUserName();
        String password = usernameToken.getPassword();
        if (user == null || password == null) {
            return false;
        }
        String nonce = usernameToken.getNonce();
        String created = usernameToken.getCreated();
        if (!this.validateUserTokenTime(created)) {
            return false;
        }
        String passwordType = usernameToken.getPasswordType().trim();
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(passwordType)) {
            password = "PasswordDigest=" + password + ";" + "Nonce=" + nonce + ";" + "Timestamp=" + created;
        }
        AuthContext ac = null;
        AuthContext.IndexType indexType = AuthContext.IndexType.SERVICE;
        String indexName = authChain;
        try {
            ac = new AuthContext("/");
            debug.message("authenticateUser: Obtained AuthContext");
            ac.login(indexType, indexName);
        }
        catch (AuthLoginException le) {
            debug.error("authenticateUser: Login error : " + le.getMessage());
            return false;
        }
        Callback[] callbacks = null;
        while (ac.hasMoreRequirements()) {
            callbacks = ac.getRequirements();
            if (callbacks == null) continue;
            try {
                DefaultAuthenticator.addLoginCallbackMessage(callbacks, user, password, null);
                ac.submitRequirements(callbacks);
            }
            catch (Exception e) {
                debug.error("authenticateUser: Submit error : " + e.getMessage());
                return false;
            }
        }
        SSOToken ssotoken = null;
        if (ac.getStatus() == AuthContext.Status.SUCCESS) {
            debug.message("authenticateUser: Login success!!");
            try {
                ssotoken = ac.getSSOToken();
                debug.message("authenticateUser: got SSOToken successfully");
            }
            catch (Exception ex) {
                if (debug.messageEnabled()) {
                    debug.message("authenticateUser: SSOToken error : " + ex.getMessage());
                }
            }
        } else {
            if (ac.getStatus() == AuthContext.Status.FAILED) {
                debug.error("authenticateUser: Login Failed.");
                return false;
            }
            debug.error("authenticateUser: Unknown status : " + ac.getStatus());
            return false;
        }
        if (this.config.isUserTokenDetectReplayEnabled()) {
            this.cacheNonce(created, nonce);
        }
        subject = this.addPrincipal(user, subject);
        WSSUtils.setRoles(subject, user);
        this.addSSOToken(ssotoken, subject);
        return true;
    }

    private boolean authenticateCert(String certAlias, String authChain, X509Certificate cert, javax.security.auth.Subject subject) throws SecurityException {
        if (certAlias == null || certAlias.length() == 0) {
            return false;
        }
        if (debug.messageEnabled()) {
            debug.message("authenticateCert: certAlias : " + certAlias);
        }
        AuthContext ac = null;
        AuthContext.IndexType indexType = AuthContext.IndexType.SERVICE;
        String indexName = authChain;
        try {
            ac = new AuthContext("/", certAlias);
            debug.message("authenticateCert: Obtained AuthContext");
            ac.login(indexType, indexName);
        }
        catch (AuthLoginException le) {
            debug.error("authenticateCert: Login error : " + le.getMessage());
            return false;
        }
        Callback[] callbacks = null;
        while (ac.hasMoreRequirements()) {
            callbacks = ac.getRequirements();
            if (callbacks == null) continue;
            try {
                DefaultAuthenticator.addLoginCallbackMessage(callbacks, null, null, cert);
                ac.submitRequirements(callbacks);
            }
            catch (Exception e) {
                debug.error("authenticateCert: Submit error : " + e.getMessage());
                return false;
            }
        }
        SSOToken ssotoken = null;
        if (ac.getStatus() == AuthContext.Status.SUCCESS) {
            debug.message("authenticateCert: Login success!!");
            try {
                ssotoken = ac.getSSOToken();
                debug.message("authenticateCert: got SSOToken successfully");
            }
            catch (Exception ex) {
                if (debug.messageEnabled()) {
                    debug.message("authenticateCert: SSOToken error : " + ex.getMessage());
                }
            }
        } else {
            if (ac.getStatus() == AuthContext.Status.FAILED) {
                debug.error("authenticateCert: Login Failed.");
                return false;
            }
            debug.error("authenticateCert: Unknown status : " + ac.getStatus());
            return false;
        }
        this.addSSOToken(ssotoken, subject);
        return true;
    }

    private boolean validateAssertion(Assertion assertion, javax.security.auth.Subject subject, Map secureAttrs) throws SecurityException {
        if (assertion.getConditions() != null && !assertion.getConditions().checkDateValidity(System.currentTimeMillis() + WSSUtils.getTimeSkew())) {
            if (debug.messageEnabled()) {
                debug.message("DefaultAuthenticator.validateAssertionToken::  assertion time is not valid");
            }
            return false;
        }
        Subject sub = null;
        for (Statement st : assertion.getStatement()) {
            List attributes;
            if (1 == st.getStatementType()) {
                AuthenticationStatement authStatement = (AuthenticationStatement)st;
                sub = authStatement.getSubject();
                Element keyInfo = sub.getSubjectConfirmation().getKeyInfo();
                if (keyInfo == null) break;
                X509Certificate cert = WSSUtils.getCertificate(keyInfo);
                subject.getPublicCredentials().add(cert);
                break;
            }
            if (3 != st.getStatementType()) continue;
            AttributeStatement attribStatement = (AttributeStatement)st;
            sub = attribStatement.getSubject();
            Object subConfirmation = null;
            Element keyInfo = null;
            if (subConfirmation != null) {
                keyInfo = subConfirmation.getKeyInfo();
            }
            if (keyInfo != null) {
                X509Certificate cert = WSSUtils.getCertificate(keyInfo);
                subject.getPublicCredentials().add(cert);
            }
            if ((attributes = attribStatement.getAttribute()).isEmpty()) break;
            for (Attribute attr : attributes) {
                try {
                    secureAttrs.put(attr.getAttributeName(), attr.getAttributeValue());
                }
                catch (Exception se) {
                    throw new SecurityException(se.getMessage());
                }
            }
        }
        if (sub == null) {
            if (debug.messageEnabled()) {
                debug.message("DefaultAuthenticator.validateAssertionToken:: Assertion does not have subject");
            }
            return false;
        }
        NameIdentifier ni = sub.getNameIdentifier();
        if (ni == null) {
            return false;
        }
        subject = this.addPrincipal(ni.getName(), subject);
        WSSUtils.setRoles(subject, ni.getName());
        return true;
    }

    private Object authenticateLibertyMessage(Object message, javax.security.auth.Subject subject, Map secureAttrs) throws SecurityException {
        if (message == null || subject == null) {
            throw new IllegalArgumentException(bundle.getString("nullInput"));
        }
        Message requestMsg = (Message)message;
        SecurityAssertion assertion = requestMsg.getAssertion();
        if (assertion != null) {
            if (!this.validateAssertion((Assertion)assertion, subject, secureAttrs)) {
                throw new SecurityException(bundle.getString("authenticationFailed"));
            }
            return subject;
        }
        X509Certificate messageCert = requestMsg.getMessageCertificate();
        if (messageCert == null) {
            throw new SecurityException(bundle.getString("authenticationFailed"));
        }
        String subjectDN = messageCert.getSubjectDN().getName();
        SecurityPrincipal principal = new SecurityPrincipal(subjectDN);
        subject.getPrincipals().add(principal);
        return subject;
    }

    private void addSSOToken(final SSOToken ssoToken, final javax.security.auth.Subject subj) throws SecurityException {
        if (ssoToken != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        subj.getPrivateCredentials().add(ssoToken);
                        return null;
                    }
                });
                debug.message("Set SSOToken in Subject successfully");
            }
            catch (Exception e) {
                debug.message("Can not set SSOToken in Subject");
                throw new SecurityException(e.getMessage());
            }
        }
    }

    private javax.security.auth.Subject addPrincipal(String principalName, javax.security.auth.Subject subject) {
        SecurityPrincipal principal = new SecurityPrincipal(principalName);
        subject.getPrincipals().add(principal);
        return subject;
    }

    static void addLoginCallbackMessage(Callback[] callbacks, String userName, String password, X509Certificate cert) throws UnsupportedCallbackException {
        int i = 0;
        try {
            for (i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    nc.setName(userName.trim());
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callbacks[i];
                    pc.setPassword(password.toCharArray());
                    continue;
                }
                if (!(callbacks[i] instanceof X509CertificateCallback)) continue;
                X509CertificateCallback certCB = (X509CertificateCallback)callbacks[i];
                try {
                    certCB.setReqSignature(false);
                    certCB.setCertificate(cert);
                    continue;
                }
                catch (Exception e) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("createX509CertificateCallback : " + e.toString());
                }
            }
        }
        catch (Exception e) {
            throw new UnsupportedCallbackException(callbacks[i], "Callback exception: " + e);
        }
    }

    private boolean validateKerberosToken(final byte[] token, javax.security.auth.Subject subject) throws SecurityException {
        javax.security.auth.Subject serverSubject = this.getServerSubject();
        try {
            javax.security.auth.Subject.doAs(serverSubject, new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    final GSSManager manager = GSSManager.getInstance();
                    final Oid krb5Oid = new Oid("1.2.840.113554.1.2.2");
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                manager.addProviderAtFront((Provider)new XWSSProvider(), krb5Oid);
                            }
                            catch (GSSException gsse) {
                                WSSUtils.debug.error("BinarySecurityToken.validateKerberosToken", (Throwable)gsse);
                            }
                            return null;
                        }
                    });
                    GSSContext context = manager.createContext((GSSCredential)null);
                    byte[] outToken = context.acceptSecContext(token, 0, token.length);
                    DefaultAuthenticator.this.kerberosPrincipal = ((Object)context.getSrcName()).toString();
                    return null;
                }
            });
        }
        catch (Exception ge) {
            debug.error("BinarySecurityToken.getKerberosToken: GSS Error", (Throwable)ge);
            throw new SecurityException(ge.getMessage());
        }
        Set<Object> creds = serverSubject.getPrivateCredentials();
        for (Object privObject : creds) {
            if (!(privObject instanceof EncryptionKey)) continue;
            EncryptionKey encKey = (EncryptionKey)privObject;
            byte[] keyBytes = encKey.getBytes();
            SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "DES");
            subject.getPublicCredentials().add(secretKey);
            break;
        }
        this.addPrincipal(this.kerberosPrincipal, subject);
        return true;
    }

    private javax.security.auth.Subject getServerSubject() throws SecurityException {
        String kdcRealm = this.config.getKDCDomain();
        String kdcServer = this.config.getKDCServer();
        System.setProperty("java.security.krb5.realm", kdcRealm);
        System.setProperty("java.security.krb5.kdc", kdcServer);
        System.setProperty("java.security.auth.login.config", "/dev/null");
        Configuration kbConfig = Configuration.getConfiguration();
        KerberosConfiguration kc = null;
        if (kbConfig instanceof KerberosConfiguration) {
            kc = (KerberosConfiguration)kbConfig;
            kc.setRefreshConfig("true");
            kc.setPrincipalName(this.config.getKerberosServicePrincipal());
            kc.setKeyTab(this.config.getKeyTabFile());
        } else {
            kc = new KerberosConfiguration(kbConfig);
            kc.setPrincipalName(this.config.getKerberosServicePrincipal());
            kc.setKeyTab(this.config.getKeyTabFile());
        }
        Configuration.setConfiguration(kc);
        try {
            LoginContext lc = new LoginContext("com.sun.identity.wss.webservicesprovider");
            lc.login();
            return lc.getSubject();
        }
        catch (LoginException ex) {
            throw new SecurityException(ex.getMessage());
        }
    }

    private boolean authenticateAssertion(Element assertionE, ProviderConfig config, javax.security.auth.Subject subject) throws SecurityException {
        try {
            SecurityToken token;
            String tokenConversionType;
            String protocol = SystemConfigurationUtil.getProperty((String)"com.iplanet.am.server.protocol");
            String host = SystemConfigurationUtil.getProperty((String)"com.iplanet.am.server.host");
            String port = SystemConfigurationUtil.getProperty((String)"com.iplanet.am.server.port");
            String deployURI = SystemConfigurationUtil.getProperty((String)"com.iplanet.am.services.deploymentDescriptor");
            URL stsURL = WebtopNaming.getServiceURL((String)"sts", (String)protocol, (String)host, (String)port, (String)deployURI);
            URL stsMexURL = WebtopNaming.getServiceURL((String)"sts-mex", (String)protocol, (String)host, (String)port, (String)deployURI);
            TrustAuthorityClient taClient = new TrustAuthorityClient();
            String tokenType = tokenConversionType = config.getTokenConversionType();
            if (tokenConversionType != null) {
                if (tokenConversionType.equals("urn:sun:wss:samltoken")) {
                    tokenType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
                } else if (tokenConversionType.equals("urn:sun:wss:saml2token")) {
                    tokenType = "urn:oasis:names:tc:SAML:2.0:assertion";
                }
            }
            if ((token = taClient.getSecurityToken(config.getWSPEndpoint(), stsURL.toString(), stsMexURL.toString(), assertionE, "urn:sun:wss:sts:security", tokenType, null)).getTokenType().equals("urn:sun:wss:ssotoken")) {
                FAMSecurityToken famToken = (FAMSecurityToken)token;
                SSOToken ssoToken = SSOTokenManager.getInstance().createSSOToken(famToken.getTokenID());
                this.addSSOToken(ssoToken, subject);
                subject = this.addPrincipal(ssoToken.getPrincipal().getName(), subject);
            } else {
                subject.getPublicCredentials().add(token.toDocumentElement());
            }
            return true;
        }
        catch (FAMSTSException fae) {
            throw new SecurityException(fae.getMessage());
        }
        catch (SSOException se) {
            throw new SecurityException(se.getMessage());
        }
        catch (URLNotFoundException ure) {
            throw new SecurityException(ure.getMessage());
        }
    }

    private boolean validateUserTokenTime(String created) {
        long tokentime = 0L;
        try {
            tokentime = DateUtils.stringToDate((String)created).getTime();
        }
        catch (ParseException pe) {
            WSSUtils.debug.error("DefaultAuthenticator.validateUserTokenTime: parse error", (Throwable)pe);
            return false;
        }
        long now = new Date().getTime() + WSSUtils.getTimeSkew();
        return now - tokentime >= 0L;
    }

    private void cacheNonce(String timeStamp, String nonce) throws SecurityException {
        Set<String> nonces = (HashSet)WSSCache.nonceCache.get((Object)timeStamp);
        WSSCacheRepository cacheRepo = WSSUtils.getWSSCacheRepository();
        if ((nonces == null || nonces.isEmpty()) && cacheRepo != null) {
            nonces = cacheRepo.retrieveUserTokenNonce(timeStamp, this.config.getProviderName());
        }
        if (nonces == null || nonces.isEmpty()) {
            nonces = new HashSet();
            nonces.add(nonce);
            WSSCache.nonceCache.put((Object)timeStamp, nonces);
            if (cacheRepo != null) {
                cacheRepo.saveUserTokenNonce(timeStamp, nonces, this.config.getProviderName());
            }
        } else {
            if (nonces.contains(nonce)) {
                throw new SecurityException(WSSUtils.bundle.getString("replayAttackDetected"));
            }
            nonces.add(nonce);
            WSSCache.nonceCache.put((Object)timeStamp, nonces);
            if (cacheRepo != null) {
                cacheRepo.saveUserTokenNonce(timeStamp, nonces, this.config.getProviderName());
            }
        }
    }
}

