/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk.ldap;

import com.iplanet.am.sdk.AMConstants;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMSDKBundle;
import com.iplanet.am.sdk.AMServiceUtils;
import com.iplanet.am.sdk.AMUserPasswordValidation;
import com.iplanet.am.sdk.ldap.CommonUtils;
import com.iplanet.am.sdk.ldap.NamingAttributeManager;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class UserPasswordValidationHelper
implements AMConstants {
    private static Map pluginsCache = Collections.EMPTY_MAP;
    private Debug debug = CommonUtils.debug;
    private AMUserPasswordValidation plugin = null;
    private String orgdn;

    public UserPasswordValidationHelper(SSOToken token, String orgDN) throws AMException {
        this.orgdn = orgDN;
        String pluginClass = this.getOrgUserPasswordValidationClass(orgDN);
        if (pluginClass != null && pluginClass.length() != 0) {
            if (pluginsCache == Collections.EMPTY_MAP) {
                pluginsCache = new Hashtable();
            } else {
                this.plugin = (AMUserPasswordValidation)pluginsCache.get(pluginClass);
            }
            if (this.plugin == null) {
                this.plugin = this.instantiateClass(token, pluginClass);
                pluginsCache.put(pluginClass, this.plugin);
            }
        }
    }

    public void validate(Map attributes) throws AMException {
        if (this.plugin != null) {
            Set passwordValue;
            String userNamingAttr = NamingAttributeManager.getNamingAttribute(1);
            Set uidValue = (Set)attributes.get(userNamingAttr);
            if (uidValue != null && !uidValue.isEmpty()) {
                String userID = (String)uidValue.iterator().next();
                try {
                    HashMap<String, String> envMap = new HashMap<String, String>(2);
                    envMap.put("organization_name", this.orgdn);
                    this.plugin.validateUserID(userID, envMap);
                }
                catch (AMException ame) {
                    this.debug.error("AMUserPasswordValidationImpl:validate() User Name validation Failed" + ame);
                    throw ame;
                }
            }
            if ((passwordValue = (Set)attributes.get("userpassword")) != null && !passwordValue.isEmpty()) {
                String password = (String)passwordValue.iterator().next();
                HashMap<String, String> passMap = new HashMap<String, String>(2);
                passMap.put("organization_name", this.orgdn);
                this.plugin.validatePassword(password, passMap);
            }
        }
    }

    private String getOrgUserPasswordValidationClass(String orgDN) {
        try {
            SSOToken internalToken = CommonUtils.getInternalToken();
            ServiceConfig sc = AMServiceUtils.getOrgConfig(internalToken, orgDN, "iPlanetAMAdminConsoleService");
            if (sc != null) {
                Map attributes = sc.getAttributes();
                Set value = (Set)attributes.get("iplanet-am-admin-console-user-password-validation-class");
                return value == null || value.isEmpty() ? null : (String)value.iterator().next();
            }
            return this.getGlobalUserValiadationClass();
        }
        catch (Exception ee) {
            return this.getGlobalUserValiadationClass();
        }
    }

    private String getGlobalUserValiadationClass() {
        block4: {
            if (this.debug.messageEnabled()) {
                this.debug.message("AMUserPasswordValidationImplImpl.getGlobalUserValiadationClass() Organization config for service (iPlanetAMAdminConsoleService,iplanet-am-admin-console-user-password-validation-class) not found. Obtaining default service config values ..");
            }
            try {
                Map defaultValues = AMServiceUtils.getServiceConfig(CommonUtils.getInternalToken(), "iPlanetAMAdminConsoleService", SchemaType.ORGANIZATION);
                if (defaultValues != null) {
                    Set value = (Set)defaultValues.get("iplanet-am-admin-console-user-password-validation-class");
                    return value == null || value.isEmpty() ? null : (String)value.iterator().next();
                }
            }
            catch (Exception e) {
                if (!this.debug.warningEnabled()) break block4;
                this.debug.warning("AMUserPasswordValidationImplImpl.getGlobalUserValiadationClass(): Unable to get UserID & Password validation plugin information", (Throwable)e);
            }
        }
        return null;
    }

    private AMUserPasswordValidation instantiateClass(SSOToken token, String className) throws AMException {
        try {
            return (AMUserPasswordValidation)Class.forName(className).newInstance();
        }
        catch (InstantiationException e1) {
            this.debug.error("AMUserPasswordValidationImpl.instantiateClass(): Unable to instantiate class: " + className, (Throwable)e1);
            Object[] args = new Object[]{className};
            throw new AMException(AMSDKBundle.getString("164", args), "164", args);
        }
        catch (IllegalAccessException e1) {
            this.debug.error("AMUserPasswordValidationImpl.instantiateClass(): The class is " + className + " unaccessable: ", (Throwable)e1);
            Object[] args = new Object[]{className};
            throw new AMException(AMSDKBundle.getString("164", args), "164", args);
        }
        catch (ClassNotFoundException e1) {
            this.debug.error("AMUserPasswordValidationImpl.instantiateClass(): Unable to locate class " + className, (Throwable)e1);
            Object[] args = new Object[]{className};
            throw new AMException(AMSDKBundle.getString("164", args), "164", args);
        }
    }
}

