/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.service;

import java.security.SecureRandom;
import java.util.Random;

public class PermutationGenerator {
    private short[] state;
    private Random random;
    private int iter = 0;

    public PermutationGenerator(String seed, int size) {
        byte[] bytes = seed.getBytes();
        long longSeed = 0L;
        for (int i = 0; i < bytes.length; i += 8) {
            longSeed += PermutationGenerator.bytesToLong(bytes, i);
        }
        this.init(longSeed, size);
    }

    public PermutationGenerator(long seed, int size) {
        this.init(seed, size);
    }

    private void init(long seed, int size) {
        this.random = new Random();
        this.random.setSeed(seed);
        this.state = new short[size];
        for (int i = 0; i < this.state.length; ++i) {
            this.state[i] = (short)i;
        }
    }

    public short itemAt(int pos) {
        if (pos < 0 || pos > this.state.length) {
            throw new IndexOutOfBoundsException();
        }
        while (this.iter <= pos) {
            int r = this.random.nextInt(this.state.length - this.iter) + this.iter;
            short tmp = this.state[r];
            this.state[r] = this.state[this.iter];
            this.state[this.iter] = tmp;
            ++this.iter;
        }
        return this.state[pos];
    }

    private static long bytesToLong(byte[] bytes, int offset) {
        int bound = offset + Math.min(bytes.length - offset, 8);
        long result = 0L;
        for (int i = offset; i < bound; ++i) {
            result = result << 8 | (long)bytes[i];
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        byte[] test = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        System.err.println("Long=" + Long.toHexString(PermutationGenerator.bytesToLong(test, 0)));
        int size = 2;
        int[][] hist = new int[size][];
        for (int i = 0; i < hist.length; ++i) {
            hist[i] = new int[size];
        }
        for (int s = 0; s < 10000; ++s) {
            String seed = String.valueOf(new SecureRandom().nextLong());
            System.err.print(seed + ": ");
            PermutationGenerator perm = new PermutationGenerator(seed, size);
            int total = 0;
            for (int i = 0; i < size; ++i) {
                short item = perm.itemAt(i);
                System.err.print(item + " ");
                int[] nArray = hist[i];
                short s2 = item;
                nArray[s2] = nArray[s2] + 1;
                total += item;
            }
            if (total != (size - 1) * size / 2) {
                throw new Exception("permutation error");
            }
            System.err.println("");
        }
        for (int k = 0; k < hist.length; ++k) {
            for (int l = 0; l < hist[k].length; ++l) {
                System.err.print(hist[k][l] + " ");
            }
            System.err.println("");
        }
    }
}

