/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.aci;

import com.iplanet.services.ldap.aci.ACIParseException;

class ACITargetExpression {
    private String _keyword;
    private String _operator;
    private String _value;

    ACITargetExpression(String keyword, String operator, String value) {
        this._keyword = keyword.toLowerCase();
        this._operator = operator;
        this._value = value;
    }

    String getKeyword() {
        return this._keyword;
    }

    String getOperator() {
        return this._operator;
    }

    String getValue() {
        return this._value;
    }

    static ACITargetExpression valueOf(String text) throws ACIParseException {
        String keyword = null;
        String operator = null;
        String value = null;
        int opIndex = text.indexOf("=");
        if (opIndex <= 0) {
            throw new ACIParseException("Malformed aci");
        }
        if (text.charAt(opIndex - 1) == '!') {
            --opIndex;
            operator = "!=";
        } else {
            operator = "=";
        }
        keyword = text.substring(1, opIndex).trim();
        value = text.substring(opIndex + operator.length(), text.length() - 1).trim();
        value = ACITargetExpression.trimSurroundingQuotes(value);
        return new ACITargetExpression(keyword, operator, value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._keyword + ":" + this._operator + ":" + this._value);
        return sb.toString();
    }

    static String trimSurroundingQuotes(String str) {
        if (str != null && str.length() > 1 && str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"') {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }
}

