/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.util;

import com.sun.identity.shared.debug.Debug;

public final class ThreadPool {
    private static int nextThreadID = 1;
    private Debug debug;
    private String poolName;
    private IPSThread[] allThreadList;
    private IPSThread[] idleThreadList;
    private volatile int tail = -1;

    public ThreadPool(String poolName, int numThreads, boolean daemon, Debug debug) throws IllegalArgumentException {
        if (poolName == null) {
            throw new IllegalArgumentException("Must assign a non-null pool name to ThreadPool");
        }
        this.poolName = poolName;
        this.debug = debug;
        numThreads = Math.max(1, numThreads);
        this.idleThreadList = new IPSThread[numThreads];
        this.allThreadList = new IPSThread[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            this.allThreadList[i] = new IPSThread(this.getNextIPSThreadID(), daemon);
        }
    }

    private ThreadPool() {
    }

    private synchronized String getNextIPSThreadID() {
        return this.poolName + ".Thread#" + Integer.toString(nextThreadID++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(Runnable task) throws InterruptedException {
        IPSThread[] iPSThreadArray = this.idleThreadList;
        synchronized (this.idleThreadList) {
            while (this.tail == -1) {
                if (this.debug != null && this.debug.warningEnabled()) {
                    this.debug.warning(Thread.currentThread().getName() + " waiting for an idle thread in " + this.toString());
                }
                this.idleThreadList.wait();
            }
            IPSThread ipsThread = this.idleThreadList[this.tail--];
            // ** MonitorExit[var3_2] (shouldn't be in output)
            ipsThread.process(task);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopIdleThreads() {
        IPSThread[] iPSThreadArray = this.idleThreadList;
        synchronized (this.idleThreadList) {
            while (this.tail >= 0) {
                IPSThread idleThread = this.idleThreadList[this.tail];
                this.idleThreadList[this.tail--] = null;
                idleThread.stop();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        this.stopIdleThreads();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        IPSThread[] iPSThreadArray = this.allThreadList;
        synchronized (this.allThreadList) {
            int numThreads = this.allThreadList.length;
            int i = 0;
            while (i < numThreads) {
                IPSThread ipsThread = this.allThreadList[i];
                this.allThreadList[i++] = null;
                if (!ipsThread.isAlive()) continue;
                ipsThread.stop();
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        IPSThread[] iPSThreadArray = this.idleThreadList;
        synchronized (this.idleThreadList) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.poolName + "[" + this.allThreadList.length + " Total threads, " + (this.tail >= 0 ? this.tail + 1 : 0) + " Idle threads]";
        }
    }

    public final String getName() {
        return this.poolName;
    }

    private final void logMessage(String msg) {
        if (this.debug == null) {
            return;
        }
        this.debug.message(msg);
    }

    private final class IPSThread {
        private volatile Runnable task;
        private Thread thread;
        private volatile boolean stopped = false;

        IPSThread(String name, boolean daemon) {
            Runnable r = new Runnable(){

                public void run() {
                    block2: {
                        try {
                            IPSThread.this.runTask();
                        }
                        catch (Throwable t) {
                            if (ThreadPool.this.debug == null) break block2;
                            ThreadPool.this.debug.error(IPSThread.this.thread.getName() + " caught exception that fell through", t);
                        }
                    }
                }
            };
            this.thread = new Thread(r, name);
            this.thread.setDaemon(daemon);
            this.thread.start();
        }

        private IPSThread() {
        }

        final synchronized void process(Runnable task) throws InterruptedException {
            this.task = task;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTask() {
            while (!this.stopped) {
                try {
                    Object object = ThreadPool.this.idleThreadList;
                    synchronized (object) {
                        ((ThreadPool)ThreadPool.this).idleThreadList[++((ThreadPool)ThreadPool.this).tail] = this;
                        if (ThreadPool.this.tail == 0) {
                            ThreadPool.this.idleThreadList.notifyAll();
                        }
                    }
                    object = this;
                    synchronized (object) {
                        while (this.task == null) {
                            this.wait();
                        }
                    }
                    try {
                        this.task.run();
                    }
                    catch (Exception e) {
                        if (ThreadPool.this.debug == null) continue;
                        ThreadPool.this.debug.error(this.thread.getName() + " caught exception that fell through from " + this.task + ".run()", (Throwable)e);
                    }
                    finally {
                        Thread.interrupted();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable t) {
                    if (ThreadPool.this.debug == null) continue;
                    ThreadPool.this.debug.error(this.thread.getName() + ": runTask() caught throwable. Investigate " + "the problem", t);
                }
                finally {
                    this.task = null;
                }
            }
            if (ThreadPool.this.debug != null) {
                ThreadPool.this.debug.error(this.thread.getName() + " stopped.", (Throwable)null);
            }
        }

        private final void stop() {
            ThreadPool.this.logMessage(this.thread.getName() + " received stop() request.");
            this.stopped = true;
            this.thread.interrupt();
        }

        final String getName() {
            return this.thread.getName();
        }

        final boolean isAlive() {
            return this.thread.isAlive();
        }
    }
}

