/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.ModSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.Guid;
import com.iplanet.ums.IAssignableMembership;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.sun.identity.shared.ldap.LDAPAttribute;
import com.sun.identity.shared.ldap.LDAPDN;
import java.security.Principal;
import java.util.Enumeration;

public class StaticGroup
extends PersistentObject
implements IAssignableMembership {
    public static final int LEVEL_DIRECT = 0;
    public static final int LEVEL_ALL = -1;
    static final int DEFAULT_MAX = 5;
    private static I18n i18n = I18n.getInstance("amSDK");
    private static final String MEMBER_ATTR_NAME = "uniquemember";
    private static final Class _class = new StaticGroup().getClass();

    protected StaticGroup() {
    }

    StaticGroup(Principal principal, Guid guid) throws UMSException {
        super(principal, guid);
        this.verifyClass();
    }

    StaticGroup(AttrSet attrSet) throws UMSException {
        this(TemplateManager.getTemplateManager().getCreationTemplate(_class, null), attrSet);
    }

    public StaticGroup(CreationTemplate template, AttrSet attrSet) throws UMSException {
        super(template, attrSet);
    }

    public void addMember(Guid guid) throws UMSException {
        String id = LDAPDN.normalize((String)guid.getDn());
        PersistentObject entry = null;
        try {
            entry = UMSObject.getObject(this.getPrincipal(), guid);
        }
        catch (UMSException ignore) {
            // empty catch block
        }
        if (entry != null && entry instanceof StaticGroup) {
            StaticGroup g = (StaticGroup)entry;
            if (id.equalsIgnoreCase(this.getDN()) || g.hasMember(this.getGuid(), -1)) {
                throw new UMSException(i18n.getString("ums-recursionnotallow"));
            }
        }
        this.modify(new Attr(MEMBER_ATTR_NAME, id), 0);
        this.save();
    }

    public void addMember(PersistentObject member) throws UMSException {
        this.addMember(member.getGuid());
    }

    public void addMembers(Guid[] guids) throws UMSException {
        if (guids == null) {
            String msg = i18n.getString("ums-badguid");
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < guids.length; ++i) {
            this.addMember(guids[i]);
        }
    }

    public SearchResults getMemberIDs() throws UMSException {
        return this.getMembers(0);
    }

    static int getMaxNestingLevel() {
        return 5;
    }

    public SearchResults getMembers(int level) throws UMSException {
        Attr attr = this.getAttribute(MEMBER_ATTR_NAME);
        if (attr == null) {
            return null;
        }
        if (level == -1) {
            level = StaticGroup.getMaxNestingLevel();
        }
        if (level == 0) {
            return new SearchResults(this.getAttribute(MEMBER_ATTR_NAME));
        }
        Attr nestedMembers = new Attr(MEMBER_ATTR_NAME);
        LDAPAttribute la = attr.toLDAPAttribute();
        Enumeration en = la.getStringValues();
        while (en.hasMoreElements()) {
            String memberdn = (String)en.nextElement();
            PersistentObject entry = null;
            try {
                entry = UMSObject.getObject(this.getPrincipal(), new Guid(memberdn));
            }
            catch (UMSException ignore) {
                // empty catch block
            }
            if (entry != null && entry instanceof StaticGroup) {
                SearchResults r = ((StaticGroup)entry).getMembers(level - 1);
                while (r.hasMoreElements()) {
                    PersistentObject member = null;
                    try {
                        member = r.next();
                        nestedMembers.addValue(member.getDN());
                    }
                    catch (UMSException ignore) {}
                }
            } else {
                nestedMembers.addValue(memberdn);
            }
            entry = null;
        }
        return new SearchResults(nestedMembers);
    }

    public int getMemberCount() throws UMSException {
        return this.getMemberCount(0);
    }

    public int getMemberCount(int level) throws UMSException {
        if (level == -1) {
            level = StaticGroup.getMaxNestingLevel();
        }
        if (level == 0) {
            Attr attr = this.getAttribute(MEMBER_ATTR_NAME);
            return attr != null ? attr.size() : 0;
        }
        SearchResults allMembers = this.getMembers(level);
        if (allMembers == null) {
            return 0;
        }
        int count = 0;
        while (allMembers.hasMoreElements()) {
            allMembers.next();
            ++count;
        }
        return count;
    }

    public Guid getMemberIDAt(int index) throws UMSException {
        Attr attr = this.getAttribute(MEMBER_ATTR_NAME);
        String value = attr.getStringValues()[index];
        return value != null ? new Guid(value) : null;
    }

    public Guid getMemberIDAt(int index, int level) throws UMSException {
        SearchResults allMembers = this.getMembers(level);
        if (allMembers == null) {
            return null;
        }
        int i = 0;
        while (allMembers.hasMoreElements()) {
            PersistentObject entry = allMembers.next();
            if (i++ != index) continue;
            return new Guid(entry.getDN());
        }
        return null;
    }

    public void removeMember(Guid guid) throws UMSException {
        String dn = guid.getDn();
        super.modify(new Attr(MEMBER_ATTR_NAME, LDAPDN.normalize((String)dn)), 1);
        this.save();
    }

    public void removeMember(PersistentObject member) throws UMSException {
        this.removeMember(member.getGuid());
    }

    public void removeAllMembers() throws UMSException {
        if (this.getMemberCount() == 0) {
            return;
        }
        ModSet modSet = new ModSet();
        modSet.add(1, new LDAPAttribute(MEMBER_ATTR_NAME));
        this.modify(modSet);
        this.save();
    }

    public boolean hasMember(Guid guid) throws UMSException {
        return this.isMemberAtLevel(guid.getDn(), 0);
    }

    private boolean isMemberAtLevel(String normalizedID, int level) throws UMSException {
        if (level == -1) {
            level = StaticGroup.getMaxNestingLevel();
        }
        SearchResults members = this.getMembers(level);
        while (members.hasMoreElements()) {
            PersistentObject entry = members.next();
            String entryDN = entry.getDN();
            if (!Guid.equals(normalizedID, entryDN)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMember(Guid guid, int level) throws UMSException {
        if (level == -1) {
            level = StaticGroup.getMaxNestingLevel();
        }
        String id = guid.getDn();
        for (int i = 0; i <= level; ++i) {
            if (!this.isMemberAtLevel(id, i)) continue;
            return true;
        }
        return false;
    }
}

