/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums.dctree;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.util.I18n;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.iplanet.ums.Guid;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;

public class DomainComponent
extends PersistentObject {
    static final String[] dcObjectClasses = new String[]{"top", "domain", "inetDomain"};
    static final String DEFAULT_NAMING_ATTR = "dc";
    static final String TAG_ORG_LINK = "inetDomainBaseDN";
    static final String TAG_DOMAIN_STATUS = "inetDomainStatus";
    private static I18n i18n = I18n.getInstance("amSDK");
    private SSOToken m_token = null;

    public DomainComponent() {
    }

    public DomainComponent(SSOToken token, String dcName) throws UMSException {
        this.setAttribute(new Attr("objectclass", dcObjectClasses));
        this.setAttribute(new Attr(DEFAULT_NAMING_ATTR, dcName));
        try {
            SSOTokenManager.getInstance().validateToken(token);
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), (Throwable)((Object)se));
        }
        this.m_token = token;
    }

    public void setAssociatedOrganization(PersistentObject org) throws UMSException {
        this.setAssociatedOrganization(org.getGuid());
    }

    public void setAssociatedOrganization(Guid orgGuid) throws UMSException {
        if (orgGuid == null || orgGuid.getDn().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.modify(new Attr(TAG_ORG_LINK, orgGuid.getDn()), 2);
        if (this.isPersistent()) {
            this.save();
        }
    }

    public PersistentObject getOrganization() throws UMSException {
        Guid orgGuid = this.getAssociatedOrganizationGuid();
        return UMSObject.getObject(this.getSSOToken(), orgGuid);
    }

    public Guid getAssociatedOrganizationGuid() throws UMSException {
        Attr attr = this.getAttribute(TAG_ORG_LINK);
        if (attr == null) {
            return null;
        }
        return new Guid(attr.getValue());
    }

    public String getDomainStatus() throws UMSException {
        Attr attr = this.getAttribute(TAG_DOMAIN_STATUS);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public void setDomainStatus(String status) throws UMSException {
        this.modify(new Attr(TAG_DOMAIN_STATUS, status), 2);
        if (this.isPersistent()) {
            this.save();
        }
    }

    public String getNamingAttribute() {
        return DEFAULT_NAMING_ATTR;
    }

    SSOToken getSSOToken() {
        return this.m_token;
    }

    void setSSOToken(SSOToken token) throws UMSException {
        try {
            SSOTokenManager.getInstance().validateToken(token);
        }
        catch (SSOException se) {
            throw new UMSException(i18n.getString("ums-invalidssotoken"), (Throwable)((Object)se));
        }
        this.m_token = token;
    }
}

