/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.jaas;

import com.sun.identity.shared.debug.Debug;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;

public class LoginContext {
    private static final String INIT_METHOD = "initialize";
    private static final String LOGIN_METHOD = "login";
    private static final String COMMIT_METHOD = "commit";
    private static final String ABORT_METHOD = "abort";
    private static final String LOGOUT_METHOD = "logout";
    private static final String OTHER = "other";
    private static final String DEFAULT_HANDLER = "auth.login.defaultCallbackHandler";
    private Subject subject = null;
    private boolean subjectProvided = false;
    private boolean loginSucceeded = false;
    private CallbackHandler callbackHandler;
    private Map state = new HashMap();
    private Configuration config;
    private boolean configProvided = false;
    private ModuleInfo[] moduleStack;
    private static final Class[] PARAMS = new Class[0];
    LoginException firstError = null;
    LoginException firstRequiredError = null;
    boolean success = false;
    private static final Debug debug = Debug.getInstance((String)"amJAAS");

    private void init(AppConfigurationEntry[] entries) throws LoginException {
        this.moduleStack = new ModuleInfo[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            this.moduleStack[i] = new ModuleInfo(new AppConfigurationEntry(entries[i].getLoginModuleName(), entries[i].getControlFlag(), entries[i].getOptions()), null);
        }
    }

    public LoginContext(AppConfigurationEntry[] entries, CallbackHandler callbackHandler) throws LoginException {
        this.init(entries);
        if (callbackHandler == null) {
            throw new LoginException("invalid null CallbackHandler provided");
        }
        this.callbackHandler = callbackHandler;
    }

    public LoginContext(AppConfigurationEntry[] entries, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        this.init(entries);
        if (subject == null) {
            throw new LoginException("invalid null Subject provided");
        }
        this.subject = subject;
        this.subjectProvided = true;
        if (callbackHandler == null) {
            throw new LoginException("invalid null CallbackHandler provided");
        }
        this.callbackHandler = callbackHandler;
    }

    public void login() throws LoginException {
        this.loginSucceeded = false;
        if (this.subject == null) {
            this.subject = new Subject();
        }
        try {
            this.invoke(LOGIN_METHOD);
            this.invoke(COMMIT_METHOD);
            this.loginSucceeded = true;
        }
        catch (LoginException le) {
            try {
                this.invoke(ABORT_METHOD);
            }
            catch (LoginException le2) {
                throw le;
            }
            throw le;
        }
    }

    public void logout() throws LoginException {
        if (this.subject == null) {
            throw new LoginException("null subject - logout called before login");
        }
        this.invoke(LOGOUT_METHOD);
    }

    public Subject getSubject() {
        if (!this.loginSucceeded && !this.subjectProvided) {
            return null;
        }
        return this.subject;
    }

    private void throwException(LoginException originalError, LoginException le) throws LoginException {
        throw originalError != null ? originalError : le;
    }

    private void invoke(String methodName) throws LoginException {
        for (int i = 0; i < this.moduleStack.length; ++i) {
            try {
                int mIndex = 0;
                Method[] methods = null;
                if (this.moduleStack[i].module != null) {
                    methods = this.moduleStack[i].module.getClass().getMethods();
                } else {
                    Class<?> c = Class.forName(this.moduleStack[i].entry.getLoginModuleName(), true, Thread.currentThread().getContextClassLoader());
                    Constructor<?> constructor = c.getConstructor(PARAMS);
                    Object[] args = new Object[]{};
                    this.moduleStack[i].module = constructor.newInstance(args);
                    methods = this.moduleStack[i].module.getClass().getMethods();
                    for (mIndex = 0; mIndex < methods.length && !methods[mIndex].getName().equals(INIT_METHOD); ++mIndex) {
                    }
                    Object[] initArgs = new Object[]{this.subject, this.callbackHandler, this.state, this.moduleStack[i].entry.getOptions()};
                    methods[mIndex].invoke(this.moduleStack[i].module, initArgs);
                }
                for (mIndex = 0; mIndex < methods.length && !methods[mIndex].getName().equals(methodName); ++mIndex) {
                }
                Object[] args = new Object[0];
                boolean status = (Boolean)methods[mIndex].invoke(this.moduleStack[i].module, args);
                if (status) {
                    if (!methodName.equals(ABORT_METHOD) && !methodName.equals(LOGOUT_METHOD) && this.moduleStack[i].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT && this.firstRequiredError == null) {
                        if (debug.messageEnabled()) {
                            debug.message(methodName + " SUFFICIENT success");
                        }
                        return;
                    }
                    if (debug.messageEnabled()) {
                        debug.message(methodName + " success");
                    }
                    this.success = true;
                    continue;
                }
                if (!debug.messageEnabled()) continue;
                debug.message(methodName + " ignored");
                continue;
            }
            catch (NoSuchMethodException nsme) {
                throw new LoginException("unable to instantiate LoginModule, module, because it does not provide a no-argument constructor:" + this.moduleStack[i].entry.getLoginModuleName());
            }
            catch (InstantiationException ie) {
                throw new LoginException("unable to instantiate LoginModule: " + ie.getMessage());
            }
            catch (ClassNotFoundException cnfe) {
                throw new LoginException("unable to find LoginModule class: " + cnfe.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new LoginException("unable to access LoginModule: " + iae.getMessage());
            }
            catch (InvocationTargetException ite) {
                LoginException le;
                if (ite.getTargetException() instanceof Error) {
                    if (debug.messageEnabled()) {
                        debug.message("LoginContext.invoke():Handling expected java.lang.Error");
                    }
                    throw (Error)ite.getTargetException();
                }
                if (ite.getTargetException() instanceof LoginException) {
                    le = (LoginException)ite.getTargetException();
                } else if (ite.getTargetException() instanceof SecurityException) {
                    le = new LoginException("Security Exception");
                    if (debug.messageEnabled()) {
                        debug.message("original security exception with detail msg replaced by new exception with empty detail msg");
                        debug.message("original security exception: " + ite.getTargetException().toString());
                    }
                } else {
                    StringWriter sw = new StringWriter();
                    ite.getTargetException().printStackTrace(new PrintWriter(sw));
                    sw.flush();
                    le = new LoginException(sw.toString());
                }
                if (this.moduleStack[i].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE) {
                    if (debug.messageEnabled()) {
                        debug.message(methodName + " REQUISITE failure");
                    }
                    if (methodName.equals(ABORT_METHOD) || methodName.equals(LOGOUT_METHOD)) {
                        if (this.firstRequiredError != null) continue;
                        this.firstRequiredError = le;
                        continue;
                    }
                    this.throwException(this.firstRequiredError, le);
                    continue;
                }
                if (this.moduleStack[i].entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED) {
                    if (debug.messageEnabled()) {
                        debug.message(methodName + " REQUIRED failure");
                        debug.message("Exception: " + le);
                    }
                    if (this.firstRequiredError != null) continue;
                    this.firstRequiredError = le;
                    debug.message("Set firstRequiredError to " + le);
                    continue;
                }
                if (debug.messageEnabled()) {
                    debug.message(methodName + " OPTIONAL failure");
                }
                if (this.firstError != null) continue;
                this.firstError = le;
            }
        }
        if (this.firstRequiredError != null) {
            this.throwException(this.firstRequiredError, null);
        } else if (!this.success && this.firstError != null) {
            this.throwException(this.firstError, null);
        } else if (!this.success) {
            this.throwException(new LoginException("Login Failure: all modules ignored"), null);
        } else {
            return;
        }
    }

    private static class ModuleInfo {
        AppConfigurationEntry entry;
        Object module;

        ModuleInfo(AppConfigurationEntry newEntry, Object newModule) {
            this.entry = newEntry;
            this.module = newModule;
        }
    }
}

