/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.hotp;

import com.iplanet.dpro.session.service.InternalSession;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.modules.hotp.HOTPAlgorithm;
import com.sun.identity.authentication.modules.hotp.HOTPPrincipal;
import com.sun.identity.authentication.modules.hotp.SMSGateway;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.ServiceConfig;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.PasswordCallback;

public class HOTP
extends AMLoginModule {
    ResourceBundle bundle = null;
    private String userName = null;
    private String userUUID = null;
    private ServiceConfig sc;
    private int currentState;
    private String currentConfigName;
    private Map sharedState;
    public Map currentConfig;
    protected Debug debug = Debug.getInstance((String)this.amAuthHOTP);
    protected String amAuthHOTP = "amAuthHOTP";
    protected Principal userPrincipal;
    private static int movingFactor = 0;
    String sentHOTPCode = null;
    long sentHOTPCodeTime;
    String enteredHOTPCode = null;
    private SecureRandom secureRandom = null;
    private static String AUTHLEVEL = "sunAMAuthHOTPAuthLevel";
    private static String GATEWAYSMSImplCLASS = "sunAMAuthHOTPSMSGatewayImplClassName";
    private static String CODEVALIDITYDURATION = "sunAMAuthHOTPPasswordValidityDuration";
    private static String CODELENGTH = "sunAMAuthHOTPPasswordLength";
    private static String CODEDELIVERY = "sunAMAuthHOTPasswordDelivery";
    String gatewaySMSImplClass = null;
    String codeValidityDuration = null;
    String codeLength = null;
    String codeDelivery = null;

    public HOTP() {
        try {
            this.secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException ex) {
            this.debug.error("HOTP.HOTP() : HOTP : Initialization Failed", (Throwable)ex);
        }
    }

    public void init(Subject subject, Map sharedState, Map options) {
        this.sc = (ServiceConfig)options.get("ServiceConfig");
        this.currentConfig = options;
        this.currentConfigName = (String)options.get("moduleInstanceName");
        String authLevel = CollectionHelper.getMapAttr((Map)options, (String)AUTHLEVEL);
        if (authLevel != null) {
            try {
                this.setAuthLevel(Integer.parseInt(authLevel));
            }
            catch (Exception e) {
                this.debug.error("HOTP.init() : Unable to set auth level " + authLevel, (Throwable)e);
            }
        }
        this.gatewaySMSImplClass = CollectionHelper.getMapAttr((Map)options, (String)GATEWAYSMSImplCLASS);
        this.codeValidityDuration = CollectionHelper.getMapAttr((Map)options, (String)CODEVALIDITYDURATION);
        this.codeLength = CollectionHelper.getMapAttr((Map)options, (String)CODELENGTH);
        this.codeDelivery = CollectionHelper.getMapAttr((Map)options, (String)CODEDELIVERY);
        Locale locale = this.getLoginLocale();
        this.bundle = amCache.getResBundle(this.amAuthHOTP, locale);
        if (this.debug.messageEnabled()) {
            this.debug.message("HOTP.init() : HOTP resouce bundle locale=" + locale);
        }
        try {
            this.userName = (String)sharedState.get(this.getUserKey());
        }
        catch (Exception e) {
            this.debug.error("HOTP.init() : Unable to set userName : ", (Throwable)e);
        }
        this.sharedState = sharedState;
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        this.currentState = state;
        boolean retVal = false;
        int action = 0;
        try {
            if (this.userName == null || this.userName.length() == 0) {
                SSOTokenManager mgr = SSOTokenManager.getInstance();
                InternalSession isess = this.getLoginState("HOTP").getOldSession();
                if (isess == null) {
                    throw new AuthLoginException("amAuth", "noInternalSession", null);
                }
                SSOToken token = mgr.createSSOToken(isess.getID().toString());
                this.userUUID = token.getPrincipal().getName();
                this.userName = token.getProperty("UserToken");
                if (this.debug.messageEnabled()) {
                    this.debug.message("HOTP.process() : UserName in SSOToekn : " + this.userName);
                }
                if (this.userName == null || this.userName.length() == 0) {
                    throw new AuthLoginException("amAuth", "noUserName", null);
                }
            }
            if (this.currentState == 1) {
                if (callbacks != null && callbacks.length == 2) {
                    action = ((ConfirmationCallback)callbacks[1]).getSelectedIndex();
                    if (this.debug.messageEnabled()) {
                        this.debug.message("HOTP.process() : LOGIN page button index: " + action);
                    }
                    if (action == 0) {
                        this.enteredHOTPCode = String.valueOf(((PasswordCallback)callbacks[0]).getPassword());
                        if (this.sentHOTPCode == null || this.sentHOTPCode.length() == 0 || this.enteredHOTPCode == null || this.enteredHOTPCode.length() == 0) {
                            if (this.debug.messageEnabled()) {
                                this.debug.message("HOTP.process() : invalid HOTP code");
                            }
                            this.setFailureID(this.userName);
                            throw new InvalidPasswordException("amAuth", "invalidPasswd", null);
                        }
                        if (this.sentHOTPCode.equals(this.enteredHOTPCode)) {
                            long timePassed = System.currentTimeMillis() / 1000L - this.sentHOTPCodeTime;
                            if (timePassed <= Long.valueOf(this.codeValidityDuration) * 60L) {
                                this.sentHOTPCode = null;
                                this.enteredHOTPCode = null;
                                return -1;
                            }
                            if (this.debug.messageEnabled()) {
                                this.debug.message("HOTP.process() : HOTP code has expired");
                            }
                            this.setFailureID(this.userName);
                            throw new InvalidPasswordException("amAuth", "invalidPasswd", null);
                        }
                        if (this.debug.messageEnabled()) {
                            this.debug.message("HOTP.process() : HOTP code is not valid");
                        }
                        this.setFailureID(this.userName);
                        throw new InvalidPasswordException("amAuth", "invalidPasswd", null);
                    }
                    this.sentHOTPCode = this.sendHOTPCode(callbacks);
                    return 1;
                }
                this.setFailureID(this.userName);
                throw new AuthLoginException(this.amAuthHOTP, "authFailed", null);
            }
            this.setFailureID(this.userName);
            throw new AuthLoginException(this.amAuthHOTP, "authFailed", null);
        }
        catch (NumberFormatException ex) {
            this.debug.error("HOTP.process() : NumberFormatException Exception", (Throwable)ex);
            if (this.userName != null && this.userName.length() != 0) {
                this.setFailureID(this.userName);
            }
            throw new AuthLoginException(this.amAuthHOTP, "authFailed", null, ex);
        }
        catch (SSOException e) {
            this.debug.error("HOTP.process() : SSOException", (Throwable)((Object)e));
            throw new InvalidPasswordException("amAuth", "invalidPasswd", null);
        }
    }

    public Principal getPrincipal() {
        if (this.userUUID != null) {
            this.userPrincipal = new HOTPPrincipal(this.userUUID);
            return this.userPrincipal;
        }
        if (this.userName != null) {
            this.userPrincipal = new HOTPPrincipal(this.userName);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.nullifyUsedVars();
    }

    public void nullifyUsedVars() {
        this.bundle = null;
        this.userName = null;
        this.sc = null;
        this.sharedState = null;
        this.currentConfig = null;
        this.amAuthHOTP = null;
        this.sentHOTPCode = null;
        this.enteredHOTPCode = null;
    }

    private String sendHOTPCode(Callback[] callbacks) throws AuthLoginException {
        try {
            int codeDigits = 8;
            if (this.codeLength.equals("6")) {
                codeDigits = 6;
            }
            String code = HOTPAlgorithm.generateOTP(this.getSharedSecret(), this.getMovingFactor(), codeDigits, false, 16);
            this.sentHOTPCodeTime = System.currentTimeMillis() / 1000L;
            this.sendSMS(code);
            return code;
        }
        catch (NoSuchAlgorithmException e) {
            this.debug.error("HOTP.sendHOTPCode() : no such algorithm", (Throwable)e);
            throw new AuthLoginException("amAuth", "noSuchAlgorithm", null);
        }
        catch (InvalidKeyException e) {
            this.debug.error("HOTP.sendHOTPCode() : invalid key", (Throwable)e);
            throw new AuthLoginException("amAuth", "invalidKey", null);
        }
        catch (SSOException e) {
            this.debug.error("HOTP.sendHOTPCode() : invlaid SSO token", (Throwable)((Object)e));
            throw new AuthLoginException("amAuth", "invalidSSOToken", null);
        }
    }

    private byte[] getSharedSecret() {
        String s = Long.toHexString(this.secureRandom.nextLong());
        return s.getBytes();
    }

    private int getMovingFactor() {
        return movingFactor++;
    }

    private void sendSMS(String code) throws SSOException {
        AMIdentityRepository amIdRepo = this.getAMIdentityRepository(this.getRequestOrg());
        IdSearchControl idsc = new IdSearchControl();
        idsc.setRecursive(true);
        idsc.setTimeOut(0);
        idsc.setAllReturnAttributes(true);
        Set results = Collections.EMPTY_SET;
        try {
            idsc.setMaxResults(0);
            IdSearchResults searchResults = amIdRepo.searchIdentities(IdType.USER, this.userName, idsc);
            if (searchResults != null) {
                results = searchResults.getSearchResults();
            }
            if (results == null || results.size() != 1) {
                throw new IdRepoException("HTOP:sendSMS : More than one user found");
            }
            Object[] ids = results.toArray();
            AMIdentity id = (AMIdentity)ids[0];
            Set telephoneNumbers = id.getAttribute("telephoneNumber");
            Set emails = id.getAttribute("mail");
            String phone = null;
            Iterator itor = null;
            if (telephoneNumbers != null && telephoneNumbers.size() != 0) {
                itor = telephoneNumbers.iterator();
                phone = (String)itor.next();
                if (this.debug.messageEnabled()) {
                    this.debug.message("HOTP.sendSMS() : IdRepoException : phone number found " + phone + " with username : " + this.userName);
                }
            } else if (this.debug.messageEnabled()) {
                this.debug.message("HOTP.sendSMS() : IdRepoException : no phone number found  with username : " + this.userName);
            }
            String mail = null;
            if (emails != null && emails.size() != 0) {
                itor = emails.iterator();
                mail = (String)itor.next();
                if (this.debug.messageEnabled()) {
                    this.debug.message("HOTP.sendSMS() : IdRepoException : email number found " + mail + " with username : " + this.userName);
                }
            } else if (this.debug.messageEnabled()) {
                this.debug.message("HOTP.sendSMS() : IdRepoException : no email found  with username : " + this.userName);
            }
            if (phone != null || mail != null) {
                String from = this.bundle.getString("messageFrom");
                String subject = this.bundle.getString("messageSubject");
                String message = this.bundle.getString("messageContent");
                SMSGateway gateway = (SMSGateway)Class.forName(this.gatewaySMSImplClass).newInstance();
                if (this.codeDelivery.equals("SMS and E-mail")) {
                    gateway.sendSMSMessage(from, phone, subject, message, code, this.currentConfig);
                    gateway.sendEmail(from, mail, subject, message, code, this.currentConfig);
                } else if (this.codeDelivery.equals("SMS")) {
                    gateway.sendSMSMessage(from, phone, subject, message, code, this.currentConfig);
                } else if (this.codeDelivery.equals("E-mail")) {
                    gateway.sendEmail(from, mail, subject, message, code, this.currentConfig);
                }
            } else if (this.debug.messageEnabled()) {
                this.debug.message("HOTP.sendSMS() : IdRepoException : no phone or email found  with username : " + this.userName);
            }
        }
        catch (ClassNotFoundException ee) {
            this.debug.error("HOTP.sendSMS() : class not found SMSGateway class", (Throwable)ee);
        }
        catch (InstantiationException ie) {
            this.debug.error("HOTP.sendSMS() : can not instantiate SMSGateway class", (Throwable)ie);
        }
        catch (IdRepoException e) {
            this.debug.error("HOTP.sendSMS() : error searching  Identities with username : " + this.userName, (Throwable)e);
        }
        catch (Exception e) {
            this.debug.error("HOTP.sendSMS() : HOTP module exception : ", (Throwable)e);
        }
    }
}

