/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.spi;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.spi.AMAuthCallBack;
import com.sun.identity.authentication.spi.AMAuthCallBackException;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AMAuthCallBackImpl {
    static final String AUTH_PLUGIN_MODULES_ATTR = "sunAMUserStatusCallbackPlugins";
    static final String DEBUG_FILE = "amAuth";
    static final String bundleName = "amAuth";
    private static Debug debug = Debug.getInstance((String)"amAuth");
    private static Map theCallBackInst = new HashMap();
    private Set pluginSet;
    private String theRealm;

    private AMAuthCallBackImpl(String aRealm) throws AMAuthCallBackException {
        SSOToken token;
        block3: {
            this.pluginSet = Collections.EMPTY_SET;
            this.theRealm = null;
            this.theRealm = aRealm;
            token = null;
            if (debug.messageEnabled()) {
                debug.message("AMAuthCallBackImpl : in constructor. Realm = " + this.theRealm);
            }
            try {
                token = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            }
            catch (NullPointerException npe) {
                if (!debug.errorEnabled()) break block3;
                debug.error("AMAuthCallBackImpl : constructor cannot get SSO Token. No callbacks will be made for the realm : " + this.theRealm, (Throwable)npe);
            }
        }
        this.pluginSet = this.getRealmAuthPlugIns(token, AUTH_PLUGIN_MODULES_ATTR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AMAuthCallBackImpl getInstance(String aRealm) throws AMAuthCallBackException {
        if (debug.messageEnabled()) {
            debug.message("AMAuthCallBackImpl : getting instance.");
        }
        Map map = theCallBackInst;
        synchronized (map) {
            if (theCallBackInst.get(aRealm) == null) {
                theCallBackInst.put(aRealm, new AMAuthCallBackImpl(aRealm));
            }
        }
        return (AMAuthCallBackImpl)theCallBackInst.get(aRealm);
    }

    public void processedPasswordChange(Long eventTime, String userDN) throws AMAuthCallBackException {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("timechanged", eventTime);
        eventParams.put("realm", this.theRealm);
        eventParams.put("userdn", userDN);
        this.processedEvent(1, eventParams);
    }

    public void processedAccounttLockout(Long eventTime, String userDN) throws AMAuthCallBackException {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        eventParams.put("timechanged", eventTime);
        eventParams.put("realm", this.theRealm);
        eventParams.put("userdn", userDN);
        this.processedEvent(2, eventParams);
    }

    public void processedEvent(int eventType, Map eventParams) throws AMAuthCallBackException {
        if (this.pluginSet != Collections.EMPTY_SET) {
            Iterator itr = this.pluginSet.iterator();
            while (itr.hasNext()) {
                AMAuthCallBack pluginClass = this.instantiateClass((String)itr.next());
                if (pluginClass == null) continue;
                pluginClass.authEventCallback(eventType, eventParams);
            }
        }
        if (this.pluginSet.isEmpty() && debug.messageEnabled()) {
            debug.message("AMAuthCallBackImpl : processedEvent. pluginSet is empty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getRealmAuthPlugIns(SSOToken internalToken, String attrName) {
        Set resultSet = Collections.EMPTY_SET;
        try {
            ServiceConfigManager scm = new ServiceConfigManager("iPlanetAMAuthService", internalToken);
            ServiceConfig sc = scm.getOrganizationConfig(this.theRealm, null);
            if (sc != null) {
                Map attributes = sc.getAttributes();
                resultSet = (Set)attributes.get(AUTH_PLUGIN_MODULES_ATTR);
            }
            ServiceConfig gc = scm.getGlobalConfig(null);
            if (gc != null) {
                Map attributes = gc.getAttributes();
                resultSet = (Set)attributes.get(AUTH_PLUGIN_MODULES_ATTR);
                return resultSet;
            }
        }
        catch (SMSException smse) {
            if (debug.errorEnabled()) {
                debug.error("AMAuthCallBackImpl getRealmAuthPlugIns : SMS error", (Throwable)smse);
            }
        }
        catch (SSOException ssoe) {
            if (debug.errorEnabled()) {
                debug.error("AMAuthCallBackImpl getRealmAuthPlugIns : SSO error", (Throwable)((Object)ssoe));
            }
        }
        finally {
            return resultSet;
        }
    }

    private AMAuthCallBack instantiateClass(String className) {
        try {
            if (debug.messageEnabled()) {
                debug.message("AMAuthCallBackImpl : instantiateClass. Class name is : " + className);
            }
            return (AMAuthCallBack)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            debug.error("AuthCallBackImpl.instantiateClass(): Unable to locate class " + className, (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            debug.error("AuthCallBackImpl.instantiateClass(): Unable to instantiate class " + className, (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            debug.error("AuthCallBackImpl.instantiateClass(): Problem with the Security Manager for class " + className, (Throwable)iae);
        }
        catch (Exception e) {
            debug.error("AMCallBackImpl.instantiateClass(): Unknown error for class " + className, (Throwable)e);
        }
        return null;
    }
}

