/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AttributeValues;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class RealmAssignService
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        String serviceName = this.getStringOptionValue("servicename");
        String datafile = this.getStringOptionValue("datafile");
        List attrValues = rc.getOption("attributevalues");
        if (datafile == null && attrValues == null) {
            throw new CLIException(this.getResourceString("missing-attributevalues"), 11, rc.getSubCommand().getName());
        }
        Map attributeValues = AttributeValues.parse(this.getCommandManager(), datafile, attrValues);
        IOutput outputWriter = this.getOutputWriter();
        String[] params = new String[]{realm, serviceName};
        this.writeLog(0, Level.INFO, "ATTEMPT_ASSIGN_SERVICE_TO_REALM", params);
        try {
            OrganizationConfigManager ocm = new OrganizationConfigManager(adminSSOToken, realm);
            Set assignableServices = ocm.getAssignableServices();
            AMIdentityRepository amir = new AMIdentityRepository(adminSSOToken, realm);
            AMIdentity ai = amir.getRealmIdentity();
            Set dynAssignableServices = ai.getAssignableServices();
            if (assignableServices.contains(serviceName)) {
                ocm.assignService(serviceName, attributeValues);
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("assign-service-to-realm-succeed"), params));
            }
            if (dynAssignableServices.contains(serviceName)) {
                ai.assignService(serviceName, attributeValues);
                outputWriter.printlnMessage(MessageFormat.format(this.getResourceString("assign-service-to-realm-succeed"), params));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_ASSIGN_SERVICE_TO_REALM", params);
        }
        catch (SSOException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmAssignService.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_ASSIGN_SERVICE_TO_REALM", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (IdRepoException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmAssignService.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_ASSIGN_SERVICE_TO_REALM", args);
            throw new CLIException(e, 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("RealmAssignService.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_ASSIGN_SERVICE_TO_REALM", args);
            throw new CLIException(e, 127);
        }
    }
}

