/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.serverconfig;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.serverconfig.ServerConfigBase;
import com.sun.identity.common.configuration.ConfigurationException;
import com.sun.identity.common.configuration.SiteConfiguration;
import com.sun.identity.sm.SMSException;
import java.util.List;
import java.util.logging.Level;

public class AddSiteMembers
extends ServerConfigBase {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String siteName = this.getStringOptionValue("sitename");
        List serverNames = rc.getOption("servernames");
        IOutput outputWriter = this.getOutputWriter();
        try {
            if (SiteConfiguration.isLegacy(adminSSOToken)) {
                outputWriter.printMessage(this.getResourceString("serverconfig-no-supported"));
                return;
            }
            String[] params = new String[]{siteName};
            this.writeLog(0, Level.INFO, "ATTEMPT_ADD_SITE_MEMBERS", params);
            if (SiteConfiguration.isSiteExist(adminSSOToken, siteName)) {
                SiteConfiguration.addServersToSite(adminSSOToken, siteName, serverNames);
                outputWriter.printlnMessage(this.getResourceString("add-site-members-succeeded"));
            } else {
                outputWriter.printlnMessage(this.getResourceString("add-site-members-site-not-exist"));
            }
            this.writeLog(0, Level.INFO, "SUCCEED_ADD_SITE_MEMBERS", params);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("AddSiteMembers.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_ADD_SITE_MEMBERS", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("AddSiteMembers.handleRequest", (Throwable)((Object)e));
            this.writeLog(1, Level.INFO, "FAILED_ADD_SITE_MEMBERS", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{siteName, e.getMessage()};
            this.debugError("AddSiteMembers.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_ADD_SITE_MEMBERS", args);
            throw new CLIException(e, 127);
        }
    }
}

