/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.shared.ldap.LDAPAttribute;
import com.sun.identity.shared.ldap.LDAPAttributeSet;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPEntry;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPModification;
import com.sun.identity.shared.ldap.LDAPModificationSet;
import com.sun.identity.shared.ldap.LDAPSearchResults;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.ldap.util.LDIF;
import com.sun.identity.shared.ldap.util.LDIFAddContent;
import com.sun.identity.shared.ldap.util.LDIFAttributeContent;
import com.sun.identity.shared.ldap.util.LDIFContent;
import com.sun.identity.shared.ldap.util.LDIFModifyContent;
import com.sun.identity.shared.ldap.util.LDIFRecord;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;

public class LDAPUtils {
    private LDAPUtils() {
    }

    public static void createSchemaFromLDIF(String file, LDAPConnection ld) throws IOException, LDAPException {
        LDAPUtils.createSchemaFromLDIF(new LDIF(file), ld);
    }

    public static void createSchemaFromLDIF(DataInputStream stream, LDAPConnection ld) throws IOException, LDAPException {
        LDAPUtils.createSchemaFromLDIF(new LDIF(stream), ld);
    }

    public static void createSchemaFromLDIF(LDIF ldif, LDAPConnection ld) throws IOException, LDAPException {
        DN ripDN = new DN("cn=referential integrity postoperation,cn=plugins,cn=config");
        CaseInsensitiveHashSet existPlugins = null;
        int nextPluginIndex = 0;
        LDIFRecord rec = ldif.nextRecord();
        while (rec != null) {
            LDAPModificationSet modSet;
            LDIFContent content = null;
            String ldifDN = null;
            try {
                content = rec.getContent();
                ldifDN = rec.getDN();
                if (content instanceof LDIFModifyContent) {
                    LDAPModification[] mods = ((LDIFModifyContent)content).getModifications();
                    if (ripDN.equals(new DN(ldifDN))) {
                        modSet = new LDAPModificationSet();
                        for (int i = 0; i < mods.length; ++i) {
                            String value;
                            LDAPAttribute attr = mods[i].getAttribute();
                            String attrName = attr.getName().toLowerCase();
                            if (!attrName.startsWith("nsslapd-pluginarg")) {
                                modSet.add(mods[i].getOp(), attr);
                                continue;
                            }
                            if (existPlugins == null) {
                                LDAPAttribute pluginAttr;
                                existPlugins = new CaseInsensitiveHashSet();
                                LDAPEntry entry = ld.read(ldifDN);
                                while ((pluginAttr = entry.getAttribute("nsslapd-pluginarg" + nextPluginIndex)) != null) {
                                    existPlugins.add(pluginAttr.getStringValueArray()[0]);
                                    ++nextPluginIndex;
                                }
                            }
                            if (existPlugins.contains(value = attr.getStringValueArray()[0])) continue;
                            attr = new LDAPAttribute("nsslapd-pluginarg" + nextPluginIndex, value);
                            modSet.add(mods[i].getOp(), attr);
                            ++nextPluginIndex;
                        }
                        if (modSet.size() > 0) {
                            ld.modify(ldifDN, modSet);
                        }
                    } else {
                        ld.modify(ldifDN, mods);
                    }
                } else if (content instanceof LDIFAttributeContent || content instanceof LDIFAddContent) {
                    Object attrSet = null;
                    LDAPAttribute[] attrs = content instanceof LDIFAttributeContent ? ((LDIFAttributeContent)content).getAttributes() : ((LDIFAddContent)content).getAttributes();
                    LDAPEntry amEntry = new LDAPEntry(ldifDN, new LDAPAttributeSet(attrs));
                    ld.add(amEntry);
                }
            }
            catch (LDAPException e) {
                switch (e.getLDAPResultCode()) {
                    case 68: {
                        modSet = new LDAPModificationSet();
                        LDAPAttribute[] attrs = content instanceof LDIFAttributeContent ? ((LDIFAttributeContent)content).getAttributes() : ((LDIFAddContent)content).getAttributes();
                        for (int i = 0; i < attrs.length; ++i) {
                            modSet.add(0, attrs[i]);
                        }
                        try {
                            ld.modify(ldifDN, modSet);
                        }
                        catch (LDAPException ex) {}
                        break;
                    }
                }
            }
            rec = ldif.nextRecord();
        }
    }

    public static String getDBName(String suffix, LDAPConnection ld) throws LDAPException {
        String dbName = null;
        String filter = "cn=" + suffix;
        try {
            LDAPSearchResults results = ld.search("cn=mapping tree,cn=config", 2, filter, null, false);
            while (results.hasMoreElements()) {
                LDAPEntry entry = results.next();
                String dn = entry.getDN();
                LDAPAttributeSet set = entry.getAttributeSet();
                Enumeration e = set.getAttributes();
                while (e.hasMoreElements() && dbName == null) {
                    String[] value;
                    LDAPAttribute attr = (LDAPAttribute)e.nextElement();
                    String name = attr.getName();
                    if (!name.equals("nsslapd-backend") || (value = attr.getStringValueArray()).length <= 0) continue;
                    dbName = value[0];
                }
            }
        }
        catch (LDAPException lde) {
            // empty catch block
        }
        return dbName != null ? dbName : "userRoot";
    }
}

