/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMPropertySheetModel;
import com.sun.identity.console.dm.UserPropertiesBase;
import com.sun.identity.console.dm.model.UserModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.util.Map;

public class UserGeneralViewBean
extends UserPropertiesBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/dm/UserGeneral.jsp";
    private static final String PAGE_TITLE = "pgtitle";
    private static final String PROPERTY_ATTRIBUTES = "propertyAttributes";
    private AMPropertySheetModel psModel = null;
    private boolean submitCycle;

    public UserGeneralViewBean() {
        super("UserGeneral");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
    }

    protected void initialize() {
        String name;
        if (!this.initialized && (name = (String)this.getPageSessionAttribute("CurrentProfileView")) != null) {
            super.initialize();
            this.initialized = true;
            this.createPageTitleModel();
            this.createPropertyModel(name);
            this.registerChildren();
        }
    }

    protected void registerChildren() {
        this.registerChild(PROPERTY_ATTRIBUTES, AMPropertySheet.class);
        this.psModel.registerChildren((ContainerViewBase)this);
        this.ptModel.registerChildren((ContainerViewBase)this);
        super.registerChildren();
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PAGE_TITLE) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTY_ATTRIBUTES) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.psModel, name) : (this.psModel.isChildSupported(name) ? this.psModel.createChild((View)this, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name))));
        return view;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        if (!this.submitCycle) {
            this.model = (UserModel)this.getModel();
            if (this.model != null) {
                try {
                    AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTES);
                    String name = (String)this.getPageSessionAttribute("CurrentProfileView");
                    this.psModel.clear();
                    ps.setAttributeValues(this.model.getValues(name), this.model);
                }
                catch (AMConsoleException e) {
                    this.setInlineAlertMessage("warning", "message.warning", "noproperties.message");
                }
            }
        }
        this.setPageTitle("page.title.user.properties");
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        UserModel model = (UserModel)this.getModel();
        String name = (String)this.getPageSessionAttribute("CurrentProfileView");
        try {
            AMPropertySheet ps = (AMPropertySheet)this.getChild(PROPERTY_ATTRIBUTES);
            Map values = ps.getAttributeValues(model.getValues(name), false, model);
            model.updateUser(name, values);
            this.setInlineAlertMessage("info", "message.information", model.getLocalizedString("profile.updated"));
            this.forwardTo();
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            this.forwardTo();
        }
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardTo();
    }

    private void createPropertyModel(String userName) {
        UserModel model = (UserModel)this.getModel();
        this.psModel = new AMPropertySheetModel(model.getUserProfileXML(userName, ((Object)((Object)this)).getClass().getName()));
        this.psModel.clear();
    }
}

