/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.dm;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.identity.console.base.AMPrimaryMastHeadViewBean;
import com.sun.identity.console.base.AMPropertySheet;
import com.sun.identity.console.base.AMViewBeanBase;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMFormatUtils;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.dm.model.UserModel;
import com.sun.identity.console.dm.model.UserModelImpl;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class UserSelectServicesViewBean
extends AMPrimaryMastHeadViewBean {
    public static final String DEFAULT_DISPLAY_URL = "/console/dm/UserSelectServices.jsp";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";
    private static final String PROPERTY_ATTRIBUTE = "propertyAttributes";
    private static final String ATTR_SERVICE_LIST = "cbServiceList";
    private CCPageTitleModel ptModel;
    private CCPropertySheetModel propertySheetModel;

    public UserSelectServicesViewBean() {
        super("UserSelectServices");
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.createPageTitleModel();
        this.createPropertyModel();
        this.registerChildren();
    }

    protected void registerChildren() {
        this.ptModel.registerChildren((ContainerViewBase)this);
        this.propertySheetModel.registerChildren((ContainerViewBase)this);
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
        this.registerChild(PROPERTY_ATTRIBUTE, AMPropertySheet.class);
        super.registerChildren();
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : (name.equals(PROPERTY_ATTRIBUTE) ? new AMPropertySheet((ContainerView)this, (CCPropertySheetModelInterface)this.propertySheetModel, name) : (this.propertySheetModel.isChildSupported(name) ? this.propertySheetModel.createChild((View)this, name) : (this.ptModel.isChildSupported(name) ? this.ptModel.createChild((View)this, name) : super.createChild(name))));
        return view;
    }

    private void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/twoBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.ok");
        this.ptModel.setValue("button2", (Object)"button.cancel");
    }

    private void createPropertyModel() {
        this.propertySheetModel = new CCPropertySheetModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/propertyOrgSelectServices.xml"));
        this.propertySheetModel.clear();
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = RequestManager.getRequestContext().getRequest();
        return new UserModelImpl(req, this.getPageSessionAttributes());
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        try {
            String org = (String)this.getPageSessionAttribute("CurrentProfileView");
            UserModel model = (UserModel)this.getModel();
            Map assignable = model.getAssignableServiceNames(org);
            if (assignable == null || assignable.isEmpty()) {
                this.setInlineAlertMessage("info", "message.information", "no.assignable.services");
            }
            CCRadioButton rb = (CCRadioButton)this.getChild(ATTR_SERVICE_LIST);
            OptionList optList = AMFormatUtils.getSortedOptionList(assignable, model.getUserLocale());
            rb.setOptions(optList);
            String val = (String)rb.getValue();
            if (val == null || val.length() == 0) {
                rb.setValue((Object)optList.getValue(0));
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    public void handleButton2Request(RequestInvocationEvent event) {
        this.forwardToServiceView(event);
    }

    private void forwardToServiceView(RequestInvocationEvent event) {
        String returnVB = (String)this.removePageSessionAttribute("returnToViewBean");
        if (returnVB == null) {
            this.forwardTo();
        } else {
            try {
                String tmp = (String)this.getPageSessionAttribute("currentOrganization");
                Class<?> clazz = Class.forName(returnVB);
                AMViewBeanBase vb = (AMViewBeanBase)this.getViewBean(clazz);
                this.backTrail();
                this.passPgSessionMap((ViewBean)vb);
                vb.forwardTo(this.getRequestContext());
            }
            catch (ClassNotFoundException cnfe) {
                this.forwardTo();
            }
        }
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        UserModel model = (UserModel)this.getModel();
        String serviceName = (String)this.getDisplayFieldValue(ATTR_SERVICE_LIST);
        if (serviceName == null) {
            this.forwardToServiceView(event);
        } else if ((serviceName = serviceName.trim()).length() > 0) {
            String user = (String)this.getPageSessionAttribute("CurrentProfileView");
            try {
                model.assignService(user, serviceName);
                this.forwardToServiceView(event);
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
                this.forwardTo();
            }
        } else {
            this.setInlineAlertMessage("error", "message.error", "services.missing.servicename");
            this.forwardTo();
        }
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.directorymanager.services.select";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

