/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.policy.AuthLevelHelper;
import com.sun.identity.console.policy.ConditionEditViewBean;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.web.ui.view.html.CCSelect;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class PMDefaultAuthLevelConditionEditViewBean
extends ConditionEditViewBean {
    private static AuthLevelHelper helper = AuthLevelHelper.getInstance();
    private String realmValue;
    private boolean bSearchForRealm;
    public static final String DEFAULT_DISPLAY_URL = "/console/policy/PMDefaultAuthLevelConditionEdit.jsp";

    public PMDefaultAuthLevelConditionEditViewBean() {
        super("PMDefaultAuthLevelConditionEdit", DEFAULT_DISPLAY_URL);
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        String filter = (String)this.getDisplayFieldValue("tfSearch");
        if (filter == null || filter.trim().length() == 0) {
            this.setDisplayFieldValue("tfSearch", "*");
        }
        PolicyModel model = (PolicyModel)this.getModel();
        try {
            Set realmNames = helper.getRealmNames(filter, model);
            if (realmNames.isEmpty()) {
                this.setInlineAlertMessage("info", "message.information", "policy.condition.authlevel.no.search.result.message");
            } else {
                realmNames.add("");
            }
            String realmValue = (String)this.propertySheetModel.getValue("Realm");
            if (realmValue == null) {
                realmValue = "";
            }
            if (!this.bSearchForRealm && realmValue.length() > 0 && !realmNames.contains(realmValue)) {
                realmNames.add(realmValue);
                if (!this.isInlineAlertMessageSet()) {
                    String msg = model.getLocalizedString("policy.condition.authlevel.no.longer.exist.realm");
                    String[] param = new String[]{realmValue};
                    this.setInlineAlertMessage("info", "message.information", MessageFormat.format(msg, param));
                }
            }
            CCSelect sl = (CCSelect)this.getChild("Realm");
            sl.setOptions(this.createOptionList(this.getLabelValueMap(realmNames)));
            if (sl.getValue() == null) {
                sl.setValue((Object)realmValue);
            }
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
    }

    protected String getConditionXML(String curRealm, String condType, boolean readonly) {
        String xml = readonly ? "com/sun/identity/console/propertyPMConditionAuthLevel_Readonly.xml" : "com/sun/identity/console/propertyPMConditionAuthLevel.xml";
        return AMAdminUtils.getStringFromInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(xml));
    }

    protected String getMissingValuesMessage() {
        return "policy.condition.missing.auth.level";
    }

    protected Map getConditionValues(PolicyModel model, String realmName, String conditionType) {
        Map map = Collections.EMPTY_MAP;
        try {
            map = helper.getConditionValues((PolicyModel)this.getModel(), this.propertySheetModel);
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        return map;
    }

    public void handleBtnSearchRequest(RequestInvocationEvent event) {
        this.bSearchForRealm = true;
        this.forwardTo();
    }

    protected void setPropertiesValues(Map values) {
        helper.setPropertiesValues(values, this.propertySheetModel);
    }
}

