/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy.model;

import com.iplanet.sso.SSOException;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.policy.model.IdentitySubjectModel;
import com.sun.identity.console.policy.model.PolicyModelImpl;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class IdentitySubjectModelImpl
extends PolicyModelImpl
implements IdentitySubjectModel {
    public IdentitySubjectModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public IdSearchResults getEntityNames(String realmName, String strType, String pattern) throws AMConsoleException {
        if (realmName == null) {
            realmName = "/";
        }
        if (pattern == null || pattern.trim().length() == 0) {
            pattern = "*";
        }
        int sizeLimit = this.getSearchResultLimit();
        int timeLimit = this.getSearchTimeOutLimit();
        String[] params = new String[]{realmName, strType, pattern, Integer.toString(sizeLimit), Integer.toString(timeLimit)};
        try {
            AMIdentityRepository repo = new AMIdentityRepository(this.getUserSSOToken(), realmName);
            IdType type = IdUtils.getType(strType);
            IdSearchControl idsc = new IdSearchControl();
            idsc.setRecursive(true);
            idsc.setMaxResults(sizeLimit);
            idsc.setTimeOut(timeLimit);
            this.logEvent("ATTEMPT_SEARCH_IDENTITY", params);
            IdSearchResults results = repo.searchIdentities(type, pattern, idsc);
            this.logEvent("SUCCEED_SEARCH_IDENTITY", params);
            return results;
        }
        catch (IdRepoException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{realmName, strType, pattern, Integer.toString(sizeLimit), Integer.toString(timeLimit), strError};
            this.logEvent("IDM_EXCEPTION_SEARCH_IDENTITY", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{realmName, strType, pattern, Integer.toString(sizeLimit), Integer.toString(timeLimit), strError};
            this.logEvent("SSO_EXCEPTION_SEARCH_IDENTITY", paramsEx);
            throw new AMConsoleException(strError);
        }
    }
}

