/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.Application;
import com.sun.identity.entitlement.EntitlementConfiguration;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.PrivilegeIndexStore;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.interfaces.ResourceName;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.DNMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApplicationManager {
    private static final Object lock = new Object();
    private static Map<String, Set<Application>> applications = new HashMap<String, Set<Application>>();

    private ApplicationManager() {
    }

    public static Set<String> getApplicationNames(Subject adminSubject, String realm) {
        Set<Application> appls = ApplicationManager.getApplications(adminSubject, realm);
        HashSet<String> results = new HashSet<String>();
        for (Application appl : appls) {
            results.add(appl.getName());
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Application> getApplications(Subject adminSubject, String realm) {
        Set<Application> appls;
        if (DN.isDN((String)realm)) {
            realm = DNMapper.orgNameToRealmName(realm);
        }
        if ((appls = applications.get(realm)) == null) {
            Object object = lock;
            synchronized (object) {
                appls = applications.get(realm);
                if (appls == null) {
                    EntitlementConfiguration ec = EntitlementConfiguration.getInstance(adminSubject, realm);
                    appls = ec.getApplications();
                    applications.put(realm, appls);
                }
            }
        }
        return appls;
    }

    public static Application getApplicationForEvaluation(String realm, String name) {
        return ApplicationManager.getApplication(PrivilegeManager.superAdminSubject, realm, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Application getApplication(Subject adminSubject, String realm, String name) {
        if (name == null || name.length() == 0) {
            name = "iPlanetAMWebAgentService";
        }
        if (DN.isDN((String)realm)) {
            realm = DNMapper.orgNameToRealmName(realm);
        }
        Set<Application> appls = ApplicationManager.getApplications(adminSubject, realm);
        for (Application appl : appls) {
            if (!appl.getName().equals(name)) continue;
            return appl;
        }
        Iterator<Application> i$ = lock;
        synchronized (i$) {
            applications.remove(realm);
        }
        appls = ApplicationManager.getApplications(adminSubject, realm);
        for (Application appl : appls) {
            if (!appl.getName().equals(name)) continue;
            return appl;
        }
        return null;
    }

    public static void deleteApplication(Subject adminSubject, String realm, String name) throws EntitlementException {
        EntitlementConfiguration ec = EntitlementConfiguration.getInstance(adminSubject, realm);
        ec.removeApplication(name);
        ApplicationManager.clearCache(realm);
    }

    public static void saveApplication(Subject adminSubject, String realm, Application application) throws EntitlementException {
        ApplicationManager.validateApplication(adminSubject, realm, application);
        EntitlementConfiguration ec = EntitlementConfiguration.getInstance(adminSubject, realm);
        ec.storeApplication(application);
        ApplicationManager.clearCache(realm);
    }

    private static void validateApplication(Subject adminSubject, String realm, Application application) throws EntitlementException {
        if (!realm.equals("/")) {
            String applTypeName = application.getApplicationType().getName();
            ResourceName comp = application.getResourceComparator();
            Set<String> referredRes = ApplicationManager.getReferredResources(adminSubject, realm, applTypeName);
            for (String r : application.getResources()) {
                ApplicationManager.validateApplication(application, comp, r, referredRes);
            }
        }
    }

    private static void validateApplication(Application application, ResourceName comp, String res, Set<String> referredRes) throws EntitlementException {
        for (String r : referredRes) {
            ResourceMatch match = comp.compare(res, r, true);
            if (!match.equals(ResourceMatch.EXACT_MATCH) && !match.equals(ResourceMatch.WILDCARD_MATCH) && !match.equals(ResourceMatch.SUB_RESOURCE_MATCH)) continue;
            return;
        }
        Object[] param = new Object[]{application.getName()};
        throw new EntitlementException(247, param);
    }

    public static synchronized void clearCache(String realm) {
        applications.remove(realm);
    }

    public static void referApplication(Subject adminSubject, String parentRealm, String referRealm, String applicationName, Set<String> resources) throws EntitlementException {
        Application appl = ApplicationManager.getApplication(adminSubject, parentRealm, applicationName);
        if (appl == null) {
            Object[] params = new Object[]{parentRealm, referRealm, applicationName};
            throw new EntitlementException(280, params);
        }
        Application clone = appl.refers(referRealm, resources);
        EntitlementConfiguration ec = EntitlementConfiguration.getInstance(adminSubject, referRealm);
        ec.storeApplication(clone);
        ApplicationManager.clearCache(referRealm);
    }

    public static void dereferApplication(Subject adminSubject, String referRealm, String applicationName, Set<String> resources) throws EntitlementException {
        EntitlementConfiguration ec = EntitlementConfiguration.getInstance(adminSubject, referRealm);
        ec.removeApplication(applicationName, resources);
    }

    public static Set<String> getReferredResources(Subject adminSubject, String realm, String applicationTypeName) throws EntitlementException {
        PrivilegeIndexStore pis = PrivilegeIndexStore.getInstance(adminSubject, realm);
        return pis.getReferredResources(applicationTypeName);
    }
}

