/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.entitlement.Application;
import com.sun.identity.entitlement.ApplicationManager;
import com.sun.identity.entitlement.EntitlementConfiguration;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.EntitlementThreadPool;
import com.sun.identity.entitlement.IPrivilege;
import com.sun.identity.entitlement.Privilege;
import com.sun.identity.entitlement.PrivilegeIndexStore;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.ReferralPrivilege;
import com.sun.identity.entitlement.ResourceSearchIndexes;
import com.sun.identity.entitlement.SequentialThreadPool;
import com.sun.identity.entitlement.SubjectAttributesManager;
import com.sun.identity.entitlement.interfaces.IThreadPool;
import com.sun.identity.entitlement.opensso.DataStore;
import com.sun.identity.entitlement.opensso.IndexCache;
import com.sun.identity.entitlement.opensso.PolicyCache;
import com.sun.identity.entitlement.opensso.SimpleIterator;
import com.sun.identity.entitlement.opensso.SubjectUtils;
import com.sun.identity.entitlement.util.PrivilegeSearchFilter;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.BufferedIterator;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSSOIndexStore
extends PrivilegeIndexStore {
    private static final int DEFAULT_CACHE_SIZE = 100000;
    private static final int DEFAULT_THREAD_SIZE = 1;
    private static final int DEFAULT_IDX_CACHE_SIZE = 100000;
    private static final PolicyCache policyCache;
    private static final PolicyCache referralCache;
    private static final int policyCacheSize;
    private static final Map<String, IndexCache> indexCaches;
    private static final Map<String, IndexCache> referralIndexCaches;
    private static final int indexCacheSize;
    private static final DataStore dataStore;
    private static IThreadPool threadPool;
    private static boolean isMultiThreaded;
    private Subject superAdminSubject = SubjectUtils.createSuperAdminSubject();
    private String realmDN;
    private IndexCache indexCache;
    private IndexCache referralIndexCache;
    private EntitlementConfiguration entitlementConfig;

    private static int getInteger(EntitlementConfiguration ec, String key, int defaultVal) {
        Set<String> set = ec.getConfiguration(key);
        if (set == null || set.isEmpty()) {
            return defaultVal;
        }
        String str = set.iterator().next();
        return OpenSSOIndexStore.getNumeric(str, defaultVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSSOIndexStore(Subject adminSubject, String realm) {
        super(adminSubject, realm);
        this.realmDN = DNMapper.orgNameToDN(realm);
        this.entitlementConfig = EntitlementConfiguration.getInstance(adminSubject, realm);
        if (indexCacheSize > 0) {
            Map<String, IndexCache> map = indexCaches;
            synchronized (map) {
                this.indexCache = indexCaches.get(this.realmDN);
                if (this.indexCache == null) {
                    this.indexCache = new IndexCache(indexCacheSize);
                    indexCaches.put(this.realmDN, this.indexCache);
                }
            }
            map = referralIndexCaches;
            synchronized (map) {
                this.referralIndexCache = referralIndexCaches.get(this.realmDN);
                if (this.referralIndexCache == null) {
                    this.referralIndexCache = new IndexCache(indexCacheSize);
                    referralIndexCaches.put(this.realmDN, this.referralIndexCache);
                }
            }
        }
    }

    private static int getNumeric(String str, int defaultValue) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public void add(Set<IPrivilege> privileges) throws EntitlementException {
        for (IPrivilege p : privileges) {
            if (p instanceof Privilege) {
                this.add((Privilege)p);
                continue;
            }
            if (!(p instanceof ReferralPrivilege)) continue;
            this.add((ReferralPrivilege)p);
        }
    }

    private void add(Privilege privilege) throws EntitlementException {
        Subject adminSubject = this.getAdminSubject();
        String realm = this.getRealm();
        privilege.canonicalizeResources(adminSubject, DNMapper.orgNameToRealmName(realm));
        dataStore.add(adminSubject, this.realmDN, privilege);
        this.entitlementConfig.addSubjectAttributeNames(privilege.getEntitlement().getApplicationName(), SubjectAttributesManager.getRequiredAttributeNames(privilege));
    }

    private void add(ReferralPrivilege referral) throws EntitlementException {
        Subject adminSubject = this.getAdminSubject();
        String realm = this.getRealm();
        ReferralPrivilege clone = (ReferralPrivilege)referral.clone();
        clone.canonicalizeResources(adminSubject, DNMapper.orgNameToRealmName(realm));
        dataStore.addReferral(adminSubject, realm, clone);
    }

    @Override
    public void delete(String privilegeName) throws EntitlementException {
        this.delete(privilegeName, true);
    }

    @Override
    public void deleteReferral(String privilegeName) throws EntitlementException {
        this.deleteReferral(privilegeName, true);
    }

    @Override
    public void delete(Set<IPrivilege> privileges) throws EntitlementException {
        Subject adminSubject = this.getAdminSubject();
        String realm = this.getRealm();
        for (IPrivilege p : privileges) {
            String dn = null;
            dn = p instanceof Privilege ? this.delete(p.getName(), true) : this.deleteReferral(p.getName(), true);
            if (indexCacheSize <= 0) continue;
            if (p instanceof Privilege) {
                this.indexCache.clear(p.getResourceSaveIndexes(adminSubject, DNMapper.orgNameToRealmName(realm)), dn);
                continue;
            }
            this.referralIndexCache.clear(p.getResourceSaveIndexes(adminSubject, DNMapper.orgNameToRealmName(realm)), dn);
        }
    }

    @Override
    public String delete(String privilegeName, boolean notify) throws EntitlementException {
        Subject adminSubject = this.getAdminSubject();
        String realm = this.getRealm();
        String dn = DataStore.getPrivilegeDistinguishedName(privilegeName, realm, null);
        if (notify) {
            dataStore.remove(adminSubject, this.realmDN, privilegeName);
        }
        if (policyCacheSize > 0) {
            policyCache.decache(dn, this.realmDN);
        }
        return dn;
    }

    @Override
    public String deleteReferral(String privilegeName, boolean notify) throws EntitlementException {
        Subject adminSubject = this.getAdminSubject();
        String realm = this.getRealm();
        String dn = DataStore.getPrivilegeDistinguishedName(privilegeName, realm, "referrals");
        if (notify) {
            dataStore.removeReferral(adminSubject, realm, privilegeName);
        }
        if (policyCacheSize > 0) {
            referralCache.decache(dn, this.realmDN);
        }
        return dn;
    }

    private void cache(IPrivilege eval, Set<String> subjectSearchIndexes, String realm) throws EntitlementException {
        if (eval instanceof Privilege) {
            this.cache((Privilege)eval, subjectSearchIndexes, realm);
        } else if (eval instanceof ReferralPrivilege) {
            this.cache((ReferralPrivilege)eval, realm);
        }
    }

    private void cache(Privilege p, Set<String> subjectSearchIndexes, String realm) throws EntitlementException {
        String dn = DataStore.getPrivilegeDistinguishedName(p.getName(), realm, null);
        String realmName = DNMapper.orgNameToRealmName(realm);
        this.indexCache.cache(p.getEntitlement().getResourceSaveIndexes(this.superAdminSubject, realmName), subjectSearchIndexes, dn);
        policyCache.cache(dn, p, this.realmDN);
    }

    private void cache(ReferralPrivilege p, String realm) throws EntitlementException {
        String dn = DataStore.getPrivilegeDistinguishedName(p.getName(), realm, "referrals");
        this.referralIndexCache.cache(p.getResourceSaveIndexes(this.superAdminSubject, DNMapper.orgNameToRealmName(realm)), null, dn);
        referralCache.cache(dn, p, this.realmDN);
    }

    @Override
    public Iterator<IPrivilege> search(String realm, ResourceSearchIndexes indexes, Set<String> subjectIndexes, boolean bSubTree) throws EntitlementException {
        ReferralPrivilege ref;
        BufferedIterator iterator = isMultiThreaded ? new BufferedIterator() : new SimpleIterator();
        HashSet<String> setDNs = new HashSet<String>();
        if (indexCacheSize > 0) {
            setDNs.addAll(this.searchPrivileges(indexes, subjectIndexes, bSubTree, iterator));
            setDNs.addAll(this.searchReferrals(indexes, bSubTree, iterator));
        }
        if (DN.isDN((String)realm)) {
            realm = DNMapper.orgNameToRealmName(realm);
        }
        if (realm.equals("/") && (ref = this.getOrgAliasReferral(indexes)) != null) {
            iterator.add((Object)ref);
        }
        if (indexCacheSize == 0 || this.doDSSearch()) {
            SearchTask st = new SearchTask(this, iterator, indexes, subjectIndexes, bSubTree, setDNs);
            threadPool.submit(st);
        } else {
            iterator.isDone();
        }
        return iterator;
    }

    private ReferralPrivilege getOrgAliasReferral(ResourceSearchIndexes indexes) throws EntitlementException {
        ReferralPrivilege result = null;
        SSOToken adminToken = SubjectUtils.getSSOToken(this.superAdminSubject);
        if (OpenSSOIndexStore.isOrgAliasMappingResourceEnabled(adminToken)) {
            try {
                Set<String> realms = this.getReferredRealmNames(adminToken, indexes);
                if (realms != null && !realms.isEmpty()) {
                    HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
                    HashSet<String> res = new HashSet<String>();
                    res.add("http*://" + this.getReferralURL(indexes.getHostIndexes()) + ":*");
                    map.put("iPlanetAMWebAgentService", res);
                    result = new ReferralPrivilege("referralprivilege111", map, realms);
                }
            }
            catch (SSOException e) {
            }
            catch (SMSException e) {
                // empty catch block
            }
        }
        return result;
    }

    private String getReferralURL(Set<String> indexes) {
        int len = -1;
        String result = null;
        for (String s : indexes) {
            if (s.length() <= len) continue;
            result = s;
            len = s.length();
        }
        return result;
    }

    private Set<String> getReferredRealmNames(SSOToken adminToken, ResourceSearchIndexes indexes) throws SMSException, SSOException {
        HashSet<String> searchIndexes = new HashSet<String>();
        for (String s : indexes.getHostIndexes()) {
            if (s.startsWith("://")) {
                s = s.substring(3);
            }
            if (s.length() <= 0) continue;
            searchIndexes.add(s);
        }
        HashSet<String> searchSet = new HashSet<String>();
        searchSet.add(this.getReferralURL(searchIndexes));
        ServiceManager sm = new ServiceManager(adminToken);
        Set realmNames = sm.searchOrganizationNames("sunIdentityRepositoryService", "sunOrganizationAliases", searchSet);
        if (realmNames != null && !realmNames.isEmpty()) {
            HashSet<String> realms = new HashSet<String>();
            for (String r : realmNames) {
                if (!r.startsWith("/")) {
                    r = "/" + r;
                }
                realms.add(r);
            }
            return realms;
        }
        return Collections.EMPTY_SET;
    }

    private boolean doDSSearch() {
        String realm = this.getRealm();
        int cacheEntries = policyCache.getCount(realm);
        int totalPolicies = dataStore.getNumberOfPolicies(realm);
        if (totalPolicies > 0 && cacheEntries < totalPolicies) {
            return true;
        }
        cacheEntries = referralCache.getCount(realm);
        int totalReferrals = dataStore.getNumberOfReferrals(realm);
        return totalReferrals > 0 && cacheEntries < totalReferrals;
    }

    private Set<String> searchReferrals(ResourceSearchIndexes indexes, boolean bSubTree, BufferedIterator iterator) {
        Set<String> setDNs = this.referralIndexCache.getMatchingEntries(indexes, null, bSubTree);
        Iterator<String> i = setDNs.iterator();
        while (i.hasNext()) {
            String dn = i.next();
            ReferralPrivilege r = referralCache.getReferral(dn);
            if (r != null) {
                iterator.add((Object)r);
                continue;
            }
            i.remove();
        }
        return setDNs;
    }

    private Set<String> searchPrivileges(ResourceSearchIndexes indexes, Set<String> subjectIndexes, boolean bSubTree, BufferedIterator iterator) {
        Set<String> setDNs = this.indexCache.getMatchingEntries(indexes, subjectIndexes, bSubTree);
        Iterator<String> i = setDNs.iterator();
        while (i.hasNext()) {
            String dn = i.next();
            Privilege p = policyCache.getPolicy(dn);
            if (p != null) {
                iterator.add((Object)p);
                continue;
            }
            i.remove();
        }
        return setDNs;
    }

    @Override
    public Set<String> searchPrivilegeNames(Set<PrivilegeSearchFilter> filters, boolean boolAnd, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws EntitlementException {
        StringBuffer strFilter = new StringBuffer();
        if (filters.isEmpty()) {
            strFilter.append("(ou=*)");
        } else if (filters.size() == 1) {
            strFilter.append(filters.iterator().next().getFilter());
        } else {
            if (boolAnd) {
                strFilter.append("(&");
            } else {
                strFilter.append("(|");
            }
            for (PrivilegeSearchFilter psf : filters) {
                strFilter.append(psf.getFilter());
            }
            strFilter.append(")");
        }
        Subject adminSubject = this.getAdminSubject();
        String realm = this.getRealm();
        return dataStore.search(adminSubject, realm, strFilter.toString(), numOfEntries, sortResults, ascendingOrder);
    }

    @Override
    public Set<String> searchReferralPrivilegeNames(Set<PrivilegeSearchFilter> filters, boolean boolAnd, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws EntitlementException {
        return this.searchReferralPrivilegeNames(filters, this.getAdminSubject(), this.getRealm(), boolAnd, numOfEntries, sortResults, ascendingOrder);
    }

    public Set<String> searchReferralPrivilegeNames(Set<PrivilegeSearchFilter> filters, Subject adminSubject, String currentRealm, boolean boolAnd, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws EntitlementException {
        StringBuffer strFilter = new StringBuffer();
        if (filters.isEmpty()) {
            strFilter.append("(ou=*)");
        } else if (filters.size() == 1) {
            strFilter.append(filters.iterator().next().getFilter());
        } else {
            if (boolAnd) {
                strFilter.append("(&");
            } else {
                strFilter.append("(|");
            }
            for (PrivilegeSearchFilter psf : filters) {
                strFilter.append(psf.getFilter());
            }
            strFilter.append(")");
        }
        return dataStore.searchReferral(adminSubject, currentRealm, strFilter.toString(), numOfEntries, sortResults, ascendingOrder);
    }

    @Override
    public Set<String> getReferredResources(String applicationTypeName) throws EntitlementException {
        String realm = this.getRealm();
        if (realm.equals("/")) {
            return Collections.EMPTY_SET;
        }
        if (DN.isDN((String)realm)) {
            realm = DNMapper.orgNameToRealmName(realm);
        }
        SSOToken adminToken = SubjectUtils.getSSOToken(this.superAdminSubject);
        try {
            HashSet<String> results = new HashSet<String>();
            Set<String> realms = this.getPeerRealms(realm);
            realms.addAll(this.getParentRealms(realm));
            String filter = "(&(ou=referralappls=" + applicationTypeName + ")(ou=" + "referralrealms" + "=" + realm + "))";
            HashMap<String, Set<ReferralPrivilege>> referrals = new HashMap<String, Set<ReferralPrivilege>>();
            for (String rlm : realms) {
                referrals.put(rlm, dataStore.searchReferrals(adminToken, rlm, filter));
            }
            for (String rlm : referrals.keySet()) {
                Set rPrivileges = (Set)referrals.get(rlm);
                for (ReferralPrivilege r : rPrivileges) {
                    Map<String, Set<String>> map = r.getOriginalMapApplNameToResources();
                    for (String a : map.keySet()) {
                        Application appl = ApplicationManager.getApplication(this.superAdminSubject, rlm, a);
                        if (!appl.getApplicationType().getName().equals(applicationTypeName)) continue;
                        results.addAll((Collection<String>)map.get(a));
                    }
                }
            }
            results.addAll(OpenSSOIndexStore.getOrgAliasMappingResources(realm, applicationTypeName));
            return results;
        }
        catch (SMSException ex) {
            PrivilegeManager.debug.error("OpenSSOIndexStore.getReferredResources", (Throwable)ex);
            Object[] param = new Object[]{realm};
            throw new EntitlementException(275, param);
        }
    }

    private Set<String> getParentRealms(String realm) throws SMSException {
        String name;
        HashSet<String> results = new HashSet<String>();
        SSOToken adminToken = SubjectUtils.getSSOToken(this.superAdminSubject);
        OrganizationConfigManager ocm = new OrganizationConfigManager(adminToken, realm);
        do {
            ocm = ocm.getParentOrgConfigManager();
            name = DNMapper.orgNameToRealmName(ocm.getOrganizationName());
            results.add(name);
        } while (!name.equals("/"));
        return results;
    }

    private Set<String> getPeerRealms(String realm) throws SMSException {
        SSOToken adminToken = SubjectUtils.getSSOToken(this.superAdminSubject);
        OrganizationConfigManager ocm = new OrganizationConfigManager(adminToken, realm);
        OrganizationConfigManager parentOrg = ocm.getParentOrgConfigManager();
        String base = DNMapper.orgNameToRealmName(parentOrg.getOrganizationName());
        if (!base.endsWith("/")) {
            base = base + "/";
        }
        HashSet<String> results = new HashSet<String>();
        Set subrealms = parentOrg.getSubOrganizationNames();
        for (String s : subrealms) {
            results.add(base + s);
        }
        results.remove(this.getRealm());
        return results;
    }

    static Set<String> getOrgAliasMappingResources(String realm, String applicationTypeName) throws SMSException {
        OrganizationConfigManager m;
        Map map;
        Set orgAlias;
        SSOToken adminToken;
        HashSet<String> results = new HashSet<String>();
        if (applicationTypeName.equalsIgnoreCase("iPlanetAMWebAgentService") && OpenSSOIndexStore.isOrgAliasMappingResourceEnabled(adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance())) && (orgAlias = (Set)(map = (m = new OrganizationConfigManager(adminToken, realm)).getAttributes("sunIdentityRepositoryService")).get("sunOrganizationAliases")) != null && !orgAlias.isEmpty()) {
            for (String s : orgAlias) {
                results.add("https://" + s.trim() + ":*");
                results.add("http://" + s.trim() + ":*");
            }
        }
        return results;
    }

    public static boolean isOrgAliasMappingResourceEnabled(SSOToken adminToken) {
        try {
            ServiceSchemaManager ssm = new ServiceSchemaManager("iPlanetAMPolicyConfigService", adminToken);
            ServiceSchema globalSchema = ssm.getGlobalSchema();
            Map map = globalSchema.getAttributeDefaults();
            Set values = (Set)map.get("sun-am-policy-config-org-alias-mapped-resources-enabled");
            if (values != null && !values.isEmpty()) {
                String val = (String)values.iterator().next();
                return Boolean.valueOf(val);
            }
            return false;
        }
        catch (SMSException ex) {
            PrivilegeManager.debug.error("OpenSSOIndexStore.isOrgAliasMappingResourceEnabled", (Throwable)ex);
            return false;
        }
        catch (SSOException ex) {
            PrivilegeManager.debug.error("OpenSSOIndexStore.isOrgAliasMappingResourceEnabled", (Throwable)((Object)ex));
            return false;
        }
    }

    String getRealmDN() {
        return this.realmDN;
    }

    static {
        dataStore = DataStore.getInstance();
        Subject adminSubject = SubjectUtils.createSuperAdminSubject();
        EntitlementConfiguration ec = EntitlementConfiguration.getInstance(adminSubject, "/");
        policyCacheSize = OpenSSOIndexStore.getInteger(ec, "policyCacheSize", 100000);
        if (policyCacheSize > 0) {
            policyCache = new PolicyCache(policyCacheSize);
            referralCache = new PolicyCache(policyCacheSize);
        } else {
            policyCache = null;
            referralCache = null;
        }
        indexCacheSize = OpenSSOIndexStore.getInteger(ec, "indexCacheSize", 100000);
        if (indexCacheSize > 0) {
            indexCaches = new HashMap<String, IndexCache>();
            referralIndexCaches = new HashMap<String, IndexCache>();
        } else {
            indexCaches = null;
            referralIndexCaches = null;
        }
        int threadSize = OpenSSOIndexStore.getInteger(ec, "searchThreadSize", 1);
        isMultiThreaded = threadSize > 1;
        threadPool = isMultiThreaded ? new EntitlementThreadPool(threadSize) : new SequentialThreadPool();
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            ServiceConfigManager serviceConfigManager = new ServiceConfigManager("iPlanetAMPolicyService", adminToken);
            serviceConfigManager.addListener(new EntitlementsListener());
        }
        catch (Exception e) {
            PrivilegeManager.debug.error("OpenSSOIndexStore.init Unable to register for SMS notifications", (Throwable)e);
        }
    }

    static class EntitlementsListener
    implements ServiceListener {
        EntitlementsListener() {
        }

        public void schemaChanged(String serviceName, String version) {
        }

        public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
        }

        public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
            if (type == 2 && (serviceComponent == null || serviceComponent.trim().length() == 0 || serviceComponent.equals("/"))) {
                indexCaches.remove(orgName);
                referralIndexCaches.remove(orgName);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SearchTask
    implements Runnable {
        private OpenSSOIndexStore parent;
        private BufferedIterator iterator;
        private ResourceSearchIndexes indexes;
        private Set<String> subjectIndexes;
        private boolean bSubTree;
        private Set<String> excludeDNs;

        public SearchTask(OpenSSOIndexStore parent, BufferedIterator iterator, ResourceSearchIndexes indexes, Set<String> subjectIndexes, boolean bSubTree, Set<String> excludeDNs) {
            this.parent = parent;
            this.iterator = iterator;
            this.indexes = indexes;
            this.subjectIndexes = subjectIndexes;
            this.bSubTree = bSubTree;
            this.excludeDNs = excludeDNs;
        }

        @Override
        public void run() {
            try {
                Set<IPrivilege> results = dataStore.search(this.parent.getAdminSubject(), this.parent.getRealmDN(), this.iterator, this.indexes, this.subjectIndexes, this.bSubTree, this.excludeDNs);
                if (indexCacheSize > 0) {
                    for (IPrivilege eval : results) {
                        this.parent.cache(eval, (Set<String>)this.subjectIndexes, this.parent.getRealmDN());
                    }
                }
            }
            catch (EntitlementException ex) {
                this.iterator.isDone();
                PrivilegeManager.debug.error("OpenSSOIndexStore.SearchTask.runPolicy", (Throwable)ex);
            }
        }
    }
}

