/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log;

import com.sun.identity.log.QueryElement;
import java.util.ArrayList;

public class LogQuery {
    public static final int MATCH_ALL_CONDITIONS = 1;
    public static final int MATCH_ANY_CONDITION = 2;
    public static final int MOST_RECENT_MAX_RECORDS = -1;
    public static final int ALL_RECORDS = -2;
    private int maxRecord;
    private int globalOperand;
    private ArrayList queries;
    private ArrayList columns;
    private String sortBy;

    public LogQuery() {
        this.maxRecord = -1;
        this.globalOperand = 2;
        this.queries = null;
        this.columns = null;
        this.sortBy = null;
    }

    public LogQuery(int max_record) {
        this.maxRecord = max_record;
        this.globalOperand = 2;
        this.queries = null;
        this.columns = null;
        this.sortBy = null;
    }

    public LogQuery(int max_Record, int matchCriteria, String sortingBy) throws IllegalArgumentException {
        if (max_Record < -2) {
            throw new IllegalArgumentException("max_Record should be greater than LogQuery.ALL_RECORDS");
        }
        this.maxRecord = max_Record;
        if (matchCriteria > 2 || matchCriteria < 1) {
            throw new IllegalArgumentException("matchCriteria should be LogQuery.MATCH_ANY_CONDITION or LogQuery.MATCH_ALL_CONDITIONS");
        }
        this.globalOperand = matchCriteria;
        if (sortingBy != null) {
            this.sortBy = sortingBy;
        }
        this.queries = null;
        this.columns = null;
    }

    public void setGlobalOperand(int no) throws IllegalArgumentException {
        if (no > 2) {
            IllegalArgumentException ie = new IllegalArgumentException("parameter should be LogQuery.MATCH_ANY_CONDITION or LogQuery.MATCH_ALL_CONDITIONS");
            throw ie;
        }
        if (no < 1) {
            IllegalArgumentException ie = new IllegalArgumentException("parameter should be LogQuery.MATCH_ANY_CONDITION or LogQuery.MATCH_ALL_CONDITIONS");
            throw ie;
        }
        this.globalOperand = no;
    }

    public void setMaxRecord(int value) {
        if (value < -2) {
            return;
        }
        this.maxRecord = value;
    }

    public void addQuery(QueryElement qryElement) {
        if (qryElement == null) {
            return;
        }
        if (this.queries == null) {
            this.queries = new ArrayList();
        }
        this.queries.add(qryElement);
    }

    public ArrayList getQueries() {
        return this.queries;
    }

    public int getNumRecordsWanted() {
        return this.maxRecord;
    }

    public int getGlobalOperand() {
        return this.globalOperand;
    }

    public void setSortingField(String fieldName) {
        if (fieldName == null) {
            return;
        }
        this.sortBy = fieldName;
    }

    public String getSortingField() {
        return this.sortBy;
    }

    public void setColumns(ArrayList columns) {
        if (columns == null || columns.isEmpty()) {
            return;
        }
        this.columns = columns;
    }

    public ArrayList getColumns() {
        return this.columns;
    }
}

