/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.ILogRecord;
import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.ITimestampGenerator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Handler;

public class ELFFormatter
extends Formatter {
    private LogManager lmanager = LogManagerUtil.getLogManager();
    private ITimestampGenerator secureTimestampGenerator;
    private final String NOTAVAIL = "Not Available";

    public ELFFormatter() {
        String timestampGeneratorClass = this.lmanager.getProperty("iplanet-am-logging-secure-timestamp-generator");
        try {
            Class<?> clz = Class.forName(timestampGeneratorClass);
            this.secureTimestampGenerator = (ITimestampGenerator)clz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            Debug.error("ELFFormatter: TimeStamp Generator Class not found", cnfe);
        }
        catch (InstantiationException ie) {
            Debug.error("ELFFormatter: Timestamp Generator Could not be Instantiated", ie);
        }
        catch (IllegalAccessException iae) {
            Debug.error("ELFFormatter: Timestamp Generator Could not be Instantiated", iae);
        }
    }

    public String format(LogRecord logRecord) {
        StringBuffer sbuffer = new StringBuffer();
        try {
            String strTime = this.secureTimestampGenerator != null ? this.secureTimestampGenerator.getTimestamp() : "";
            sbuffer.append("\"").append(strTime).append("\"\t");
            StringBuffer message = this.processString(this.formatMessage(logRecord));
            boolean escapeDone = false;
            for (int i = 0; i < message.length(); ++i) {
                if (message.charAt(i) != ' ' && message.charAt(i) != '\t') continue;
                sbuffer.append("\"").append(message).append("\"\t");
                escapeDone = true;
                break;
            }
            if (!escapeDone) {
                sbuffer.append(message).append("\t");
            }
            Map logInfoTable = logRecord.getLogInfoMap();
            String[] allFields = this.lmanager.getAllFields();
            Set selectedFields = this.lmanager.getSelectedFieldSet();
            if (logInfoTable != null) {
                String key = null;
                String value = null;
                for (int i = 2; i < allFields.length; ++i) {
                    key = allFields[i];
                    if (key != null && key.length() != 0 && selectedFields != null && selectedFields.contains(key)) {
                        value = (String)logInfoTable.get(key);
                        if (value != null && value.length() != 0) {
                            StringBuffer valueBuffer = this.processString(value);
                            escapeDone = false;
                            for (int j = 0; j < valueBuffer.length(); ++j) {
                                if (valueBuffer.charAt(j) != ' ' && valueBuffer.charAt(j) != '\t') continue;
                                escapeDone = true;
                                sbuffer.append("\"").append(valueBuffer).append("\"\t");
                                break;
                            }
                            if (escapeDone) continue;
                            sbuffer.append(valueBuffer).append("\t");
                            continue;
                        }
                        sbuffer.append("\"").append("Not Available").append("\"\t");
                        continue;
                    }
                    sbuffer.append("-").append("\t");
                }
            } else {
                for (int i = 2; i < allFields.length; ++i) {
                    sbuffer.append("-").append("\t");
                }
            }
        }
        catch (Exception e) {
            Debug.error("ELFFormatter: Exception in String handling loop", e);
        }
        sbuffer.append("\n");
        return sbuffer.toString();
    }

    public String format(java.util.logging.LogRecord logRecord) {
        if (LogManagerUtil.isAMLoggingMode() && logRecord instanceof ILogRecord) {
            return this.format((LogRecord)logRecord);
        }
        StringBuffer sbuffer = new StringBuffer();
        try {
            String[] allFields;
            String strTime = this.secureTimestampGenerator != null ? this.secureTimestampGenerator.getTimestamp() : "";
            sbuffer.append("\"").append(strTime).append("\"\t");
            boolean escapeDone = false;
            StringBuffer message = this.processString(this.formatMessage(logRecord));
            for (int i = 0; i < message.length(); ++i) {
                if (message.charAt(i) != ' ' && message.charAt(i) != '\t') continue;
                sbuffer.append("\"").append(message).append("\"\t");
                escapeDone = true;
            }
            if (!escapeDone) {
                sbuffer.append(message).append("\t");
            }
            if ((allFields = this.lmanager.getAllFields()) != null) {
                for (int i = 2; i < allFields.length; ++i) {
                    sbuffer.append("-").append("\t");
                }
            }
        }
        catch (Exception e) {
            Debug.error("ELFFormatter: Exception in String handling loop", e);
        }
        sbuffer.append("\n");
        return sbuffer.toString();
    }

    public String getHead(Handler handler) {
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("#Version: 1.0").append("\n");
        sbuffer.append("#Fields: ").append(this.constructHeader()).append("\n");
        return sbuffer.toString();
    }

    public String getTail(Handler handler) {
        return "";
    }

    private String constructHeader() {
        StringBuffer sbuffer = new StringBuffer();
        String[] allFields = this.lmanager.getAllFields();
        for (int i = 0; i < allFields.length; ++i) {
            sbuffer.append(allFields[i]).append("\t");
        }
        return sbuffer.toString();
    }

    private StringBuffer processString(String field) {
        if (field == null || field.length() == 0) {
            return new StringBuffer("Not Available");
        }
        StringBuffer sbuffer = new StringBuffer();
        int len = field.length();
        boolean hasUniqueChar = false;
        for (int i = 0; i < len; ++i) {
            char currentCharacter = field.charAt(i);
            if (currentCharacter == '\"') {
                sbuffer.append("\"\"");
                hasUniqueChar = true;
            }
            if (currentCharacter == '\r') {
                sbuffer.append("\\\\r");
                hasUniqueChar = true;
            }
            if (currentCharacter == '\n') {
                sbuffer.append("\\\\n");
                hasUniqueChar = true;
            }
            if (!hasUniqueChar) {
                sbuffer.append(currentCharacter);
            }
            hasUniqueChar = false;
        }
        return sbuffer;
    }
}

