/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.secure;

import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.secure.SecureLogHelper;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.security.keystore.AMCallbackHandler;
import com.sun.identity.security.keystore.AMPassword;
import com.sun.identity.security.keystore.AMX509KeyManager;
import com.sun.identity.security.keystore.AMX509KeyManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class SecureLogHelperJCEImpl
extends SecureLogHelper {
    private static AMX509KeyManager ksManager = null;

    void initializeKeyStoreManager(AMPassword passwd) throws Exception {
        String keystore = LogManagerUtil.getLogManager().getProperty("iplanet-am-logging-secure-certificate-store");
        ksManager = AMX509KeyManagerFactory.createAMX509KeyManager((String)"JKS", (String)keystore, (String)null, (AMCallbackHandler)passwd);
    }

    public byte[] signMAC(byte[] mac) throws Exception {
        try {
            PrivateKey loggerPrivKey = null;
            try {
                loggerPrivKey = ksManager.getPrivateKey(loggerKey);
            }
            catch (Exception e) {
                Debug.error("SecureLogHelper.signMAC() :  Exception : ", e);
            }
            Signature loggerSign = Signature.getInstance(signingAlgorithm);
            loggerSign.initSign(loggerPrivKey);
            loggerSign.update(mac);
            byte[] signedBytes = loggerSign.sign();
            this.writeToSecretStore(signedBytes, this.logFileName, this.loggerPass, "CurrentSignature");
            return signedBytes;
        }
        catch (Exception e) {
            Debug.error("SecureLogHelper.signMAC() :  Exception : ", e);
            throw new Exception(e.getMessage());
        }
    }

    public boolean verifySignature(byte[] signedObject, byte[] mac) throws Exception {
        try {
            PublicKey loggerPubKey = null;
            X509Certificate[] certs = ksManager.getCertificateChain(loggerKey);
            X509Certificate cert = certs[0];
            loggerPubKey = cert.getPublicKey();
            Signature verifySign = Signature.getInstance(signingAlgorithm);
            verifySign.initVerify(loggerPubKey);
            verifySign.update(mac);
            return verifySign.verify(signedObject);
        }
        catch (Exception e) {
            Debug.error("SecureLogHelper.verifySignature() :  Exception : ", e);
            throw new Exception(e.getMessage());
        }
    }

    byte[] readFromSecretStore(String filename, String dataType, AMPassword password) throws Exception {
        byte[] cryptoData = null;
        File file = new File(filename);
        FileInputStream fis = new FileInputStream(file);
        KeyStore store = KeyStore.getInstance("jceks");
        store.load(fis, password.getChars());
        fis.close();
        KeyStore.PasswordProtection params = new KeyStore.PasswordProtection(password.getChars());
        KeyStore.SecretKeyEntry keyentry = (KeyStore.SecretKeyEntry)store.getEntry(dataType, params);
        if (keyentry != null) {
            SecretKey sdata = keyentry.getSecretKey();
            cryptoData = sdata.getEncoded();
        }
        return cryptoData;
    }

    void writeToSecretStore(byte[] cryptoMaterial, String filename, AMPassword password, String dataType) throws Exception {
        KeyStore store = KeyStore.getInstance("jceks");
        File file = new File(filename);
        if (file.exists()) {
            FileInputStream fis = new FileInputStream(file);
            store.load(fis, password.getChars());
            fis.close();
        } else {
            store.load(null, new char[0]);
        }
        if (store.containsAlias(dataType)) {
            store.deleteEntry(dataType);
        }
        SecretKeySpec data = new SecretKeySpec(cryptoMaterial, "DESede");
        KeyStore.SecretKeyEntry secKeyEntry = new KeyStore.SecretKeyEntry(data);
        KeyStore.PasswordProtection params = new KeyStore.PasswordProtection(password.getChars());
        store.setEntry(dataType, secKeyEntry, params);
        FileOutputStream fos = new FileOutputStream(file);
        store.store(fos, password.getChars());
        fos.close();
    }
}

